/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceTypeImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientType;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceType;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceClientImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeInfo;

public class WebServiceRuntimeExtensionRegistry {
    private static WebServiceRuntimeExtensionRegistry instance_;
    HashMap webServiceTypes_;
    ArrayList webServiceTypesList_;
    ArrayList webServiceClientTypesList_;
    Hashtable webServiceImpls_;
    Hashtable webServiceClientImpls_;
    Hashtable serviceTypes_;
    Hashtable clientTypes_;
    Hashtable webServiceRuntimes_;

    public static WebServiceRuntimeExtensionRegistry getInstance() {
        if (instance_ == null) {
            instance_ = new WebServiceRuntimeExtensionRegistry();
            instance_.load();
        }
        return instance_;
    }

    private void load() {
        this.webServiceTypes_ = new HashMap();
        this.webServiceTypesList_ = new ArrayList();
        this.webServiceClientTypesList_ = new ArrayList();
        this.webServiceImpls_ = new Hashtable();
        this.webServiceClientImpls_ = new Hashtable();
        this.serviceTypes_ = new Hashtable();
        this.clientTypes_ = new Hashtable();
        this.webServiceRuntimes_ = new Hashtable();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "webServiceServerRuntimeType");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            if (elem.getName().equals("webServiceType")) {
                WebServiceTypeImpl wst = new WebServiceTypeImpl(elem);
                this.webServiceTypes_.put(elem.getAttribute("id"), wst);
            }
            ++idx;
        }
        IConfigurationElement[] wsImplExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "wsImpl");
        int idx2 = 0;
        while (idx2 < wsImplExts.length) {
            IConfigurationElement elem = wsImplExts[idx2];
            if (elem.getName().equals("webServiceImpl")) {
                WebServiceImpl wsimpl = new WebServiceImpl(elem);
                this.webServiceImpls_.put(elem.getAttribute("id"), wsimpl);
            }
            ++idx2;
        }
        IConfigurationElement[] wsClientImplExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "wsClientImpl");
        int idx3 = 0;
        while (idx3 < wsClientImplExts.length) {
            IConfigurationElement elem = wsClientImplExts[idx3];
            if (elem.getName().equals("webServiceClientImpl")) {
                WebServiceClientImpl wsClientImpl = new WebServiceClientImpl(elem);
                this.webServiceClientImpls_.put(elem.getAttribute("id"), wsClientImpl);
            }
            ++idx3;
        }
        IConfigurationElement[] serviceTypeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "serviceType");
        int idx4 = 0;
        while (idx4 < serviceTypeExts.length) {
            IConfigurationElement elem = serviceTypeExts[idx4];
            if (elem.getName().equals("serviceType")) {
                ServiceType st = new ServiceType(elem, this.webServiceImpls_, this.webServiceTypes_);
                this.serviceTypes_.put(elem.getAttribute("id"), st);
            }
            ++idx4;
        }
        IConfigurationElement[] clientTypeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "clientType");
        int idx5 = 0;
        while (idx5 < clientTypeExts.length) {
            IConfigurationElement elem = clientTypeExts[idx5];
            if (elem.getName().equals("clientType")) {
                ClientType ct = new ClientType(elem, this.webServiceClientImpls_);
                this.clientTypes_.put(elem.getAttribute("id"), ct);
            }
            ++idx5;
        }
        IConfigurationElement[] wsrtExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "webServiceRuntime");
        int idx6 = 0;
        while (idx6 < wsrtExts.length) {
            IConfigurationElement elem = wsrtExts[idx6];
            if (elem.getName().equals("webServiceRuntime")) {
                WebServiceRuntimeInfo wsrtInfo = new WebServiceRuntimeInfo(elem, this.serviceTypes_, this.clientTypes_);
                this.webServiceRuntimes_.put(elem.getAttribute("id"), wsrtInfo);
                this.updateWebServiceTypeList(wsrtInfo);
                this.updateWebServiceClientTypeList(wsrtInfo);
            }
            ++idx6;
        }
    }

    private void updateWebServiceTypeList(WebServiceRuntimeInfo wsrtInfo) {
        ServiceType[] sts = wsrtInfo.getServiceTypes();
        if (sts != null) {
            int j = 0;
            while (j < sts.length) {
                String entry;
                StringBuffer entrybuff;
                String implId = sts[j].getWebServiceImpl().getId();
                String[] bus = sts[j].getBottomUpModuleTypesInclude();
                String[] tds = sts[j].getTopDownModuleTypesInclude();
                if (bus != null) {
                    entrybuff = new StringBuffer();
                    entrybuff.append(String.valueOf(0));
                    entrybuff.append("/");
                    entrybuff.append(implId);
                    entry = entrybuff.toString();
                    if (!this.webServiceTypesList_.contains(entry)) {
                        this.webServiceTypesList_.add(entry);
                    }
                }
                if (tds != null) {
                    entrybuff = new StringBuffer();
                    entrybuff.append(String.valueOf(1));
                    entrybuff.append("/");
                    entrybuff.append(implId);
                    entry = entrybuff.toString();
                    if (!this.webServiceTypesList_.contains(entry)) {
                        this.webServiceTypesList_.add(entry);
                    }
                }
                ++j;
            }
        }
    }

    private void updateWebServiceClientTypeList(WebServiceRuntimeInfo wsrtInfo) {
        ClientType[] cts = wsrtInfo.getClientTypes();
        if (cts != null) {
            int j = 0;
            while (j < cts.length) {
                String implId = cts[j].getWebServiceClientImpl().getId();
                String[] mods = cts[j].getModuleTypesInclude();
                if (mods != null) {
                    StringBuffer entrybuff = new StringBuffer();
                    entrybuff.append(String.valueOf(2));
                    entrybuff.append("/");
                    entrybuff.append(implId);
                    String entry = entrybuff.toString();
                    if (!this.webServiceClientTypesList_.contains(entry)) {
                        this.webServiceClientTypesList_.add(entry);
                    }
                }
                ++j;
            }
        }
    }
}

