/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ClientServerSelectionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ServerSelectionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeInfo;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.provisional.wsrt.IContext;
import org.eclipse.wst.ws.internal.provisional.wsrt.ISelection;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebServiceClient;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceClientInfo;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceScenario;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceState;
import org.eclipse.wst.ws.internal.wsrt.SimpleContext;

public class ClientRuntimeSelectionWidgetDefaultingCommand
extends SimpleCommand {
    protected MessageUtils msgUtils_;
    private WSRuntimeJ2EEType clientRuntimeJ2EEType_;
    private TypeRuntimeServer clientIds_;
    private SelectionListChoices runtimeClientTypes_;
    private String clientComponentName_;
    private String clientEarComponentName_;
    private Environment environment_;
    private IContext context_;
    private ISelection selection_;
    private IWebServiceClient webServiceClient_;
    private ResourceContext resourceContext_;
    private boolean test_;
    private IStructuredSelection clientInitialSelection_;
    private IProject clientInitialProject_;
    private String clientInitialComponentName_;
    private IStructuredSelection initialInitialSelection_;
    private IProject initialInitialProject_;
    private String initialInitialComponentName_;
    private String clientJ2EEVersion_;
    protected boolean clientNeedEAR_ = true;
    private String wsdlURI_;
    private WebServicesParser parser_;

    public ClientRuntimeSelectionWidgetDefaultingCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientIds_ = ids;
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientIds_;
    }

    public SelectionListChoices getRuntime2ClientTypes() {
        return this.runtimeClientTypes_;
    }

    public String getClientProjectName() {
        return this.getRuntime2ClientTypes().getChoice().getChoice().getList().getSelection();
    }

    public String getClientEarProjectName() {
        return this.getRuntime2ClientTypes().getChoice().getChoice().getChoice().getList().getSelection();
    }

    public String getClientComponentName() {
        return this.clientComponentName_;
    }

    public String getClientEarComponentName() {
        return this.clientEarComponentName_;
    }

    protected void setClientEARComponentName(String name) {
        this.clientEarComponentName_ = name;
    }

    public String getClientComponentType() {
        return this.getRuntime2ClientTypes().getChoice().getList().getSelection();
    }

    public String getClientJ2EEVersion() {
        return this.clientJ2EEVersion_;
    }

    public IWebServiceClient getWebService() {
        return this.webServiceClient_;
    }

    public Environment getEnvironment() {
        return this.environment_;
    }

    public IContext getContext() {
        return this.context_;
    }

    public ISelection getSelection() {
        return this.selection_;
    }

    public Status execute(Environment environment) {
        try {
            ValidationUtils vu;
            String[] runtimeIds = WebServiceRuntimeExtensionUtils.getRuntimesByClientType(this.clientIds_.getTypeId());
            SelectionList list = new SelectionList(runtimeIds, 0);
            Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
            int i = 0;
            while (i < runtimeIds.length) {
                choices.add(this.getClientTypesChoice(runtimeIds[i]));
                ++i;
            }
            this.runtimeClientTypes_ = new SelectionListChoices(list, choices);
            this.setClientDefaultRuntimeFromPreference();
            this.setClientDefaultJ2EEVersionFromPreference();
            this.setClientComponentType();
            this.clientRuntimeJ2EEType_ = this.getClientRuntimeAndJ2EEFromProject(this.clientInitialProject_, this.clientInitialComponentName_);
            if (this.clientRuntimeJ2EEType_ != null) {
                this.clientJ2EEVersion_ = this.clientRuntimeJ2EEType_.getJ2eeVersionId();
                this.setClientRuntimeId(this.clientRuntimeJ2EEType_.getWsrId());
                this.setClientProjectType(this.clientRuntimeJ2EEType_.getClientProjectTypeId());
            }
            if ((vu = new ValidationUtils()).isProjectServiceProject(this.clientInitialProject_, this.wsdlURI_, this.parser_)) {
                this.clientRuntimeJ2EEType_ = this.getClientRuntimeAndJ2EEFromProject(this.initialInitialProject_, this.initialInitialComponentName_);
                if (this.clientRuntimeJ2EEType_ != null) {
                    this.clientJ2EEVersion_ = this.clientRuntimeJ2EEType_.getJ2eeVersionId();
                    this.setClientRuntimeId(this.clientRuntimeJ2EEType_.getWsrId());
                    this.setClientProjectType(this.clientRuntimeJ2EEType_.getClientProjectTypeId());
                    this.clientInitialProject_ = this.initialInitialProject_;
                    this.clientInitialComponentName_ = this.initialInitialComponentName_;
                }
            }
            this.setClientDefaultProject();
            this.setClientDefaultEAR();
            Status serverStatus = this.setClientDefaultServer();
            if (serverStatus.getSeverity() == 4) {
                environment.getStatusHandler().reportError(serverStatus);
                return serverStatus;
            }
            this.updateClientEARs();
            this.setDefaultsForExtension(environment);
            return new SimpleStatus("");
        }
        catch (Exception e) {
            SimpleStatus errorStatus = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_TASK_EXCEPTED", (Object[])new String[]{e.getMessage()}), 4, (Throwable)e);
            environment.getStatusHandler().reportError((Status)errorStatus);
            return errorStatus;
        }
    }

    private SelectionListChoices getClientTypesChoice(String runtimeId) {
        String[] clientComponentTypes = WebServiceRuntimeExtensionUtils.getClientProjectTypes(this.clientIds_.getTypeId(), runtimeId);
        SelectionList list = new SelectionList(clientComponentTypes, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int i = 0;
        while (i < clientComponentTypes.length) {
            choices.add(this.getProjectChoice(clientComponentTypes[i]));
            ++i;
        }
        return new SelectionListChoices(list, choices);
    }

    private SelectionListChoices getProjectChoice(String clientType) {
        String[] projectNames = J2EEUtils.getProjectsContainingComponentOfType((String)clientType);
        SelectionList list = new SelectionList(projectNames, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int i = 0;
        while (i < projectNames.length) {
            IProject project = ProjectUtilities.getProject((String)projectNames[i]);
            choices.add(this.getProjectEARChoice(project));
            ++i;
        }
        return new SelectionListChoices(list, choices, this.getEARProjects());
    }

    protected SelectionListChoices getProjectEARChoice(IProject project) {
        String[] flexProjects = this.getAllFlexibleProjects();
        SelectionList list = new SelectionList(flexProjects, 0);
        return new SelectionListChoices(list, null);
    }

    protected SelectionList getEARProjects() {
        String[] flexProjects = this.getAllFlexibleProjects();
        return new SelectionList(flexProjects, 0);
    }

    private void setClientDefaultRuntimeFromPreference() {
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String pRuntimeId = context.getRuntimeId();
        this.setClientRuntimeId(pRuntimeId);
    }

    private void setClientRuntimeId(String id) {
        String[] clientRuntimeIds = this.getRuntime2ClientTypes().getList().getList();
        int i = 0;
        while (i < clientRuntimeIds.length) {
            if (clientRuntimeIds[i].equals(id)) {
                this.getClientTypeRuntimeServer().setRuntimeId(id);
                this.getRuntime2ClientTypes().getList().setIndex(i);
                break;
            }
            ++i;
        }
    }

    private void setClientProjectType(String id) {
        String[] clientProjectTypeIds = this.getRuntime2ClientTypes().getChoice().getList().getList();
        int i = 0;
        while (i < clientProjectTypeIds.length) {
            if (clientProjectTypeIds[i].equals(id)) {
                this.getRuntime2ClientTypes().getChoice().getList().setIndex(i);
                break;
            }
            ++i;
        }
    }

    protected void setClientDefaultJ2EEVersionFromPreference() {
        String[] versions;
        WebServiceRuntimeInfo wsrt;
        String runtimeId;
        if (this.clientIds_ != null && (runtimeId = this.clientIds_.getRuntimeId()) != null && (wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId)) != null && (versions = wsrt.getJ2eeLevels()) != null && versions.length > 0) {
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String pJ2EE = context.getJ2EEVersion();
            if (pJ2EE != null && pJ2EE.length() > 0) {
                int i = 0;
                while (i < versions.length) {
                    if (versions[i].equals(pJ2EE)) {
                        this.clientJ2EEVersion_ = versions[i];
                        return;
                    }
                    ++i;
                }
            }
            this.clientJ2EEVersion_ = versions[0];
            return;
        }
    }

    private WSRuntimeJ2EEType getClientRuntimeAndJ2EEFromProject(IProject project, String componentName) {
        WSRuntimeJ2EEType cRJ2EE = null;
        if (project != null && project.exists()) {
            boolean isValidComponentType = false;
            if (componentName != null && componentName.length() > 0) {
                boolean bl = isValidComponentType = J2EEUtils.isWebComponent((IProject)project, (String)componentName) || J2EEUtils.isEJBComponent((IProject)project, (String)componentName) || J2EEUtils.isAppClientComponent((IProject)project, (String)componentName) || J2EEUtils.isJavaComponent((IProject)project, (String)componentName);
            }
            if (isValidComponentType) {
                String versionString = null;
                if (!J2EEUtils.isJavaComponent((IProject)project, (String)componentName)) {
                    int versionId = J2EEUtils.getJ2EEVersion((IProject)project, (String)componentName);
                    versionString = String.valueOf(versionId);
                }
                IRuntime runtimeTarget = ServerSelectionUtils.getRuntimeTarget(project.getName());
                String runtimeTargetId = null;
                if (runtimeTarget != null) {
                    runtimeTargetId = runtimeTarget.getRuntimeType().getId();
                }
                String clientComponentTypeId = J2EEUtils.getComponentTypeId((IProject)project, (String)componentName);
                if ((versionString == null || WebServiceRuntimeExtensionUtils.doesRuntimeSupportJ2EELevel(versionString, this.clientIds_.getRuntimeId())) && (runtimeTarget == null || runtimeTarget != null && WebServiceRuntimeExtensionUtils.doesRuntimeSupportServerTarget(runtimeTargetId, this.clientIds_.getRuntimeId())) && WebServiceRuntimeExtensionUtils.doesRuntimeSupportComponentType(this.clientIds_.getTypeId(), this.clientIds_.getRuntimeId(), clientComponentTypeId)) {
                    cRJ2EE = new WSRuntimeJ2EEType();
                    cRJ2EE.setJ2eeVersionId(versionString);
                    cRJ2EE.setWsrId(this.clientIds_.getRuntimeId());
                    cRJ2EE.setClientProjectTypeId(clientComponentTypeId);
                    return cRJ2EE;
                }
                String[] validRuntimes = WebServiceRuntimeExtensionUtils.getRuntimesByClientType(this.clientIds_.getTypeId());
                int i = 0;
                while (i < validRuntimes.length) {
                    if ((versionString == null || WebServiceRuntimeExtensionUtils.doesRuntimeSupportJ2EELevel(versionString, validRuntimes[i])) && (runtimeTarget == null || runtimeTarget != null && WebServiceRuntimeExtensionUtils.doesRuntimeSupportServerTarget(runtimeTargetId, validRuntimes[i])) && WebServiceRuntimeExtensionUtils.doesRuntimeSupportComponentType(this.clientIds_.getTypeId(), validRuntimes[i], clientComponentTypeId)) {
                        cRJ2EE = new WSRuntimeJ2EEType();
                        cRJ2EE.setJ2eeVersionId(versionString);
                        cRJ2EE.setWsrId(validRuntimes[i]);
                        cRJ2EE.setClientProjectTypeId(clientComponentTypeId);
                        return cRJ2EE;
                    }
                    ++i;
                }
            }
        }
        return cRJ2EE;
    }

    private void setClientComponentType() {
        this.getRuntime2ClientTypes().getChoice().getList().setIndex(0);
    }

    private void setClientDefaultProject() {
        if (this.clientInitialProject_ == null || this.clientInitialProject_ != null && this.clientRuntimeJ2EEType_ == null) {
            this.setClientProjectToFirstValid();
            return;
        }
        ValidationUtils vu = new ValidationUtils();
        if (!vu.isProjectServiceProject(this.clientInitialProject_, this.wsdlURI_, this.parser_)) {
            this.getRuntime2ClientTypes().getChoice().getChoice().getList().setSelectionValue(this.clientInitialProject_.getName());
            this.clientComponentName_ = this.clientInitialComponentName_;
        } else {
            this.setClientProjectToFirstValid();
        }
    }

    private void setClientProjectToFirstValid() {
        ValidationUtils vu = new ValidationUtils();
        String[] projectNames = this.getRuntime2ClientTypes().getChoice().getChoice().getList().getList();
        int i = 0;
        while (i < projectNames.length) {
            IProject project = ProjectUtilities.getProject((String)projectNames[i]);
            IVirtualComponent[] vcs = J2EEUtils.getComponentsByType((IProject)project, (String)this.getClientComponentType());
            if (project.isOpen() && vcs != null && vcs.length > 0) {
                IRuntime runtimeTarget = ServerSelectionUtils.getRuntimeTarget(project.getName());
                String runtimeTargetId = null;
                if (runtimeTarget != null) {
                    runtimeTargetId = runtimeTarget.getRuntimeType().getId();
                }
                int j = 0;
                while (j < vcs.length) {
                    int versionId = J2EEUtils.getJ2EEVersion((IVirtualComponent)vcs[j]);
                    String versionString = String.valueOf(versionId);
                    if (this.clientJ2EEVersion_ != null && this.clientJ2EEVersion_.length() > 0 && this.clientJ2EEVersion_.equals(versionString) && WebServiceRuntimeExtensionUtils.doesRuntimeSupportJ2EELevel(versionString, this.clientIds_.getRuntimeId()) && (runtimeTarget == null || runtimeTarget != null && WebServiceRuntimeExtensionUtils.doesRuntimeSupportServerTarget(runtimeTargetId, this.clientIds_.getRuntimeId())) && !vu.isProjectServiceProject(project, this.wsdlURI_, this.parser_)) {
                        this.getRuntime2ClientTypes().getChoice().getChoice().getList().setSelectionValue(projectNames[i]);
                        this.clientComponentName_ = vcs[j].getName();
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.getRuntime2ClientTypes().getChoice().getChoice().getList().setSelectionValue(ResourceUtils.getDefaultWebProjectName());
        this.clientComponentName_ = ResourceUtils.getDefaultWebProjectName();
    }

    protected IResource getResourceFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                return resource;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    private void setClientDefaultEAR() {
        String initialClientProjectName = this.getRuntime2ClientTypes().getChoice().getChoice().getList().getSelection();
        IProject initialClientProject = ProjectUtilities.getProject((String)initialClientProjectName);
        String[] clientEARInfo = this.getDefaultEARFromClientProject(initialClientProject, this.clientComponentName_);
        this.getRuntime2ClientTypes().getChoice().getChoice().getChoice().getList().setSelectionValue(clientEARInfo[0]);
        this.clientEarComponentName_ = clientEARInfo[1];
    }

    protected String[] getDefaultEARFromClientProject(IProject project, String componentName) {
        String[] projectAndComp = new String[2];
        IVirtualComponent[] earComps = J2EEUtils.getReferencingEARComponents((IProject)project, (String)componentName);
        if (earComps.length > 0) {
            IVirtualComponent earComp = earComps[0];
            projectAndComp[0] = earComp.getProject().getName();
            projectAndComp[1] = earComp.getName();
            return projectAndComp;
        }
        IVirtualComponent[] allEarComps = J2EEUtils.getAllEARComponents();
        if (allEarComps.length > 0) {
            int i = 0;
            while (i < allEarComps.length) {
                if (this.clientJ2EEVersion_.equals(String.valueOf(J2EEUtils.getJ2EEVersion((IVirtualComponent)allEarComps[i])))) {
                    String earProjectName;
                    projectAndComp[0] = earProjectName = allEarComps[i].getProject().getName();
                    projectAndComp[1] = allEarComps[i].getName();
                    return projectAndComp;
                }
                ++i;
            }
            projectAndComp[0] = ResourceUtils.getDefaultClientEARProjectName();
            projectAndComp[1] = ResourceUtils.getDefaultClientEARComponentName();
            return projectAndComp;
        }
        projectAndComp[0] = ResourceUtils.getDefaultClientEARProjectName();
        projectAndComp[1] = ResourceUtils.getDefaultClientEARComponentName();
        return projectAndComp;
    }

    private void setClientDefaultServerNew() {
        String initialClientProjectName = this.runtimeClientTypes_.getChoice().getChoice().getList().getSelection();
        IRuntime runtimeTarget = ServerSelectionUtils.getRuntimeTarget(initialClientProjectName);
        String runtimeTargetId = null;
        if (runtimeTarget != null) {
            String[] factoryIds;
            runtimeTargetId = runtimeTarget.getRuntimeType().getId();
            IServer[] servers = ServerSelectionUtils.getCompatibleExistingServers(runtimeTarget);
            if (servers != null && servers.length > 0) {
                int i = 0;
                if (i < servers.length) {
                    String thisFactoryId = servers[0].getServerType().getId();
                    this.clientIds_.setServerId(thisFactoryId);
                    this.clientIds_.setServerInstanceId(servers[0].getId());
                    return;
                }
            }
            if ((factoryIds = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(this.clientIds_.getRuntimeId()).getServerFactoryIds()) != null && factoryIds.length > 0) {
                int i = 0;
                while (i < factoryIds.length) {
                    String serverRuntimeTypeId;
                    IServerType serverType = ServerCore.findServerType((String)factoryIds[i]);
                    if (serverType != null && (serverRuntimeTypeId = serverType.getRuntimeType().getId()).equals(runtimeTargetId)) {
                        this.clientIds_.setServerId(factoryIds[i]);
                        return;
                    }
                    ++i;
                }
            } else {
                IServerType[] serverTypes = ServerCore.getServerTypes();
                this.clientIds_.setServerId(serverTypes[0].getId());
            }
        } else {
            String[] fids = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(this.clientIds_.getRuntimeId()).getServerFactoryIds();
            if (fids != null && fids.length > 0) {
                this.clientIds_.setServerId(fids[0]);
            } else {
                IServerType[] serverTypes = ServerCore.getServerTypes();
                this.clientIds_.setServerId(serverTypes[0].getId());
            }
        }
    }

    private Status setClientDefaultServer() {
        SimpleStatus status = new SimpleStatus("");
        String initialClientProjectName = this.runtimeClientTypes_.getChoice().getChoice().getList().getSelection();
        IProject initialClientProject = ProjectUtilities.getProject((String)initialClientProjectName);
        if (initialClientProject.exists()) {
            String[] serverInfo = ServerSelectionUtils.getServerInfoFromExistingProject(initialClientProject, this.clientComponentName_, this.clientIds_.getRuntimeId(), true);
            if (serverInfo != null) {
                if (serverInfo[0] != null && serverInfo[0].length() > 0) {
                    this.clientIds_.setServerId(serverInfo[0]);
                }
                if (serverInfo[1] != null && serverInfo[1].length() > 0) {
                    this.clientIds_.setServerInstanceId(serverInfo[1]);
                }
            }
        } else {
            String initialClientEARProjectName = this.runtimeClientTypes_.getChoice().getChoice().getChoice().getList().getSelection();
            IProject initialClientEARProject = ProjectUtilities.getProject((String)initialClientEARProjectName);
            if (initialClientEARProject.exists()) {
                String[] serverInfo = ServerSelectionUtils.getServerInfoFromExistingProject(initialClientEARProject, this.clientEarComponentName_, this.clientIds_.getRuntimeId(), false);
                if (serverInfo != null) {
                    if (serverInfo[0] != null && serverInfo[0].length() > 0) {
                        this.clientIds_.setServerId(serverInfo[0]);
                    }
                    if (serverInfo[1] != null && serverInfo[1].length() > 0) {
                        this.clientIds_.setServerInstanceId(serverInfo[1]);
                    }
                }
            } else {
                String[] serverInfo = ServerSelectionUtils.getServerFromWebServceRuntimeAndJ2EE(this.clientIds_.getRuntimeId(), this.clientJ2EEVersion_);
                if (serverInfo != null) {
                    if (serverInfo[0] != null && serverInfo[0].length() > 0) {
                        this.clientIds_.setServerId(serverInfo[0]);
                    }
                    if (serverInfo[1] != null && serverInfo[1].length() > 0) {
                        this.clientIds_.setServerInstanceId(serverInfo[1]);
                    }
                } else {
                    String[] versions;
                    boolean foundServer = false;
                    WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(this.clientIds_.getRuntimeId());
                    if (wsrt != null && (versions = wsrt.getJ2eeLevels()) != null && versions.length > 0) {
                        int k = 0;
                        while (k < versions.length) {
                            String[] si;
                            if (this.clientJ2EEVersion_ != versions[k] && (si = ServerSelectionUtils.getServerFromWebServceRuntimeAndJ2EE(this.clientIds_.getRuntimeId(), versions[k])) != null) {
                                if (si[0] != null && si[0].length() > 0) {
                                    this.clientIds_.setServerId(si[0]);
                                }
                                if (si[1] != null && si[1].length() > 0) {
                                    this.clientIds_.setServerInstanceId(si[1]);
                                }
                                this.clientJ2EEVersion_ = versions[k];
                                foundServer = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (!foundServer) {
                        String runtimeLabel = WebServiceRuntimeExtensionUtils.getRuntimeLabelById(this.clientIds_.getRuntimeId());
                        String serverLabels = this.getServerLabels(this.clientIds_.getRuntimeId());
                        status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_NO_SERVER_RUNTIME", (Object[])new String[]{runtimeLabel, serverLabels}), 4);
                    }
                }
            }
        }
        return status;
    }

    protected String getServerLabels(String runtimeId) {
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        String[] validServerFactoryIds = wsrt.getServerFactoryIds();
        StringBuffer validServerLabels = new StringBuffer();
        int i = 0;
        while (i < validServerFactoryIds.length) {
            if (i > 0) {
                validServerLabels.append(", ");
            }
            validServerLabels.append(WebServiceRuntimeExtensionUtils.getServerLabelById(validServerFactoryIds[i]));
            ++i;
        }
        return validServerLabels.toString();
    }

    protected void updateClientProject(String projectName, String componentName, String serviceTypeId) {
        boolean isEJB = false;
        String implId = WebServiceRuntimeExtensionUtils.getImplIdFromTypeId(serviceTypeId);
        isEJB = implId.equals("org.eclipse.jst.ws.wsImpl.ejb");
        String[] updatedNames = ResourceUtils.getClientProjectComponentName((String)projectName, (String)componentName, (boolean)isEJB);
        this.getRuntime2ClientTypes().getChoice().getChoice().getList().setSelectionValue(updatedNames[0]);
        this.clientComponentName_ = updatedNames[1];
    }

    protected void updateClientEARs() {
        String clientProjectName = this.getRuntime2ClientTypes().getChoice().getChoice().getList().getSelection();
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        if (clientProject != null && clientProject.exists()) {
            IRuntime clientTarget = ClientServerSelectionUtils.getRuntimeTarget(clientProjectName);
            String j2eeVersion = String.valueOf(J2EEUtils.getJ2EEVersion((IProject)clientProject, (String)this.clientComponentName_));
            if (clientTarget != null && !ServerUtils.isTargetValidForEAR((String)clientTarget.getRuntimeType().getId(), (String)j2eeVersion)) {
                this.getRuntime2ClientTypes().getChoice().getChoice().getChoice().getList().setIndex(-1);
                this.clientEarComponentName_ = "";
                this.clientNeedEAR_ = false;
            }
        } else {
            String clientServerTargetId;
            String serverId = this.clientIds_.getServerId();
            if (serverId != null && (clientServerTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverId)) != null && clientServerTargetId.length() > 0 && !ServerUtils.isTargetValidForEAR((String)clientServerTargetId, (String)this.clientJ2EEVersion_)) {
                this.getRuntime2ClientTypes().getChoice().getChoice().getChoice().getList().setIndex(-1);
                this.clientEarComponentName_ = "";
                this.clientNeedEAR_ = false;
            }
        }
    }

    private void setDefaultsForExtension(Environment env) {
        IWebServiceRuntime wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntime(this.clientIds_.getRuntimeId());
        if (wsrt != null) {
            WebServiceClientInfo wsInfo = new WebServiceClientInfo();
            wsInfo.setJ2eeLevel(this.clientJ2EEVersion_);
            wsInfo.setServerFactoryId(this.clientIds_.getServerId());
            wsInfo.setServerInstanceId(this.clientIds_.getServerInstanceId());
            wsInfo.setState(WebServiceState.UNKNOWN_LITERAL);
            wsInfo.setWebServiceRuntimeId(this.clientIds_.getRuntimeId());
            wsInfo.setWsdlURL(this.wsdlURI_);
            this.environment_ = env;
            this.webServiceClient_ = wsrt.getWebServiceClient(wsInfo);
            WebServiceScenario scenario = WebServiceScenario.CLIENT_LITERAL;
            if (this.resourceContext_ != null) {
                this.context_ = new SimpleContext(true, true, true, true, true, true, this.test_, false, scenario, this.resourceContext_.isOverwriteFilesEnabled(), this.resourceContext_.isCreateFoldersEnabled(), this.resourceContext_.isCheckoutFilesEnabled());
            }
        }
    }

    public void setClientInitialSelection(IStructuredSelection selection) {
        this.clientInitialSelection_ = selection;
        if (this.clientInitialProject_ == null) {
            this.clientInitialProject_ = this.getProjectFromInitialSelection(selection);
            this.clientInitialComponentName_ = this.getComponentNameFromInitialSelection(selection);
        }
    }

    public void setClientInitialProject(IProject clientInitialProject) {
        this.clientInitialProject_ = clientInitialProject;
    }

    public void setClientInitialComponentName(String name) {
        this.clientInitialComponentName_ = name;
    }

    public void setInitialInitialSelection(IStructuredSelection initialInitialSelection) {
        this.initialInitialSelection_ = initialInitialSelection;
        this.initialInitialProject_ = this.getProjectFromInitialSelection(initialInitialSelection);
        this.initialInitialComponentName_ = this.getComponentNameFromInitialSelection(initialInitialSelection);
    }

    public boolean getClientNeedEAR() {
        return this.clientNeedEAR_;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.parser_ = parser;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI_ = wsdlURI;
    }

    public void setTestService(boolean testService) {
        this.test_ = testService;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext_ = resourceContext;
    }

    private IProject getProjectFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
                return p;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    private String getComponentNameFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
                if (comp != null) {
                    return comp.getName();
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected String[] getAllFlexibleProjects() {
        Vector<String> v = new Vector<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].getName().equals("Servers") && !projects[i].getName().startsWith(".")) {
                v.add(projects[i].getName());
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    protected class WSRuntimeJ2EEType {
        private String wsrId_;
        private String j2eeVersionId_;
        private String clientProjectTypeId;

        public String getJ2eeVersionId() {
            return this.j2eeVersionId_;
        }

        public void setJ2eeVersionId(String versionId_) {
            this.j2eeVersionId_ = versionId_;
        }

        public String getWsrId() {
            return this.wsrId_;
        }

        public void setWsrId(String wsrId_) {
            this.wsrId_ = wsrId_;
        }

        public String getClientProjectTypeId() {
            return this.clientProjectTypeId;
        }

        public void setClientProjectTypeId(String clientProjectTypeId) {
            this.clientProjectTypeId = clientProjectTypeId;
        }
    }
}

