/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.extension;

import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.ws.internal.provisional.wsrt.IContext;
import org.eclipse.wst.ws.internal.provisional.wsrt.ISelection;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebService;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebServiceClient;
import org.eclipse.wst.ws.internal.provisional.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceClientInfo;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceScenario;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceState;
import org.eclipse.wst.ws.internal.wsrt.SimpleContext;

public class PreClientDevelopCommand
extends SimpleCommand {
    private TypeRuntimeServer typeRuntimeServer_;
    private Environment environment_;
    private IContext context_;
    private ISelection selection_;
    private String project_;
    private String module_;
    private String moduleType_;
    private String earProject_;
    private String ear_;
    private IWebServiceClient webServiceClient_;
    private String j2eeLevel_;
    private ResourceContext resourceContext_;
    private boolean test_;
    private String wsdlURI_;
    private Object dataObject_;

    public Status execute(Environment environment) {
        int earIndex;
        int index = this.module_.indexOf("/");
        if (index != -1) {
            this.project_ = this.module_.substring(0, index);
            this.module_ = this.module_.substring(index + 1);
        }
        if (this.ear_ != null && this.ear_.length() > 0 && (earIndex = this.ear_.indexOf("/")) != -1) {
            this.earProject_ = this.ear_.substring(0, earIndex);
            this.ear_ = this.ear_.substring(earIndex + 1);
        }
        IWebServiceRuntime wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntime(this.typeRuntimeServer_.getRuntimeId());
        WebServiceClientInfo wsInfo = new WebServiceClientInfo();
        System.out.println("In Pre client develop command.");
        wsInfo.setJ2eeLevel(this.j2eeLevel_);
        wsInfo.setServerFactoryId(this.typeRuntimeServer_.getServerId());
        wsInfo.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
        wsInfo.setState(WebServiceState.UNKNOWN_LITERAL);
        wsInfo.setWebServiceRuntimeId(this.typeRuntimeServer_.getRuntimeId());
        wsInfo.setWsdlURL(this.wsdlURI_);
        this.environment_ = environment;
        this.webServiceClient_ = wsrt.getWebServiceClient(wsInfo);
        WebServiceScenario scenario = WebServiceScenario.CLIENT_LITERAL;
        this.context_ = new SimpleContext(true, true, true, true, true, true, this.test_, false, scenario, this.resourceContext_.isOverwriteFilesEnabled(), this.resourceContext_.isCreateFoldersEnabled(), this.resourceContext_.isCheckoutFilesEnabled());
        int intModuleType = this.convertModuleType(this.moduleType_);
        CreateModuleCommand command = new CreateModuleCommand();
        command.setProjectName(this.project_);
        command.setModuleName(this.module_);
        command.setModuleType(intModuleType);
        command.setServerFactoryId(this.typeRuntimeServer_.getServerId());
        command.setJ2eeLevel(this.j2eeLevel_);
        Status status = command.execute(environment);
        command.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    private int convertModuleType(String type) {
        if (type.equals("jst.web")) {
            return 1;
        }
        if (type.equals("jst.ejb")) {
            return 2;
        }
        if (type.equals("jst.appclient")) {
            return 4;
        }
        if (type.equals("jst.ear")) {
            return 8;
        }
        return -1;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        this.typeRuntimeServer_ = typeRuntimeServer;
    }

    public void setClientJ2EEVersion(String j2eeLevel) {
        this.j2eeLevel_ = j2eeLevel;
    }

    public String getJ2eeLevel() {
        return this.j2eeLevel_;
    }

    public IWebServiceClient getWebService() {
        return this.webServiceClient_;
    }

    public Environment getEnvironment() {
        return this.environment_;
    }

    public IContext getContext() {
        return this.context_;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext_ = resourceContext;
    }

    public ISelection getSelection() {
        return this.selection_;
    }

    public void setSelection(ISelection selection) {
        this.selection_ = selection;
    }

    public String getProject() {
        return this.project_;
    }

    public String getModule() {
        return this.module_;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setModuleType(String moduleType) {
        this.moduleType_ = moduleType;
    }

    public String getEarProject() {
        return this.earProject_;
    }

    public String getEar() {
        return this.ear_;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setTestService(boolean testService) {
        this.test_ = testService;
    }

    public void setWsdlURI(String uri) {
        this.wsdlURI_ = uri;
    }

    public void setDataObject(Object object) {
        this.dataObject_ = object;
    }

    public Object getDataObject() {
        Object result = null;
        result = this.dataObject_ != null && this.dataObject_ instanceof IWebService ? this.dataObject_ : this.webServiceClient_;
        return result;
    }
}

