/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLPartitionScanner;

public class SQLStatementTerminatorSupport
implements IPropertyChangeListener {
    public static final String STATEMENT_TERMINATOR = "statementTerminator";
    private SQLEditor fSQLEditor;
    private final String fDefaultStatementTerminator = ";";
    private final String fStmtTermTag1 = "-- <ScriptOptions statementTerminator=\"";
    private final String fStmtTermTag2 = "\" />\r";
    private final Pattern fStmtTermTagPattern = Pattern.compile("\\A[ ]*--[ ]*<ScriptOptions[ ]+statementTerminator[ ]*=[ ]*\"(.+)\".*[\\s]*", 2);

    public SQLStatementTerminatorSupport(SQLEditor sqlEditor) {
        this.fSQLEditor = sqlEditor;
        Assert.isNotNull((Object)((Object)this.fSQLEditor));
    }

    protected StatementTerminatorTagInfo getStatementTerminatorTagInfo() {
        StatementTerminatorTagInfo stmtTermTagInfo = null;
        IDocument doc = this.getDocument();
        ITypedRegion[] regions = SQLPartitionScanner.getDocumentRegions(doc);
        ITypedRegion region = null;
        int regionCount = regions.length;
        int i = 0;
        while (i < regionCount && stmtTermTagInfo == null) {
            region = regions[i];
            if (region.getType().equals("__sql_comment__")) {
                int regionOffset = region.getOffset();
                int regionLength = region.getLength();
                String regionStr = "";
                try {
                    regionStr = doc.get(regionOffset, regionLength);
                }
                catch (BadLocationException badLocationException) {}
                Matcher stmtTermTagMatcher = this.fStmtTermTagPattern.matcher(regionStr);
                boolean matches = stmtTermTagMatcher.matches();
                if (matches) {
                    stmtTermTagInfo = new StatementTerminatorTagInfo();
                    stmtTermTagInfo.doc = doc;
                    stmtTermTagInfo.tagRegion = region;
                    stmtTermTagInfo.tagMatcher = stmtTermTagMatcher;
                }
            }
            ++i;
        }
        return stmtTermTagInfo;
    }

    public String getDefaultStatementTerminator() {
        return ";";
    }

    protected IDocument getDocument() {
        SQLEditor sqlEditor = this.getSQLEditor();
        IEditorInput editorInput = sqlEditor.getEditorInput();
        IDocumentProvider docProvider = sqlEditor.getDocumentProvider();
        IDocument doc = docProvider.getDocument((Object)editorInput);
        return doc;
    }

    protected SQLEditor getSQLEditor() {
        return this.fSQLEditor;
    }

    public String getStatementTerminator() {
        int groupCount;
        String statementTerminator = this.getDefaultStatementTerminator();
        StatementTerminatorTagInfo stmtTermTagInfo = this.getStatementTerminatorTagInfo();
        if (stmtTermTagInfo != null && (groupCount = stmtTermTagInfo.tagMatcher.groupCount()) == 1) {
            statementTerminator = stmtTermTagInfo.tagMatcher.group(1);
        }
        return statementTerminator;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(STATEMENT_TERMINATOR)) {
            String statementTerminator = (String)event.getNewValue();
            this.setStatementTerminator(statementTerminator);
        }
    }

    public void setStatementTerminator(String newStatementTerminator) {
        int groupCount;
        String defaultStatementTerminator = this.getDefaultStatementTerminator();
        String docStatementTerminator = null;
        StatementTerminatorTagInfo stmtTermTagInfo = this.getStatementTerminatorTagInfo();
        if (stmtTermTagInfo != null && (groupCount = stmtTermTagInfo.tagMatcher.groupCount()) == 1) {
            docStatementTerminator = stmtTermTagInfo.tagMatcher.group(1);
        }
        if (docStatementTerminator != null && !newStatementTerminator.equals(docStatementTerminator)) {
            IDocument doc = this.getDocument();
            int tagOffset = stmtTermTagInfo.tagRegion.getOffset();
            int tagLength = stmtTermTagInfo.tagRegion.getLength();
            if (newStatementTerminator.equals(defaultStatementTerminator)) {
                try {
                    doc.replace(tagOffset, tagLength, "");
                }
                catch (BadLocationException badLocationException) {}
            } else {
                int stmtTermStartIndex = stmtTermTagInfo.tagMatcher.start(1);
                int stmtTermEndIndex = stmtTermTagInfo.tagMatcher.end(1);
                int stmtTermLength = stmtTermEndIndex - stmtTermStartIndex;
                try {
                    doc.replace(tagOffset + stmtTermStartIndex, stmtTermLength, newStatementTerminator);
                }
                catch (BadLocationException badLocationException) {}
            }
        } else if (!newStatementTerminator.equals(defaultStatementTerminator)) {
            String stmtTermTag = "-- <ScriptOptions statementTerminator=\"" + newStatementTerminator + "\" />\r";
            IDocument doc = this.getDocument();
            try {
                doc.replace(0, 0, stmtTermTag);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private class StatementTerminatorTagInfo {
        IDocument doc;
        ITypedRegion tagRegion;
        Matcher tagMatcher;

        StatementTerminatorTagInfo() {
        }
    }
}

