/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.style;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class LineStyleProviderForCSS
extends AbstractLineStyleProvider
implements LineStyleProvider {
    private Map fColorTypes;

    public LineStyleProviderForCSS() {
        this.initAttributes();
        this.loadColors();
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        String type;
        if (region != null && (type = region.getType()) != null) {
            return this.getAttributeFor(type);
        }
        return (TextAttribute)this.getTextAttributes().get("NORMAL");
    }

    protected TextAttribute getAttributeFor(String type) {
        return (TextAttribute)this.getTextAttributes().get(this.fColorTypes.get(type));
    }

    private void initAttributes() {
        if (this.fColorTypes == null) {
            this.fColorTypes = new HashMap();
        }
        this.fColorTypes.put("COMMENT", "COMMENT");
        this.fColorTypes.put("CDO", "COMMENT");
        this.fColorTypes.put("CDC", "COMMENT");
        this.fColorTypes.put("S", "NORMAL");
        this.fColorTypes.put("DELIMITER", "SEMI_COLON");
        this.fColorTypes.put("LBRACE", "CURLY_BRACE");
        this.fColorTypes.put("RBRACE", "CURLY_BRACE");
        this.fColorTypes.put("IMPORT", "ATMARK_RULE");
        this.fColorTypes.put("PAGE", "ATMARK_RULE");
        this.fColorTypes.put("MEDIA", "ATMARK_RULE");
        this.fColorTypes.put("FONT_FACE", "ATMARK_RULE");
        this.fColorTypes.put("CHARSET", "ATMARK_RULE");
        this.fColorTypes.put("ATKEYWORD", "ATMARK_RULE");
        this.fColorTypes.put("STRING", "STRING");
        this.fColorTypes.put("URI", "URI");
        this.fColorTypes.put("MEDIUM", "MEDIA");
        this.fColorTypes.put("MEDIA_SEPARATOR", "MEDIA");
        this.fColorTypes.put("CHARSET_NAME", "STRING");
        this.fColorTypes.put("CSS_PAGE_SELECTOR", "MEDIA");
        this.fColorTypes.put("SELECTOR_ELEMENT_NAME", "SELECTOR");
        this.fColorTypes.put("SELECTOR_UNIVERSAL", "SELECTOR");
        this.fColorTypes.put("SELECTOR_PSEUDO", "SELECTOR");
        this.fColorTypes.put("SELECTOR_CLASS", "SELECTOR");
        this.fColorTypes.put("SELECTOR_ID", "SELECTOR");
        this.fColorTypes.put("SELECTOR_COMBINATOR", "SELECTOR");
        this.fColorTypes.put("SELECTOR_SEPARATOR", "SELECTOR");
        this.fColorTypes.put("SELECTOR_ATTRIBUTE_START", "SELECTOR");
        this.fColorTypes.put("SELECTOR_ATTRIBUTE_END", "SELECTOR");
        this.fColorTypes.put("SELECTOR_ATTRIBUTE_NAME", "SELECTOR");
        this.fColorTypes.put("SELECTOR_ATTRIBUTE_VALUE", "SELECTOR");
        this.fColorTypes.put("SELECTOR_ATTRIBUTE_OPERATOR", "SELECTOR");
        this.fColorTypes.put("DECLARATION_PROPERTY", "PROPERTY_NAME");
        this.fColorTypes.put("DECLARATION_VALUE_IDENT", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_DIMENSION", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_PERCENTAGE", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_NUMBER", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_FUNCTION", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_PARENTHESIS_CLOSE", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_STRING", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_URI", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_HASH", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_UNICODE_RANGE", "PROPERTY_VALUE");
        this.fColorTypes.put("CSS_DECLARATION_VALUE_IMPORTANT", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_OPERATOR", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_VALUE_S", "PROPERTY_VALUE");
        this.fColorTypes.put("DECLARATION_SEPARATOR", "COLON");
        this.fColorTypes.put("DECLARATION_DELIMITER", "SEMI_COLON");
        this.fColorTypes.put("UNKNOWN", "NORMAL");
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = null;
        if (event != null) {
            String prefKey = event.getProperty();
            if ("ATMARK_RULE".equals(prefKey)) {
                styleKey = "ATMARK_RULE";
            } else if ("COLON".equals(prefKey)) {
                styleKey = "COLON";
            } else if ("COMMENT".equals(prefKey)) {
                styleKey = "COMMENT";
            } else if ("CURLY_BRACE".equals(prefKey)) {
                styleKey = "CURLY_BRACE";
            } else if ("ERROR".equals(prefKey)) {
                styleKey = "ERROR";
            } else if ("MEDIA".equals(prefKey)) {
                styleKey = "MEDIA";
            } else if ("NORMAL".equals(prefKey)) {
                styleKey = "NORMAL";
            } else if ("PROPERTY_NAME".equals(prefKey)) {
                styleKey = "PROPERTY_NAME";
            } else if ("PROPERTY_VALUE".equals(prefKey)) {
                styleKey = "PROPERTY_VALUE";
            } else if ("SELECTOR".equals(prefKey)) {
                styleKey = "SELECTOR";
            } else if ("SEMI_COLON".equals(prefKey)) {
                styleKey = "SEMI_COLON";
            } else if ("STRING".equals(prefKey)) {
                styleKey = "STRING";
            } else if ("URI".equals(prefKey)) {
                styleKey = "URI";
            }
        } else {
            this.loadColors();
            super.handlePropertyChange(event);
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
            super.handlePropertyChange(event);
        }
    }

    public void release() {
        if (this.fColorTypes != null) {
            this.fColorTypes.clear();
        }
        super.release();
    }

    public void loadColors() {
        this.clearColors();
        this.addTextAttribute("ATMARK_RULE");
        this.addTextAttribute("COLON");
        this.addTextAttribute("COMMENT");
        this.addTextAttribute("CURLY_BRACE");
        this.addTextAttribute("ERROR");
        this.addTextAttribute("MEDIA");
        this.addTextAttribute("NORMAL");
        this.addTextAttribute("PROPERTY_NAME");
        this.addTextAttribute("PROPERTY_VALUE");
        this.addTextAttribute("SELECTOR");
        this.addTextAttribute("SEMI_COLON");
        this.addTextAttribute("STRING");
        this.addTextAttribute("URI");
    }

    protected void clearColors() {
        this.getTextAttributes().clear();
    }

    protected IPreferenceStore getColorPreferences() {
        return CSSUIPlugin.getDefault().getPreferenceStore();
    }
}

