/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.selection;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;
import org.eclipse.wst.sse.ui.internal.selection.StructureSelectAction;

public abstract class StructureSelectCSSAction
extends StructureSelectAction {
    public StructureSelectCSSAction(StructuredTextEditor editor, SelectionHistory history) {
        super(editor, history);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Region currentRegion = new Region(this.fViewer.getSelectedRange().x, this.fViewer.getSelectedRange().y);
        if (currentRegion.getLength() == this.fViewer.getDocument().getLength()) {
            return;
        }
        IndexedRegion cursorIndexedRegion = this.getCursorIndexedRegion();
        if (!(cursorIndexedRegion instanceof ICSSNode)) return;
        ICSSNode cursorNode = (ICSSNode)cursorIndexedRegion;
        Region cursorNodeRegion = new Region(cursorIndexedRegion.getStartOffset(), cursorIndexedRegion.getEndOffset() - cursorIndexedRegion.getStartOffset());
        Region newRegion = null;
        newRegion = cursorNodeRegion.getOffset() >= currentRegion.getOffset() && cursorNodeRegion.getOffset() <= currentRegion.getOffset() + currentRegion.getLength() && cursorNodeRegion.getOffset() + cursorNodeRegion.getLength() >= currentRegion.getOffset() && cursorNodeRegion.getOffset() + cursorNodeRegion.getLength() <= currentRegion.getOffset() + currentRegion.getLength() ? this.getNewSelectionRegion(cursorNode, currentRegion) : cursorNodeRegion;
        if (newRegion == null) return;
        this.fHistory.remember((IRegion)currentRegion);
        try {
            this.fHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(newRegion.getOffset(), newRegion.getLength());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fHistory.listenToSelectionChanges();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.fHistory.listenToSelectionChanges();
    }

    protected abstract Region getNewSelectionRegion(ICSSNode var1, Region var2);
}

