/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.io.ByteArrayOutputStream;
import org.eclipse.wst.common.snippets.internal.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.PluginRecord;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntrySerializer {
    private static EntrySerializer writer = null;

    public static synchronized EntrySerializer getInstance() {
        if (writer == null) {
            writer = new EntrySerializer();
        }
        return writer;
    }

    protected EntrySerializer() {
    }

    protected void assignEntryProperties(ISnippetsEntry entry, Element owningElement) {
        owningElement.setAttribute("id", entry.getId());
        if (entry.getIconName() != null) {
            owningElement.setAttribute("icon", entry.getIconName());
        }
        if (entry.getDescription() != null) {
            owningElement.appendChild(this.createDescription(owningElement.getOwnerDocument(), entry.getDescription()));
        }
        if (entry.getLabel() != null) {
            owningElement.setAttribute("label", entry.getLabel());
        }
    }

    protected Element createCategory(Document doc, ISnippetCategory category) {
        Element element = doc.createElement("category");
        this.assignEntryProperties(category, element);
        int i = 0;
        while (i < category.getChildren().size()) {
            ISnippetItem item = (ISnippetItem)category.getChildren().get(i);
            Element child = this.createItem(doc, item);
            element.appendChild(child);
            ++i;
        }
        return element;
    }

    protected Element createContent(Document doc, ISnippetItem item) {
        Element element = doc.createElement("content");
        element.appendChild(doc.createCDATASection(item.getContentString()));
        return element;
    }

    protected Element createDescription(Document doc, String description) {
        Element element = doc.createElement("description");
        if (description != null) {
            element.appendChild(doc.createCDATASection(description));
        } else {
            element.appendChild(doc.createCDATASection(""));
        }
        return element;
    }

    protected Element createItem(Document doc, ISnippetItem item) {
        Element element = doc.createElement("item");
        this.assignEntryProperties(item, element);
        if (item.getCategory() != null) {
            element.setAttribute("category", item.getCategory().getId());
        }
        if (item.getClassName() != null) {
            element.setAttribute("class", item.getClassName());
        }
        if (item.getEditorClassName() != null) {
            element.setAttribute("editorclass", item.getEditorClassName());
        }
        if (item.getContentString() != null) {
            element.appendChild(this.createContent(doc, item));
        }
        ISnippetVariable[] variables = item.getVariables();
        int i = 0;
        while (i < variables.length) {
            Element variable = this.createVariable(doc, variables[i]);
            element.appendChild(variable);
            ++i;
        }
        return element;
    }

    protected Element createPluginRecord(Document doc, PluginRecord record) {
        Element element = doc.createElement("plugin");
        element.setAttribute("name", record.getPluginName());
        element.setAttribute("version", record.getPluginVersion());
        return element;
    }

    protected Element createVariable(Document doc, ISnippetVariable variable) {
        Element element = doc.createElement("variable");
        element.setAttribute("id", variable.getId());
        if (variable.getName() != null) {
            element.setAttribute("name", variable.getName());
        }
        if (variable.getDefaultValue() != null) {
            element.setAttribute("default", variable.getDefaultValue());
        }
        if (variable.getDescription() != null) {
            element.appendChild(this.createDescription(doc, variable.getDescription()));
        }
        return element;
    }

    public byte[] toXML(ISnippetsEntry entry) {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "snippets", null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (entry instanceof ISnippetItem) {
            ISnippetItem item = (ISnippetItem)entry;
            Element itemElement = this.createItem(document, item);
            document.getDocumentElement().appendChild(itemElement);
        } else {
            ISnippetCategory category = (ISnippetCategory)entry;
            Element categoryElement = this.createCategory(document, category);
            document.getDocumentElement().appendChild(categoryElement);
        }
        try {
            CommonXML.serialize(document, output);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return output.toByteArray();
    }
}

