/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.provisional.insertions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetsInsertion;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;

public abstract class AbstractInsertion
implements ISnippetsInsertion {
    private IEditorPart activeEditorPart = null;
    private ISnippetItem fItem = null;
    private Transfer[] supportedTransfers = null;

    protected Transfer[] createTransfers() {
        return new Transfer[]{TextTransfer.getInstance()};
    }

    protected void doInsert(IEditorPart part, ITextEditor textEditor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        String replacement = this.getInsertString(part.getEditorSite().getShell());
        if (replacement != null && (replacement.length() > 0 || textSelection.getLength() > 0)) {
            replacement = StringUtils.replace(replacement, "\r\n", "\n");
            replacement = StringUtils.replace(replacement, "\r", "\n");
            String preferredEOL = null;
            if (document instanceof IDocumentExtension4) {
                preferredEOL = ((IDocumentExtension4)document).getDefaultLineDelimiter();
            } else {
                Method getLineDelimiter = null;
                try {
                    getLineDelimiter = document.getClass().getMethod("getLineDelimiter", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (getLineDelimiter != null) {
                    try {
                        preferredEOL = (String)getLineDelimiter.invoke((Object)document, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            }
            if (preferredEOL == null) {
                preferredEOL = System.getProperty("line.separator");
            }
            if (!"\n".equals(preferredEOL) && preferredEOL != null) {
                replacement = StringUtils.replace(replacement, "\n", preferredEOL);
            }
            document.replace(textSelection.getOffset(), textSelection.getLength(), replacement);
        }
    }

    public IEditorPart getActiveEditorPart() {
        return this.activeEditorPart;
    }

    public String getInsertString(Shell host) {
        return "";
    }

    public ISnippetItem getItem() {
        return this.fItem;
    }

    public Transfer[] getTransfers() {
        if (this.supportedTransfers == null) {
            this.supportedTransfers = this.createTransfers();
        }
        return this.supportedTransfers;
    }

    public void insert(IEditorPart editorPart) {
        ITextEditor editor;
        if (editorPart == null) {
            return;
        }
        if (editorPart instanceof ITextEditor && (editor = (ITextEditor)editorPart).isEditable()) {
            IDocumentProvider docprovider = editor.getDocumentProvider();
            ISelectionProvider selprovider = editor.getSelectionProvider();
            if (docprovider != null && selprovider != null) {
                IDocument document = docprovider.getDocument((Object)editorPart.getEditorInput());
                ISelection selection = selprovider.getSelection();
                if (document != null && selection != null && selection instanceof ITextSelection) {
                    ITextSelection textSel = (ITextSelection)selection;
                    try {
                        this.doInsert(editorPart, editor, document, textSel);
                    }
                    catch (Exception t) {
                        Logger.logException("Could not insert " + this.getItem().getId(), t);
                        editor.getSite().getShell().getDisplay().beep();
                    }
                }
            }
        }
    }

    public void setActiveEditorPart(IEditorPart newActiveEditorPart) {
        this.activeEditorPart = newActiveEditorPart;
    }

    public void setItem(ISnippetItem item) {
        this.fItem = item;
    }
}

