/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.wst.common.snippets.internal.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;

public abstract class AbstractCategoryAction
extends Action {
    private PaletteContainer fContainer = null;
    private SnippetsView fViewer = null;

    protected AbstractCategoryAction(String text) {
        super(text);
    }

    public AbstractCategoryAction(String text, SnippetsView viewer, PaletteContainer entry) {
        super(text);
        this.fContainer = entry;
        this.fViewer = viewer;
    }

    public PaletteContainer getContainer() {
        return this.fContainer;
    }

    public SnippetsView getViewer() {
        return this.fViewer;
    }

    protected void refresh(ISnippetCategory category) {
        EditPart part = (EditPart)this.fViewer.getViewer().getEditPartRegistry().get(category);
        if (part != null) {
            part.refresh();
        }
    }

    protected void refresh(ISnippetItem item) {
        EditPart part = (EditPart)this.fViewer.getViewer().getEditPartRegistry().get(item);
        if (part != null) {
            part.refresh();
        }
    }

    protected void refresh(PaletteEntry entry) {
        if (entry instanceof ISnippetCategory) {
            this.refresh((ISnippetCategory)entry);
        } else if (entry instanceof ISnippetItem) {
            this.refresh((ISnippetItem)entry);
        }
    }

    protected static class CategoryNameValidator
    implements IInputValidator {
        protected CategoryNameValidator() {
        }

        public String isValid(String name) {
            if (name == null || name.length() < 1) {
                return SnippetsMessages.A_name_must_be_specified_1;
            }
            return null;
        }
    }
}

