/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.modelhandler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistryReader;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class ModelHandlerRegistry {
    private static ModelHandlerRegistry instance = null;
    private IModelHandler defaultHandler = null;
    private ModelHandlerRegistryReader reader = new ModelHandlerRegistryReader().readRegistry();

    private static IContentTypeManager getContentTypeRegistry() {
        IContentTypeManager registry = Platform.getContentTypeManager();
        return registry;
    }

    public static synchronized ModelHandlerRegistry getInstance() {
        if (instance == null) {
            instance = new ModelHandlerRegistry();
        }
        return instance;
    }

    protected ModelHandlerRegistry() {
    }

    public final IModelHandler getDefault() {
        if (this.defaultHandler == null) {
            IConfigurationElement[] elements = this.reader.elements;
            int i = 0;
            while (i < elements.length) {
                boolean ofInterest = this.reader.isElementDefault(elements[i]);
                if (ofInterest) {
                    if (this.defaultHandler == null) {
                        this.defaultHandler = this.reader.getInstance(elements[i]);
                    } else {
                        String errorString = "Program or configuration error. More than one default content handler found";
                        Logger.log(4, errorString);
                        throw new IllegalStateException(errorString);
                    }
                }
                ++i;
            }
        }
        if (this.defaultHandler == null) {
            String errorString = "Program or configuration error. No default content type handler found.";
            Logger.log(4, errorString);
            throw new IllegalStateException(errorString);
        }
        return this.defaultHandler;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IModelHandler getHandlerFor(IFile iFile) throws CoreException {
        IContentType contentType;
        block10: {
            IContentDescription contentDescription;
            block11: {
                IModelHandler modelHandler = null;
                contentDescription = null;
                contentType = null;
                boolean exists = iFile.exists();
                if (!exists) break block10;
                contentDescription = iFile.getContentDescription();
                if (contentDescription == null) break block11;
                contentType = contentDescription.getContentType();
                break block10;
            }
            InputStream contents = null;
            try {
                try {
                    contents = iFile.getContents(true);
                    contentDescription = Platform.getContentTypeManager().getDescriptionFor(contents, iFile.getName(), IContentDescription.ALL);
                    if (contentDescription != null) {
                        contentType = contentDescription.getContentType();
                    }
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (contents == null) throw throwable;
                try {
                    contents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (contents == null) break block10;
            }
            try {}
            catch (IOException iOException) {}
            contents.close();
        }
        if (contentType == null) {
            contentType = Platform.getContentTypeManager().findContentTypeFor(iFile.getName());
        }
        if (contentType == null) return this.getHandlerForID("org.eclipse.wst.sse.core.handler.xml");
        return this.getHandlerForContentType(contentType);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IModelHandler getHandlerFor(String filename, InputStream inputStream) throws IOException {
        IContentType contentType;
        InputStream iStream;
        block7: {
            iStream = Utilities.getMarkSupportedStream(inputStream);
            IModelHandler modelHandler = null;
            contentType = null;
            if (inputStream != null) {
                try {
                    try {
                        iStream.mark(8192);
                        contentType = ModelHandlerRegistry.getContentTypeRegistry().findContentTypeFor(Utilities.getLimitedStream(iStream), filename);
                    }
                    catch (FileNotFoundException fnfe) {
                        Logger.logException(fnfe);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (iStream == null) throw throwable;
                    if (!iStream.markSupported()) throw throwable;
                    iStream.reset();
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                    if (iStream == null || !iStream.markSupported()) break block7;
                }
                iStream.reset();
            }
        }
        if (contentType == null) {
            contentType = ModelHandlerRegistry.getContentTypeRegistry().findContentTypeFor(filename);
        }
        if (contentType != null) return this.getHandlerForContentType(contentType);
        contentType = ModelHandlerRegistry.getContentTypeRegistry().findContentTypeFor(Utilities.getLimitedStream(iStream), null);
        return this.getHandlerForContentType(contentType);
    }

    private IModelHandler getHandlerForContentType(IContentType contentType) {
        IModelHandler found = null;
        if (contentType == null) {
            found = this.getHandlerForID("org.eclipse.wst.sse.core.handler.xml");
        } else {
            IConfigurationElement[] elements = this.reader.elements;
            if (elements != null) {
                int i = 0;
                while (i < elements.length) {
                    String currentId = this.reader.getAssociatedContentTypeId(elements[i]);
                    IContentType modelContentType = Platform.getContentTypeManager().getContentType(currentId);
                    if (contentType.isKindOf(modelContentType)) {
                        IModelHandler item;
                        found = item = this.reader.getInstance(elements[i]);
                    }
                    ++i;
                }
            } else {
                Logger.log(202, "There were no Model Handler found in registry");
            }
        }
        return found;
    }

    public IModelHandler getHandlerForContentTypeId(String contentTypeId) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        return this.getHandlerForContentType(contentType);
    }

    private IModelHandler getHandlerForID(String modelId) {
        IModelHandler found = null;
        IConfigurationElement[] elements = this.reader.elements;
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                String currentId = this.reader.getId(elements[i]);
                if (modelId.equals(currentId)) {
                    IModelHandler item;
                    found = item = this.reader.getInstance(elements[i]);
                }
                ++i;
            }
        } else {
            Logger.log(202, "There were no Model Handler found in registry");
        }
        return found;
    }
}

