/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class ModelLifecycleEvent {
    private static final int MASK = 255;
    public static final int MODEL_DIRTY_STATE = 4;
    public static final int MODEL_DOCUMENT_CHANGED = 3;
    public static final int MODEL_RELEASED = 2;
    public static final int MODEL_SAVED = 1;
    protected static final int POST_EVENT = 512;
    protected static final int PRE_EVENT = 256;
    private IStructuredModel fModel;
    private int fType;

    public ModelLifecycleEvent() {
    }

    public ModelLifecycleEvent(int type) {
        this();
        this.fType = type;
    }

    public ModelLifecycleEvent(IStructuredModel structuredModel, int type) {
        this(type);
        this.fModel = structuredModel;
    }

    private String debugString(int type) {
        String result = null;
        switch (type & 0xFF) {
            case 1: {
                result = "MODEL_SAVED";
                break;
            }
            case 2: {
                result = "MODEL_RELEASED";
                break;
            }
            case 3: {
                result = "MODEL_DOCUMENT_CHANGED";
                break;
            }
            case 4: {
                result = "MODEL_DIRTY_STATE";
                break;
            }
            default: {
                throw new IllegalStateException("ModelLifecycleEvent did not have valid type");
            }
        }
        return result;
    }

    protected int getInternalType() {
        return this.fType;
    }

    public IStructuredModel getModel() {
        return this.fModel;
    }

    public int getType() {
        return this.fType & 0xFF;
    }

    public String toString() {
        String result = null;
        result = "ModelLifecycleEvent: " + this.debugString(this.fType);
        return result;
    }
}

