/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.cleanup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class AbstractStructuredCleanupProcessor
implements IStructuredCleanupProcessor {
    public boolean refreshCleanupPreferences = true;

    public String cleanupContent(String input) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
            String id = String.valueOf(inputStream.toString()) + this.getContentType();
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
            this.cleanupModel(structuredModel, 0, structuredModel.getStructuredDocument().getLength());
            String string = structuredModel.getStructuredDocument().get();
            Object var5_6 = null;
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            return string;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_7 = null;
                this.ensureClosed(null, inputStream);
                if (structuredModel == null) break block3;
                structuredModel.releaseFromRead();
            }
            throw throwable;
        }
    }

    public String cleanupContent(String input, int start, int length) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
            String id = String.valueOf(inputStream.toString()) + this.getContentType();
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
            this.cleanupModel(structuredModel, start, length);
            String string = structuredModel.getStructuredDocument().get();
            Object var7_8 = null;
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            return string;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_9 = null;
                this.ensureClosed(null, inputStream);
                if (structuredModel == null) break block3;
                structuredModel.releaseFromRead();
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public void cleanupDocument(IDocument document) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cleanupDocument(IDocument document, int start, int length) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 101->105)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cleanupFile(IFile file) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 60->64)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cleanupFile(IFile file, int start, int length) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 57->61)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cleanupFileName(String fileName) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 73->77)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cleanupFileName(String fileName, int start, int length) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 72->76)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cleanupModel(IStructuredModel structuredModel) {
        int start = 0;
        int length = structuredModel.getStructuredDocument().getLength();
        this.cleanupModel(structuredModel, start, length);
    }

    public void cleanupModel(IStructuredModel structuredModel, int start, int length) {
        Vector activeNodes;
        if (structuredModel != null && start >= 0 && length <= structuredModel.getStructuredDocument().getLength() && (activeNodes = this.getActiveNodes(structuredModel, start, length)).size() > 0) {
            Node firstNode = (Node)activeNodes.firstElement();
            Node lastNode = (Node)activeNodes.lastElement();
            boolean done = false;
            Node eachNode = firstNode;
            Node nextNode = null;
            while (!done) {
                done = eachNode == lastNode;
                nextNode = eachNode.getNextSibling();
                this.cleanupNode(eachNode);
                eachNode = nextNode != null && nextNode.getParentNode() == null ? eachNode.getNextSibling() : nextNode;
                if (eachNode != null) continue;
                done = true;
            }
            if (this.getFormatSourcePreference(structuredModel)) {
                IStructuredFormatProcessor formatProcessor = this.getFormatProcessor();
                formatProcessor.formatModel(structuredModel);
            }
            if (this.getConvertEOLCodesPreference(structuredModel)) {
                IStructuredDocument document = structuredModel.getStructuredDocument();
                String endOfLineCode = this.getEOLCodePreference(structuredModel);
                String endOfLineCodeString = null;
                if (endOfLineCode.compareTo("EOL_Unix") == 0) {
                    endOfLineCodeString = "\n";
                } else if (endOfLineCode.compareTo("EOL_Mac") == 0) {
                    endOfLineCodeString = "\r";
                } else if (endOfLineCode.compareTo("EOL_Windows") == 0) {
                    endOfLineCodeString = "\r\n";
                }
                if (endOfLineCodeString != null) {
                    this.convertLineDelimiters(document, endOfLineCodeString);
                    if (document instanceof IStructuredDocument) {
                        document.setLineDelimiter(endOfLineCodeString);
                    }
                    structuredModel.setDirtyState(true);
                }
            }
        }
    }

    public void cleanupNode(Node node) {
        if (node != null) {
            IStructuredCleanupHandler cleanupHandler;
            Node cleanupNode = node;
            if (cleanupNode.getNodeType() == 2) {
                cleanupNode = ((Attr)cleanupNode).getOwnerElement();
            }
            if (this.refreshCleanupPreferences) {
                this.refreshCleanupPreferences();
            }
            if ((cleanupHandler = this.getCleanupHandler(cleanupNode)) != null) {
                cleanupHandler.cleanup(cleanupNode);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void convertLineDelimiters(IDocument document, String newDelimiter) {
        int lineCount = document.getNumberOfLines();
        Map partitioners = TextUtilities.removeDocumentPartitioners((IDocument)document);
        try {
            try {
                int i = 0;
                while (i < lineCount) {
                    String delimiter = document.getLineDelimiter(i);
                    if (delimiter != null && delimiter.length() > 0 && !delimiter.equals(newDelimiter)) {
                        IRegion region = document.getLineInformation(i);
                        document.replace(region.getOffset() + region.getLength(), delimiter.length(), newDelimiter);
                    }
                    ++i;
                }
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
    }

    protected void ensureClosed(OutputStream outputStream, InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    protected Vector getActiveNodes(IStructuredModel structuredModel, int startNodeOffset, int length) {
        Vector<Node> activeNodes = new Vector<Node>();
        if (structuredModel != null) {
            Node startNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset));
            Node endNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset + length));
            if (startNode != null) {
                while (!this.isSiblingOf(startNode, endNode)) {
                    if (endNode != null) {
                        endNode = endNode.getParentNode();
                    }
                    if (endNode != null) continue;
                    startNode = startNode.getParentNode();
                    endNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset + length));
                }
                while (startNode != endNode) {
                    activeNodes.addElement(startNode);
                    startNode = startNode.getNextSibling();
                }
                if (startNode != null) {
                    activeNodes.addElement(startNode);
                }
            }
        }
        return activeNodes;
    }

    protected abstract IStructuredCleanupHandler getCleanupHandler(Node var1);

    protected abstract String getContentType();

    protected boolean getConvertEOLCodesPreference(IStructuredModel structuredModel) {
        boolean convertEOLCodes = true;
        IStructuredCleanupHandler cleanupHandler = this.getCleanupHandler((Node)((Object)structuredModel.getIndexedRegion(0)));
        if (cleanupHandler != null) {
            IStructuredCleanupPreferences cleanupPreferences = cleanupHandler.getCleanupPreferences();
            convertEOLCodes = cleanupPreferences.getConvertEOLCodes();
        }
        return convertEOLCodes;
    }

    protected String getEOLCodePreference(IStructuredModel structuredModel) {
        String eolCode = System.getProperty("line.separator");
        IStructuredCleanupHandler cleanupHandler = this.getCleanupHandler((Node)((Object)structuredModel.getIndexedRegion(0)));
        if (cleanupHandler != null) {
            IStructuredCleanupPreferences cleanupPreferences = cleanupHandler.getCleanupPreferences();
            eolCode = cleanupPreferences.getEOLCode();
        }
        return eolCode;
    }

    protected abstract IStructuredFormatProcessor getFormatProcessor();

    protected boolean getFormatSourcePreference(IStructuredModel structuredModel) {
        boolean formatSource = true;
        IStructuredCleanupHandler cleanupHandler = this.getCleanupHandler((Node)((Object)structuredModel.getIndexedRegion(0)));
        if (cleanupHandler != null) {
            IStructuredCleanupPreferences cleanupPreferences = cleanupHandler.getCleanupPreferences();
            formatSource = cleanupPreferences.getFormatSource();
        }
        return formatSource;
    }

    protected boolean isSiblingOf(Node node, Node endNode) {
        if (endNode == null) {
            return true;
        }
        Node siblingNode = node;
        while (siblingNode != null) {
            if (siblingNode == endNode) {
                return true;
            }
            siblingNode = siblingNode.getNextSibling();
        }
        return false;
    }

    protected abstract void refreshCleanupPreferences();
}

