/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public abstract class ProjectModuleFactoryDelegate
extends ModuleFactoryDelegate {
    protected static IResourceChangeListener listener;
    protected static List factories;
    protected List added;
    protected List removed;
    protected final Map projects = new HashMap();
    protected boolean initialized = false;

    static {
        factories = new ArrayList();
    }

    public ProjectModuleFactoryDelegate() {
        factories.add(this);
        ProjectModuleFactoryDelegate.addListener();
    }

    protected void cacheModules() {
        this.cacheModules(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cacheModules(boolean forceUpdate) {
        try {
            try {
                IProject[] projects2 = ProjectModuleFactoryDelegate.getWorkspaceRoot().getProjects();
                int size = projects2.length;
                int i = 0;
                while (i < size) {
                    if (!projects2[i].isAccessible()) {
                        this.removeModules(projects2[i]);
                    } else if (forceUpdate || this.needsUpdating(projects2[i]) && this.isValidModule(projects2[i])) {
                        this.addModules(projects2[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error caching modules", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.initialized = true;
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.initialized = true;
            return;
        }
    }

    protected boolean needsUpdating(IProject project) {
        return true;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IModule[] getModules(IProject project) {
        try {
            return (IModule[])this.projects.get(project);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static void addListener() {
        if (listener != null) {
            return;
        }
        listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                Trace.trace(Trace.FINEST, "->- ProjectModuleFactoryDelegate listener responding to resource change: " + event.getType() + " ->-");
                try {
                    IResourceDelta delta = event.getDelta();
                    delta.accept(new IResourceDeltaVisitor(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean visit(IResourceDelta visitorDelta) {
                            IResource resource = visitorDelta.getResource();
                            if (resource != null && resource instanceof IProject) {
                                IProject project = (IProject)resource;
                                ProjectModuleFactoryDelegate.handleGlobalProjectChange(project, visitorDelta);
                                return true;
                            }
                            return resource == null || resource.getProject() == null;
                        }
                    });
                }
                catch (Exception exception) {}
                ProjectModuleFactoryDelegate.fireGlobalEvents();
                Trace.trace(Trace.FINEST, "-<- Done ProjectModuleFactoryDelegate responding to resource change -<-");
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 1);
    }

    protected static void handleGlobalProjectChange(IProject project, IResourceDelta delta) {
        ProjectModuleFactoryDelegate factory;
        Iterator iterator = factories.iterator();
        while (iterator.hasNext()) {
            factory = (ProjectModuleFactoryDelegate)iterator.next();
            factory.handleProjectChange(project, delta);
        }
        iterator = factories.iterator();
        while (iterator.hasNext()) {
            factory = (ProjectModuleFactoryDelegate)iterator.next();
            factory.handleProjectInternalChange(project, delta);
        }
    }

    protected static void fireGlobalEvents() {
        Trace.trace(Trace.FINEST, "Firing global module event");
        Iterator iterator = factories.iterator();
        while (iterator.hasNext()) {
            ProjectModuleFactoryDelegate factory = (ProjectModuleFactoryDelegate)iterator.next();
            factory.updateProjects();
        }
    }

    private void updateProjects() {
        IModule[] modules2 = this.getModules();
        if (modules2 != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                if (modules2[i] instanceof ProjectModule) {
                    ((ProjectModule)((Object)modules2[i])).update();
                }
                ++i;
            }
        }
    }

    private void handleProjectChange(IProject project, IResourceDelta delta) {
        if (!this.initialized) {
            this.cacheModules(false);
        }
        if (this.projects.containsKey(project)) {
            if ((delta.getKind() & 2) != 0 || !this.isValidModule(project)) {
                this.removeModules(project);
            }
        } else if (this.isValidModule(project)) {
            this.addModules(project);
        }
    }

    private void handleProjectInternalChange(IProject project, IResourceDelta delta) {
        IModule[] modules;
        final IPath[] paths = this.getListenerPaths();
        if (paths != null && (modules = this.getModules(project)) != null) {
            int i = 0;
            while (i < modules.length) {
                final IModule module = modules[i];
                if (module != null && module instanceof ProjectModule) {
                    final int size = paths.length;
                    class Temp {
                        boolean found;
                        final /* synthetic */ ProjectModuleFactoryDelegate this$0;

                        Temp(ProjectModuleFactoryDelegate projectModuleFactoryDelegate) {
                            this.this$0 = projectModuleFactoryDelegate;
                            this.found = false;
                        }
                    }
                    final Temp temp = new Temp(this);
                    try {
                        delta.accept(new IResourceDeltaVisitor(){
                            {
                            }

                            public boolean visit(IResourceDelta visitorDelta) {
                                if (temp.found) {
                                    return false;
                                }
                                IPath path = visitorDelta.getProjectRelativePath();
                                boolean prefix = false;
                                int j = 0;
                                while (j < size && !temp.found) {
                                    if (paths[j].equals((Object)path)) {
                                        temp.found = true;
                                    } else if (path.isPrefixOf(paths[j])) {
                                        prefix = true;
                                    }
                                    ++j;
                                }
                                if (temp.found) {
                                    ((ProjectModule)((Object)module)).update();
                                    return false;
                                }
                                return prefix;
                            }
                        });
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error searching for listening paths", e);
                    }
                }
                ++i;
            }
        }
    }

    protected void addModules(IProject project) {
        IModule[] modules = this.createModules(project);
        if (modules == null || modules.length == 0) {
            return;
        }
        this.projects.put(project, modules);
        this.added = new ArrayList(2);
        this.added.addAll(Arrays.asList(modules));
    }

    protected void removeModules(IProject project) {
        try {
            IModule[] modules = (IModule[])this.projects.get(project);
            this.projects.remove(project);
            if (this.removed == null) {
                this.removed = new ArrayList(2);
            }
            if (modules == null) {
                return;
            }
            this.removed.addAll(Arrays.asList(modules));
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error removing module project", e);
        }
    }

    protected abstract boolean isValidModule(IProject var1);

    protected abstract IModule[] createModules(IProject var1);

    protected IPath[] getListenerPaths() {
        return null;
    }
}

