/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;

public abstract class ServerBehaviourDelegate {
    private Server server;
    public static final int NO_CHANGE = 0;
    public static final int ADDED = 1;
    public static final int CHANGED = 2;
    public static final int REMOVED = 3;

    final void initialize(Server newServer, IProgressMonitor monitor) {
        this.server = newServer;
        this.initialize(monitor);
    }

    protected void initialize(IProgressMonitor monitor) {
    }

    public final IServer getServer() {
        return this.server;
    }

    protected final void setServerState(int state) {
        this.server.setServerState(state);
    }

    protected final void setMode(String mode) {
        this.server.setMode(mode);
    }

    protected final void setServerRestartState(boolean state) {
        this.server.setServerRestartState(state);
    }

    protected final void setServerPublishState(int state) {
        this.server.setServerPublishState(state);
    }

    protected final void setModuleState(IModule[] module, int state) {
        this.server.setModuleState(module, state);
    }

    protected final void setModulePublishState(IModule[] module, int state) {
        this.server.setModulePublishState(module, state);
    }

    protected final void setModuleRestartState(IModule[] module, boolean state) {
        this.server.setModuleRestartState(module, state);
    }

    public void dispose() {
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
    }

    public void restart(String launchMode) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, "Could not restart", null));
    }

    public boolean canControlModule(IModule[] module) {
        return false;
    }

    public void startModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
    }

    public void stopModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
    }

    public abstract void stop(boolean var1);

    protected IModuleResource[] getPublishedResources(IModule[] module) {
        return this.server.getPublishedResources(module);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return this.server.getPublishedResourceDelta(module);
    }

    protected IPath getTempDirectory() {
        return this.server.getTempDirectory();
    }

    protected final void setServerStatus(IStatus status) {
        this.server.setServerStatus(status);
    }

    protected final void setModuleStatus(IModule[] module, IStatus status) {
        this.server.setModuleStatus(module, status);
    }

    public IStatus publish(int kind, IProgressMonitor monitor) {
        Trace.trace(Trace.FINEST, "-->-- Publishing to server: " + this.toString() + " -->--");
        List moduleList = this.getAllModules();
        ArrayList<Integer> kindList = new ArrayList<Integer>();
        Iterator iterator = moduleList.iterator();
        while (iterator.hasNext()) {
            IModule[] module = (IModule[])iterator.next();
            if (this.hasBeenPublished(module)) {
                if (this.getPublishedResourceDelta(module).length == 0) {
                    kindList.add(new Integer(0));
                    continue;
                }
                kindList.add(new Integer(2));
                continue;
            }
            kindList.add(new Integer(1));
        }
        PublishOperation[] tasks = this.getTasks();
        this.addRemovedModules(moduleList, kindList);
        while (moduleList.size() > kindList.size()) {
            kindList.add(new Integer(3));
        }
        int size = 2000 + 3500 * moduleList.size() + 500 * tasks.length;
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask(NLS.bind((String)Messages.publishing, (Object)this.toString()), size);
        MultiStatus multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStatus, null);
        if (monitor.isCanceled()) {
            return new Status(1, "org.eclipse.wst.server.core", 0, Messages.publishingCancelled, null);
        }
        Trace.trace(Trace.FINEST, "Calling publishStart()");
        try {
            this.publishStart(ProgressUtil.getSubMonitorFor(monitor, 1000));
        }
        catch (CoreException ce) {
            Trace.trace(Trace.INFO, "CoreException publishing to " + this.toString(), ce);
            return ce.getStatus();
        }
        IStatus taskStatus = this.performTasks(tasks, monitor);
        if (taskStatus != null) {
            multi.add(taskStatus);
        }
        try {
            if (!monitor.isCanceled() && this.getServer().getServerType().hasServerConfiguration()) {
                this.publishServer(kind, ProgressUtil.getSubMonitorFor(monitor, 1000));
            }
        }
        catch (CoreException ce) {
            Trace.trace(Trace.INFO, "CoreException publishing to " + this.toString(), ce);
            multi.add(ce.getStatus());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error publishing configuration to " + this.toString(), e);
            multi.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
        }
        if (!monitor.isCanceled()) {
            try {
                this.publishModules(kind, moduleList, kindList, multi, monitor);
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Error while publishing modules", e);
                multi.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
            }
        }
        Trace.trace(Trace.FINEST, "Calling publishFinish()");
        try {
            this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
        }
        catch (CoreException ce) {
            Trace.trace(Trace.INFO, "CoreException publishing to " + this.toString(), ce);
            multi.add(ce.getStatus());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error stopping publish to " + this.toString(), e);
            multi.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
        }
        if (monitor.isCanceled()) {
            Status status = new Status(1, "org.eclipse.wst.server.core", 0, Messages.publishingCancelled, null);
            multi.add((IStatus)status);
        }
        MultiStatus ps = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStop, null);
        ps.add((IStatus)multi);
        monitor.done();
        Trace.trace(Trace.FINEST, "--<-- Done publishing --<--");
        if (multi.getChildren().length == 1) {
            return multi.getChildren()[0];
        }
        return multi;
    }

    protected IStatus publishModule(int kind, IModule[] module, int deltaKind, IProgressMonitor monitor) {
        Trace.trace(Trace.FINEST, "Publishing module: " + module);
        int size = module.length;
        IModule m = module[size - 1];
        monitor.beginTask(NLS.bind((String)Messages.publishingModule, (Object)m.getName()), 1000);
        Status status = new Status(0, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.publishedModule, (Object)m.getName()), null);
        try {
            this.publishModule(kind, deltaKind, module, monitor);
        }
        catch (CoreException ce) {
            status = ce.getStatus();
        }
        this.updatePublishInfo(deltaKind, module);
        monitor.done();
        Trace.trace(Trace.FINEST, "Done publishing: " + module);
        return status;
    }

    protected boolean hasBeenPublished(IModule[] module) {
        return this.server.getServerPublishInfo().hasModulePublishInfo(module);
    }

    protected void addRemovedModules(List moduleList, List kindList) {
        this.server.getServerPublishInfo().addRemovedModules(moduleList, kindList);
    }

    protected void updatePublishInfo(int deltaKind, IModule[] module) {
        if (deltaKind == 3) {
            this.server.getServerPublishInfo().removeModulePublishInfo(module);
        } else {
            this.server.getServerPublishInfo().fill(module);
        }
    }

    protected void publishModules(int kind, List modules2, List deltaKind, MultiStatus multi, IProgressMonitor monitor) {
        if (modules2 == null) {
            return;
        }
        int size = modules2.size();
        if (size == 0) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        int i = 0;
        while (i < size) {
            IStatus status = this.publishModule(kind, (IModule[])modules2.get(i), (Integer)deltaKind.get(i), ProgressUtil.getSubMonitorFor(monitor, 3000));
            multi.add(status);
            ++i;
        }
    }

    protected final PublishOperation[] getTasks() {
        return this.server.getTasks();
    }

    protected final List getAllModules() {
        return this.server.getAllModules();
    }

    protected IStatus performTasks(PublishOperation[] tasks, IProgressMonitor monitor) {
        int size = tasks.length;
        Trace.trace(Trace.FINEST, "Performing tasks: " + size);
        if (size == 0) {
            return null;
        }
        MultiStatus multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.taskPerforming, null);
        int i = 0;
        while (i < size) {
            PublishOperation task = tasks[i];
            monitor.subTask(NLS.bind((String)Messages.taskPerforming, (Object)task.toString()));
            try {
                task.execute(ProgressUtil.getSubMonitorFor(monitor, 500), null);
            }
            catch (CoreException ce) {
                Trace.trace(Trace.SEVERE, "Task failed", ce);
            }
            if (monitor.isCanceled()) {
                return multi;
            }
            ++i;
        }
        return multi;
    }

    public void handleResourceChange() {
    }
}

