/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.IPublishListener;
import org.eclipse.wst.server.core.internal.IPublishTask;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.PublishInfo;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerNotificationManager;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class Server
extends Base
implements IServer {
    public static final String ATTR_SERVER_ID = "server-id";
    protected static final List EMPTY_LIST = new ArrayList(0);
    public static final String FILE_EXTENSION = "server";
    public static final int AUTO_PUBLISH_DEFAULT = 0;
    public static final int AUTO_PUBLISH_DISABLE = 1;
    public static final int AUTO_PUBLISH_OVERRIDE = 2;
    protected static final String PROP_HOSTNAME = "hostname";
    protected static final String SERVER_ID = "server-id";
    protected static final String RUNTIME_ID = "runtime-id";
    protected static final String CONFIGURATION_ID = "configuration-id";
    protected static final String MODULE_LIST = "modules";
    public static final String PROP_AUTO_PUBLISH_TIME = "auto-publish-time";
    public static final String PROP_AUTO_PUBLISH_SETTING = "auto-publish-setting";
    protected static final char[] INVALID_CHARS;
    protected IServerType serverType;
    protected ServerDelegate delegate;
    protected ServerBehaviourDelegate behaviourDelegate;
    protected IRuntime runtime;
    protected IFolder configuration;
    protected List modules;
    protected transient String mode = "run";
    protected transient int serverState = 0;
    protected transient int serverSyncState;
    protected transient boolean serverRestartNeeded;
    protected transient Map moduleState = new HashMap();
    protected transient Map modulePublishState = new HashMap();
    protected transient Map moduleRestartState = new HashMap();
    protected transient IStatus serverStatus;
    protected transient Map moduleStatus = new HashMap();
    protected transient ServerPublishInfo publishInfo;
    protected transient AutoPublishThread autoPublishThread;
    protected transient List publishListeners;
    protected transient ServerNotificationManager notificationManager;
    static /* synthetic */ Class class$0;

    static {
        char[] cArray = new char[12];
        cArray[0] = 92;
        cArray[1] = 47;
        cArray[2] = 58;
        cArray[3] = 42;
        cArray[4] = 63;
        cArray[5] = 34;
        cArray[6] = 60;
        cArray[7] = 62;
        cArray[8] = 124;
        cArray[10] = 64;
        cArray[11] = 38;
        INVALID_CHARS = cArray;
    }

    public Server(IFile file) {
        super(file);
        this.map.put(PROP_HOSTNAME, "localhost");
    }

    public Server(String id, IFile file, IRuntime runtime, IServerType serverType) {
        super(file, id);
        this.runtime = runtime;
        this.serverType = serverType;
        this.map.put("server-type-id", serverType.getId());
        this.map.put(PROP_HOSTNAME, "localhost");
        if (runtime != null && runtime.getRuntimeType() != null) {
            String name = runtime.getRuntimeType().getName();
            this.map.put("name", name);
        }
        this.serverState = ((ServerType)serverType).getInitialState();
    }

    public IServerType getServerType() {
        return this.serverType;
    }

    public IServerWorkingCopy createWorkingCopy() {
        return new ServerWorkingCopy(this);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected void deleteFromMetadata() {
        ResourceManager.getInstance().removeServer(this);
    }

    protected void saveToMetadata(IProgressMonitor monitor) {
        super.saveToMetadata(monitor);
        ResourceManager.getInstance().addServer(this);
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    protected String getRuntimeId() {
        return this.getAttribute(RUNTIME_ID, (String)null);
    }

    public IFolder getServerConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate != null || this.serverType == null) {
            return this.delegate;
        }
        Server server = this;
        synchronized (server) {
            if (this.delegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    IConfigurationElement element = ((ServerType)this.serverType).getElement();
                    this.delegate = (ServerDelegate)element.createExecutableExtension("class");
                    InternalInitializer.initializeServerDelegate(this.delegate, this, monitor);
                    Trace.trace(Trace.PERFORMANCE, "Server.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getServerType().getId());
                }
                catch (Throwable t) {
                    Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerBehaviourDelegate getBehaviourDelegate(IProgressMonitor monitor) {
        if (this.behaviourDelegate != null || this.serverType == null) {
            return this.behaviourDelegate;
        }
        Server server = this;
        synchronized (server) {
            if (this.behaviourDelegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    IConfigurationElement element = ((ServerType)this.serverType).getElement();
                    this.behaviourDelegate = (ServerBehaviourDelegate)element.createExecutableExtension("behaviourClass");
                    InternalInitializer.initializeServerBehaviourDelegate(this.behaviourDelegate, this, monitor);
                    Trace.trace(Trace.PERFORMANCE, "Server.getBehaviourDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getServerType().getId());
                }
                catch (Throwable t) {
                    Trace.trace(Trace.SEVERE, "Could not create behaviour delegate " + this.toString(), t);
                }
            }
        }
        return this.behaviourDelegate;
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
            this.delegate = null;
        }
        if (this.behaviourDelegate != null) {
            this.behaviourDelegate.dispose();
            this.behaviourDelegate = null;
        }
    }

    public String getHost() {
        return this.getAttribute(PROP_HOSTNAME, "localhost");
    }

    public int getAutoPublishTime() {
        return this.getAttribute(PROP_AUTO_PUBLISH_TIME, -1);
    }

    public int getAutoPublishSetting() {
        return this.getAttribute(PROP_AUTO_PUBLISH_SETTING, 0);
    }

    public int getServerState() {
        return this.serverState;
    }

    public String getMode() {
        return this.mode;
    }

    public void setServerState(int state) {
        if (state == this.serverState) {
            return;
        }
        this.serverState = state;
        this.fireServerStateChangeEvent();
    }

    public void addServerListener(IServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Trace.trace(Trace.LISTENERS, "Adding server listener " + listener + " to " + this);
        this.getServerNotificationManager().addListener(listener);
    }

    public void addServerListener(IServerListener listener, int eventMask) {
        if (listener == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Trace.trace(Trace.LISTENERS, "Adding server listener " + listener + " to " + this + " with eventMask " + eventMask);
        this.getServerNotificationManager().addListener(listener, eventMask);
    }

    public void removeServerListener(IServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Trace.trace(Trace.LISTENERS, "Removing server listener " + listener + " from " + this);
        this.getServerNotificationManager().removeListener(listener);
    }

    protected void fireRestartStateChangeEvent() {
        Trace.trace(Trace.LISTENERS, "->- Firing server restart change event: " + this.getName() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(20, this, this.getServerState(), this.getServerPublishState(), this.getServerRestartState()));
    }

    protected void fireServerStateChangeEvent() {
        Trace.trace(Trace.LISTENERS, "->- Firing server state change event: " + this.getName() + ", " + this.getServerState() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(17, this, this.getServerState(), this.getServerPublishState(), this.getServerRestartState()));
    }

    protected void fireServerModuleStateChangeEvent(IModule[] module) {
        Trace.trace(Trace.LISTENERS, "->- Firing server module state change event: " + this.getName() + ", " + this.getServerState() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(33, this, module, this.getModuleState(module), this.getModulePublishState(module), this.getModuleRestartState(module)));
    }

    public void setMode(String m) {
        if (m == this.mode) {
            return;
        }
        this.mode = m;
        this.fireServerStateChangeEvent();
    }

    public void setModuleState(IModule[] module, int state) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Integer in = new Integer(state);
        this.moduleState.put(this.getKey(module), in);
        this.fireServerModuleStateChangeEvent(module);
    }

    public void setModulePublishState(IModule[] module, int state) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Integer in = new Integer(state);
        this.modulePublishState.put(this.getKey(module), in);
    }

    public void setModuleRestartState(IModule[] module, boolean r) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Boolean b = new Boolean(r);
        this.moduleState.put(this.getKey(module), b);
    }

    protected void handleModuleProjectChange(final IModule module) {
        Trace.trace(Trace.FINEST, "> handleDeployableProjectChange() " + this + " " + module);
        class Helper {
            boolean changed;
            final /* synthetic */ Server this$0;

            Helper(Server server) {
                this.this$0 = server;
            }
        }
        final Helper helper = new Helper(this);
        IModuleVisitor visitor = new IModuleVisitor(){
            {
            }

            public boolean visit(IModule[] module2) {
                int size = module2.length;
                IModule m = module2[size - 1];
                if (m.getProject() == null) {
                    return true;
                }
                if (module.equals(m)) {
                    IModuleResourceDelta[] delta2 = Server.this.getPublishedResourceDelta(module2);
                    if (delta2.length > 0) {
                        helper.changed = true;
                    }
                    return true;
                }
                return true;
            }
        };
        this.visit(visitor, null);
        if (!helper.changed) {
            return;
        }
        if (this.getServerState() != 4 && this.behaviourDelegate != null) {
            this.behaviourDelegate.handleResourceChange();
        }
        this.autoPublish();
    }

    public void autoPublish() {
        if (this.autoPublishThread != null) {
            this.autoPublishThread.stop = true;
            this.autoPublishThread.interrupt();
            this.autoPublishThread = null;
        }
        int time = 0;
        if (this.getAutoPublishSetting() == 0) {
            boolean local = SocketUtil.isLocalhost(this.getHost());
            if (local && ServerPreferences.getInstance().getAutoPublishLocal()) {
                time = ServerPreferences.getInstance().getAutoPublishLocalTime();
            } else if (!local && ServerPreferences.getInstance().getAutoPublishRemote()) {
                time = ServerPreferences.getInstance().getAutoPublishRemoteTime();
            }
        } else {
            time = this.getAutoPublishTime();
        }
        if (time > 9) {
            this.autoPublishThread = new AutoPublishThread();
            this.autoPublishThread.time = time;
            this.autoPublishThread.setPriority(2);
            this.autoPublishThread.start();
        }
    }

    private ServerNotificationManager getServerNotificationManager() {
        if (this.notificationManager == null) {
            this.notificationManager = new ServerNotificationManager();
        }
        return this.notificationManager;
    }

    public int getServerPublishState() {
        return this.serverSyncState;
    }

    public void setServerPublishState(int state) {
        if (state == this.serverSyncState) {
            return;
        }
        this.serverSyncState = state;
    }

    public void addPublishListener(IPublishListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Trace.trace(Trace.LISTENERS, "Adding publish listener " + listener + " to " + this);
        if (this.publishListeners == null) {
            this.publishListeners = new ArrayList();
        }
        this.publishListeners.add(listener);
    }

    public void removePublishListener(IPublishListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Trace.trace(Trace.LISTENERS, "Removing publish listener " + listener + " from " + this);
        if (this.publishListeners != null) {
            this.publishListeners.remove(listener);
        }
    }

    private void firePublishStarted() {
        Trace.trace(Trace.FINEST, "->- Firing publish started event ->-");
        if (this.publishListeners == null || this.publishListeners.isEmpty()) {
            return;
        }
        int size = this.publishListeners.size();
        IPublishListener[] srl = new IPublishListener[size];
        this.publishListeners.toArray(srl);
        int i = 0;
        while (i < size) {
            Trace.trace(Trace.FINEST, "  Firing publish started event to " + srl[i]);
            try {
                srl[i].publishStarted(this);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "  Error firing publish started event to " + srl[i], e);
            }
            ++i;
        }
        Trace.trace(Trace.FINEST, "-<- Done firing publish started event -<-");
    }

    private void firePublishFinished(IStatus status) {
        Trace.trace(Trace.FINEST, "->- Firing publishing finished event: " + status + " ->-");
        if (this.publishListeners == null || this.publishListeners.isEmpty()) {
            return;
        }
        int size = this.publishListeners.size();
        IPublishListener[] srl = new IPublishListener[size];
        this.publishListeners.toArray(srl);
        int i = 0;
        while (i < size) {
            Trace.trace(Trace.FINEST, "  Firing publishing finished event to " + srl[i]);
            try {
                srl[i].publishFinished(this, status);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "  Error firing publishing finished event to " + srl[i], e);
            }
            ++i;
        }
        Trace.trace(Trace.FINEST, "-<- Done firing publishing finished event -<-");
    }

    protected void firePublishStateChange(IModule[] module) {
        Trace.trace(Trace.FINEST, "->- Firing publish state change event: " + module + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(34, this, module, this.getModuleState(module), this.getModulePublishState(module), this.getModuleRestartState(module)));
    }

    public IStatus canPublish() {
        int state = this.getServerState();
        if (state == 1 || state == 3) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishStarting, null);
        }
        if (this.getServerType() == null || this.getServerType().hasServerConfiguration() && this.configuration == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishNoConfiguration, null);
        }
        if (this.getServerPublishState() != 1) {
            return new Status(0, "org.eclipse.wst.server.core", 0, Messages.canPublishOk, null);
        }
        return new Status(0, "org.eclipse.wst.server.core", 0, Messages.canPublishOk, null);
    }

    public boolean shouldPublish() {
        if (!this.canPublish().isOK()) {
            return false;
        }
        if (this.getServerPublishState() != 1) {
            return true;
        }
        return true;
    }

    public ServerPublishInfo getServerPublishInfo() {
        if (this.publishInfo == null) {
            this.publishInfo = PublishInfo.getInstance().getServerPublishInfo(this);
        }
        return this.publishInfo;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus publish(int kind, IProgressMonitor monitor) {
        if (this.getServerType() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, null);
        }
        if (this.getServerType().hasServerConfiguration() && this.configuration == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorNoConfiguration, null);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        this.loadAdapter(clazz, monitor);
        if (((ServerType)this.getServerType()).startBeforePublish() && this.getServerState() == 4) {
            try {
                this.synchronousStart("run", monitor);
            }
            catch (CoreException ce) {
                Trace.trace(Trace.SEVERE, "Error starting server", ce);
                return ce.getStatus();
            }
        }
        IStatus status = null;
        try {
            try {
                this.firePublishStarted();
                status = this.doPublish(kind, monitor);
            }
            catch (Exception exception) {
                status = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.firePublishFinished(status);
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.firePublishFinished(status);
            return status;
        }
    }

    protected IStatus doPublish(int kind, IProgressMonitor monitor) {
        Trace.trace(Trace.FINEST, "-->-- Publishing to server: " + this.toString() + " -->--");
        try {
            return this.getBehaviourDelegate(monitor).publish(kind, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate publish() " + this.toString(), e);
            return null;
        }
    }

    public PublishOperation[] getTasks() {
        final ArrayList moduleList = new ArrayList();
        IModuleVisitor visitor = new IModuleVisitor(){

            public boolean visit(IModule[] module) {
                moduleList.add(module);
                return true;
            }
        };
        this.visit(visitor, null);
        ArrayList<PublishOperation> tasks = new ArrayList<PublishOperation>();
        String serverTypeId = this.getServerType().getId();
        IPublishTask[] publishTasks = ServerPlugin.getPublishTasks();
        if (publishTasks != null) {
            int size = publishTasks.length;
            int i = 0;
            while (i < size) {
                PublishOperation[] tasks2;
                IPublishTask task = publishTasks[i];
                if (task.supportsType(serverTypeId) && (tasks2 = task.getTasks(this, moduleList)) != null) {
                    int size2 = tasks2.length;
                    int j = 0;
                    while (j < size2) {
                        if (tasks2[j].getKind() == 2) {
                            tasks.add(tasks2[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return tasks.toArray(new PublishOperation[tasks.size()]);
    }

    public List getAllModules() {
        final ArrayList moduleList = new ArrayList();
        IModuleVisitor visitor = new IModuleVisitor(){

            public boolean visit(IModule[] module) {
                if (!moduleList.contains(module)) {
                    moduleList.add(module);
                }
                return true;
            }
        };
        this.visit(visitor, null);
        return moduleList;
    }

    public IModuleResource[] getPublishedResources(IModule[] module) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        return this.getServerPublishInfo().getModulePublishInfo(module).getResources();
    }

    public IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        return this.getServerPublishInfo().getDelta(module);
    }

    public Object getAdapter(Class adapter) {
        if (this.delegate != null && adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        if (this.behaviourDelegate != null && adapter.isInstance(this.behaviourDelegate)) {
            return this.behaviourDelegate;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        this.getDelegate(monitor);
        if (adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        this.getBehaviourDelegate(monitor);
        if (adapter.isInstance(this.behaviourDelegate)) {
            return this.behaviourDelegate;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        return this.getName();
    }

    public IStatus canStart(String mode2) {
        int state = this.getServerState();
        if (state != 4 && state != 0) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.canStartErrorState, null);
        }
        if (this.getServerType() == null || !this.getServerType().supportsLaunchMode(mode2)) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorLaunchMode, null);
        }
        return new Status(0, "org.eclipse.wst.server.core", 0, Messages.canStartOk, null);
    }

    public ILaunch getExistingLaunch() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int size = launches.length;
        int i = 0;
        while (i < size) {
            ILaunchConfiguration launchConfig = launches[i].getLaunchConfiguration();
            try {
                if (launchConfig != null) {
                    String serverId = launchConfig.getAttribute("server-id", null);
                    if (this.getId().equals(serverId) && !launches[i].isTerminated()) {
                        return launches[i];
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) {
        try {
            this.getBehaviourDelegate(monitor).setupLaunchConfiguration(workingCopy, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate setLaunchDefaults() " + this.toString(), e);
        }
    }

    public void importConfiguration(IRuntime runtime2, IProgressMonitor monitor) {
        try {
            this.getDelegate(monitor).importConfiguration(runtime2, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate setLaunchDefaults() " + this.toString(), e);
        }
    }

    public ILaunchConfiguration getLaunchConfiguration(boolean create, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationType launchConfigType = ((ServerType)this.getServerType()).getLaunchConfigurationType();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigs = null;
        try {
            launchConfigs = launchManager.getLaunchConfigurations(launchConfigType);
        }
        catch (CoreException coreException) {}
        if (launchConfigs != null) {
            int size = launchConfigs.length;
            int i = 0;
            while (i < size) {
                block10: {
                    try {
                        String serverId = launchConfigs[i].getAttribute("server-id", null);
                        if (!this.getId().equals(serverId)) break block10;
                        ILaunchConfigurationWorkingCopy wc = launchConfigs[i].getWorkingCopy();
                        this.setupLaunchConfiguration(wc, monitor);
                        if (wc.isDirty()) {
                            class Temp {
                                ILaunchConfiguration lc;
                                final /* synthetic */ Server this$0;

                                Temp(Server server) {
                                    this.this$0 = server;
                                    this.lc = null;
                                }
                            }
                            Temp temp = new Temp(this);
                            class SaveLaunchJob
                            extends Job {
                                final /* synthetic */ Server this$0;
                                private final /* synthetic */ Temp val$temp;
                                private final /* synthetic */ ILaunchConfigurationWorkingCopy val$wc;

                                public SaveLaunchJob(Server server, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, Temp temp) {
                                    super(NLS.bind((String)Messages.savingTask, (Object)iLaunchConfigurationWorkingCopy.getName()));
                                    this.this$0 = server;
                                    this.val$wc = iLaunchConfigurationWorkingCopy;
                                    this.val$temp = temp;
                                }

                                public IStatus run(IProgressMonitor monitor2) {
                                    try {
                                        this.val$temp.lc = this.val$wc.doSave();
                                    }
                                    catch (Exception exception) {}
                                    return new Status(0, "org.eclipse.wst.server.core", 0, "", null);
                                }
                            }
                            SaveLaunchJob job = new SaveLaunchJob(this, wc, temp);
                            job.schedule();
                            try {
                                job.join();
                            }
                            catch (Exception exception) {}
                            return temp.lc;
                        }
                        return launchConfigs[i];
                    }
                    catch (CoreException e) {
                        Trace.trace(Trace.SEVERE, "Error configuring launch", e);
                    }
                }
                ++i;
            }
        }
        if (!create) {
            return null;
        }
        String launchName = this.getValidLaunchConfigurationName(this.getName());
        launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(launchName);
        ILaunchConfigurationWorkingCopy wc = launchConfigType.newInstance(null, launchName);
        wc.setAttribute("server-id", this.getId());
        this.setupLaunchConfiguration(wc, monitor);
        return wc.doSave();
    }

    protected String getValidLaunchConfigurationName(String s) {
        if (s == null || s.length() == 0) {
            return "1";
        }
        int size = INVALID_CHARS.length;
        int i = 0;
        while (i < size) {
            s = s.replace(INVALID_CHARS[i], '_');
            ++i;
        }
        return s;
    }

    public void start(String mode2, IProgressMonitor monitor) throws CoreException {
        Trace.trace(Trace.FINEST, "Starting server: " + this.toString() + ", launchMode: " + mode2);
        try {
            ILaunchConfiguration launchConfig = this.getLaunchConfiguration(true, monitor);
            ILaunch launch = launchConfig.launch(mode2, monitor);
            Trace.trace(Trace.FINEST, "Launch: " + launch);
        }
        catch (CoreException e) {
            Trace.trace(Trace.SEVERE, "Error starting server " + this.toString(), e);
            throw e;
        }
    }

    protected void deleteLaunchConfigurations() {
        if (this.getServerType() == null) {
            return;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = ((ServerType)this.getServerType()).getLaunchConfigurationType();
        ILaunchConfiguration[] configs = null;
        try {
            configs = launchManager.getLaunchConfigurations(launchConfigType);
            int size = configs.length;
            int i = 0;
            while (i < size) {
                try {
                    if (this.getId().equals(configs[i].getAttribute("server-id", null))) {
                        configs[i].delete();
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public IStatus canRestart(String mode2) {
        if (!this.getServerType().supportsLaunchMode(mode2)) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorLaunchMode, null);
        }
        int state = this.getServerState();
        if (state == 2) {
            return new Status(0, "org.eclipse.wst.server.core", 0, Messages.canRestartOk, null);
        }
        return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorRestartNotStarted, null);
    }

    public boolean getServerRestartState() {
        if (this.getServerState() == 4) {
            return false;
        }
        return this.serverRestartNeeded;
    }

    public synchronized void setServerRestartState(boolean state) {
        if (state == this.serverRestartNeeded) {
            return;
        }
        this.serverRestartNeeded = state;
        this.fireRestartStateChangeEvent();
    }

    public void restart(final String mode2, final IProgressMonitor monitor) {
        if (this.getServerState() == 4) {
            return;
        }
        Trace.trace(Trace.FINEST, "Restarting server: " + this.getName());
        try {
            try {
                this.getBehaviourDelegate(null).restart(mode2);
                return;
            }
            catch (CoreException coreException) {
                Trace.trace(Trace.SEVERE, "Error calling delegate restart() " + this.toString());
                this.addServerListener(new IServerListener(){

                    public void serverChanged(ServerEvent event) {
                        int eventKind = event.getKind();
                        IServer server = event.getServer();
                        if (eventKind == 17 && server.getServerState() == 4) {
                            server.removeServerListener(this);
                            Thread t = new Thread(this, mode2, monitor){
                                final /* synthetic */ 4 this$1;
                                private final /* synthetic */ String val$mode2;
                                private final /* synthetic */ IProgressMonitor val$monitor;
                                {
                                    this.this$1 = var1_1;
                                    this.val$mode2 = string;
                                    this.val$monitor = iProgressMonitor;
                                }

                                public void run() {
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        4.access$0(this.this$1).start(this.val$mode2, this.val$monitor);
                                    }
                                    catch (Exception e) {
                                        Trace.trace(Trace.SEVERE, "Error while restarting server", e);
                                    }
                                }
                            };
                            t.setDaemon(true);
                            t.setPriority(3);
                            t.start();
                        }
                    }

                    static /* synthetic */ Server access$0(4 var0) {
                        return var0.Server.this;
                    }
                });
                this.stop(false);
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error restarting server", e);
        }
    }

    public IStatus canStop() {
        if (this.getServerState() == 4) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorStopAlreadyStopped, null);
        }
        return new Status(0, "org.eclipse.wst.server.core", 0, Messages.canStopOk, null);
    }

    public void stop(boolean force) {
        if (this.getServerState() == 4) {
            return;
        }
        Trace.trace(Trace.FINEST, "Stopping server: " + this.toString());
        try {
            this.getBehaviourDelegate(null).stop(force);
        }
        catch (Throwable t) {
            Trace.trace(Trace.SEVERE, "Error calling delegate stop() " + this.toString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String mode2, IServer.IOperationListener listener2) {
        Trace.trace(Trace.FINEST, "synchronousStart 1");
        final Object mutex = new Object();
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                int state;
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17 && ((state = server.getServerState()) == 2 || state == 4)) {
                    Object object = mutex;
                    synchronized (object) {
                        try {
                            Trace.trace(Trace.FINEST, "synchronousStart notify");
                            mutex.notifyAll();
                        }
                        catch (Exception e) {
                            Trace.trace(Trace.SEVERE, "Error notifying server start", e);
                        }
                    }
                }
            }
        };
        this.addServerListener(listener);
        final int serverTimeout = ((ServerType)this.getServerType()).getStartTimeout();
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        Thread thread = new Thread(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        Thread.sleep(serverTimeout * 1000);
                        if (timer.alreadyDone) break block5;
                        timer.timeout = true;
                        Object object = mutex;
                        synchronized (object) {
                            Trace.trace(Trace.FINEST, "synchronousStart notify timeout");
                            mutex.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error notifying server start timeout", e);
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        Trace.trace(Trace.FINEST, "synchronousStart 2");
        try {
            this.start(mode2, (IProgressMonitor)null);
        }
        catch (CoreException e) {
            this.removeServerListener(listener);
            timer.alreadyDone = true;
            listener2.done(e.getStatus());
            return;
        }
        Trace.trace(Trace.FINEST, "synchronousStart 3");
        Object object = mutex;
        synchronized (object) {
            try {
                while (!timer.timeout && this.getServerState() != 2 && this.getServerState() != 4) {
                    mutex.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error waiting for server start", e);
            }
        }
        this.removeServerListener(listener);
        timer.alreadyDone = true;
        if (timer.timeout) {
            listener2.done((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartTimeout, (Object[])new String[]{this.getName(), String.valueOf(serverTimeout)}), null));
            return;
        }
        timer.alreadyDone = true;
        if (this.getServerState() == 4) {
            listener2.done((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartFailed, (Object)this.getName()), null));
            return;
        }
        Trace.trace(Trace.FINEST, "synchronousStart 4");
        listener2.done((IStatus)new Status(0, "org.eclipse.wst.server.core", 0, "", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousStart(String mode2, IProgressMonitor monitor) throws CoreException {
        Trace.trace(Trace.FINEST, "synchronousStart 1");
        final Object mutex = new Object();
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                int state;
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17 && ((state = server.getServerState()) == 2 || state == 4)) {
                    Object object = mutex;
                    synchronized (object) {
                        try {
                            Trace.trace(Trace.FINEST, "synchronousStart notify");
                            mutex.notifyAll();
                        }
                        catch (Exception e) {
                            Trace.trace(Trace.SEVERE, "Error notifying server start", e);
                        }
                    }
                }
            }
        };
        this.addServerListener(listener);
        final int serverTimeout = ((ServerType)this.getServerType()).getStartTimeout();
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        Thread thread = new Thread(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        Thread.sleep(serverTimeout * 1000);
                        if (timer.alreadyDone) break block5;
                        timer.timeout = true;
                        Object object = mutex;
                        synchronized (object) {
                            Trace.trace(Trace.FINEST, "synchronousStart notify timeout");
                            mutex.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error notifying server start timeout", e);
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        Trace.trace(Trace.FINEST, "synchronousStart 2");
        try {
            this.start(mode2, monitor);
        }
        catch (CoreException e) {
            this.removeServerListener(listener);
            timer.alreadyDone = true;
            throw e;
        }
        Trace.trace(Trace.FINEST, "synchronousStart 3");
        Object object = mutex;
        synchronized (object) {
            try {
                while (!timer.timeout && this.getServerState() != 2 && this.getServerState() != 4) {
                    mutex.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error waiting for server start", e);
            }
        }
        this.removeServerListener(listener);
        timer.alreadyDone = true;
        if (timer.timeout) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartTimeout, (Object[])new String[]{this.getName(), String.valueOf(serverTimeout)}), null));
        }
        timer.alreadyDone = true;
        if (this.getServerState() == 4) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartFailed, (Object)this.getName()), null));
        }
        Trace.trace(Trace.FINEST, "synchronousStart 4");
    }

    public void synchronousRestart(String mode2, IProgressMonitor monitor) throws CoreException {
        this.synchronousStop(true);
        this.synchronousStart(mode2, monitor);
    }

    public void restart(String mode2, IServer.IOperationListener listener) {
        if (this.getServerState() == 4) {
            return;
        }
        Trace.trace(Trace.FINEST, "Restarting server: " + this.getName());
        try {
            final IServer.IOperationListener listener2 = listener;
            IServerListener curListener = new IServerListener(){

                public void serverChanged(ServerEvent event) {
                    int eventKind = event.getKind();
                    IServer server = event.getServer();
                    if (eventKind == 17 && server.getServerState() == 2) {
                        server.removeServerListener(this);
                        listener2.done((IStatus)new Status(0, "org.eclipse.wst.server.core", 0, "", null));
                    }
                }
            };
            try {
                this.addServerListener(curListener);
                this.getBehaviourDelegate(null).restart(mode2);
                return;
            }
            catch (CoreException coreException) {
                Trace.trace(Trace.SEVERE, "Error calling delegate restart() " + this.toString());
                this.removeServerListener(curListener);
                final String mode3 = mode2;
                this.addServerListener(new IServerListener(){

                    public void serverChanged(ServerEvent event) {
                        int eventKind = event.getKind();
                        IServer server = event.getServer();
                        if (eventKind == 17 && server.getServerState() == 4) {
                            server.removeServerListener(this);
                            Thread t = new Thread(this, mode3, listener2){
                                final /* synthetic */ 11 this$1;
                                private final /* synthetic */ String val$mode3;
                                private final /* synthetic */ IServer.IOperationListener val$listener2;
                                {
                                    this.this$1 = var1_1;
                                    this.val$mode3 = string;
                                    this.val$listener2 = iOperationListener;
                                }

                                public void run() {
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        11.access$0(this.this$1).start(this.val$mode3, this.val$listener2);
                                    }
                                    catch (Exception e) {
                                        Trace.trace(Trace.SEVERE, "Error while restarting server", e);
                                    }
                                }
                            };
                            t.setDaemon(true);
                            t.setPriority(3);
                            t.start();
                        }
                    }

                    static /* synthetic */ Server access$0(11 var0) {
                        return var0.Server.this;
                    }
                });
                this.stop(false);
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error restarting server", e);
            listener.done(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force, IServer.IOperationListener listener2) {
        if (this.getServerState() == 4) {
            return;
        }
        final Object mutex = new Object();
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17) {
                    int state = server.getServerState();
                    if (Server.this == server && state == 4) {
                        Object object = mutex;
                        synchronized (object) {
                            try {
                                mutex.notifyAll();
                            }
                            catch (Exception e) {
                                Trace.trace(Trace.SEVERE, "Error notifying server stop", e);
                            }
                        }
                    }
                }
            }
        };
        this.addServerListener(listener);
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        Thread thread = new Thread(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        Thread.sleep(120000L);
                        if (timer.alreadyDone) break block5;
                        timer.timeout = true;
                        Object object = mutex;
                        synchronized (object) {
                            Trace.trace(Trace.FINEST, "stop notify timeout");
                            mutex.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error notifying server stop timeout", e);
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.stop(force);
        Object object = mutex;
        synchronized (object) {
            try {
                while (!timer.timeout && this.getServerState() != 4) {
                    mutex.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error waiting for server stop", e);
            }
        }
        this.removeServerListener(listener);
        listener2.done((IStatus)new Status(0, "org.eclipse.wst.server.core", 0, "", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousStop(boolean force) {
        if (this.getServerState() == 4) {
            return;
        }
        final Object mutex = new Object();
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17) {
                    int state = server.getServerState();
                    if (Server.this == server && state == 4) {
                        Object object = mutex;
                        synchronized (object) {
                            try {
                                mutex.notifyAll();
                            }
                            catch (Exception e) {
                                Trace.trace(Trace.SEVERE, "Error notifying server stop", e);
                            }
                        }
                    }
                }
            }
        };
        this.addServerListener(listener);
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        Thread thread = new Thread(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        Thread.sleep(120000L);
                        if (timer.alreadyDone) break block5;
                        timer.timeout = true;
                        Object object = mutex;
                        synchronized (object) {
                            Trace.trace(Trace.FINEST, "stop notify timeout");
                            mutex.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error notifying server stop timeout", e);
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.stop(force);
        Object object = mutex;
        synchronized (object) {
            try {
                while (!timer.timeout && this.getServerState() != 4) {
                    mutex.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error waiting for server stop", e);
            }
        }
        this.removeServerListener(listener);
    }

    public IPath getTempDirectory() {
        return ServerPlugin.getInstance().getTempDirectory(this.getId());
    }

    protected String getXMLRoot() {
        return FILE_EXTENSION;
    }

    protected void loadState(IMemento memento) {
        this.resolve();
    }

    protected void resolve() {
        String runtimeId;
        IServerType oldServerType = this.serverType;
        String serverTypeId = this.getAttribute("server-type-id", (String)null);
        this.serverType = serverTypeId != null ? ServerCore.findServerType(serverTypeId) : null;
        if (this.serverType != null && !this.serverType.equals(oldServerType)) {
            this.serverState = ((ServerType)this.serverType).getInitialState();
        }
        if ((runtimeId = this.getAttribute(RUNTIME_ID, (String)null)) != null) {
            this.runtime = ServerCore.findRuntime(runtimeId);
        }
        String configPath = this.getAttribute(CONFIGURATION_ID, (String)null);
        this.configuration = null;
        if (configPath != null) {
            this.configuration = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(configPath));
        }
    }

    protected void setInternal(ServerWorkingCopy wc) {
        this.map = wc.map;
        this.configuration = wc.configuration;
        this.runtime = wc.runtime;
        this.serverSyncState = wc.serverSyncState;
        this.serverType = wc.serverType;
        this.modules = wc.modules;
        this.delegate = wc.delegate;
        this.autoPublish();
    }

    protected void saveState(IMemento memento) {
        if (this.serverType != null) {
            memento.putString("server-type", this.serverType.getId());
        }
        if (this.configuration != null) {
            memento.putString(CONFIGURATION_ID, this.configuration.getFullPath().toString());
        } else {
            memento.putString(CONFIGURATION_ID, null);
        }
        if (this.runtime != null) {
            memento.putString(RUNTIME_ID, this.runtime.getId());
        } else {
            memento.putString(RUNTIME_ID, null);
        }
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        if (add == null && remove == null) {
            throw new IllegalArgumentException("Add and remove cannot both be null");
        }
        try {
            return this.getDelegate(monitor).canModifyModules(add, remove);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate canModifyModules() " + this.toString(), e);
            return null;
        }
    }

    public IModule[] getModules() {
        if (this.modules == null) {
            ArrayList list = this.getAttribute(MODULE_LIST, (List)null);
            if (list == null) {
                list = new ArrayList(1);
            }
            this.modules = new ArrayList(list.size() + 1);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IModule module;
                String moduleId = (String)iterator.next();
                String name = "<unknown>";
                int index = moduleId.indexOf("::");
                if (index > 0) {
                    name = moduleId.substring(0, index);
                    moduleId = moduleId.substring(index + 2);
                }
                if ((module = ServerUtil.getModule(moduleId)) == null) {
                    module = new DeletedModule(moduleId, name);
                }
                if (module == null) continue;
                this.modules.add(module);
            }
        }
        IModule[] modules2 = new IModule[this.modules.size()];
        this.modules.toArray(modules2);
        return modules2;
    }

    public int getModuleState(IModule[] module) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            Integer in = (Integer)this.moduleState.get(this.getKey(module));
            if (in != null) {
                return in;
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public int getModulePublishState(IModule[] module) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            Integer in = (Integer)this.modulePublishState.get(this.getKey(module));
            if (in != null) {
                return in;
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public IModule[] getChildModules(IModule[] module, IProgressMonitor monitor) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            return this.getDelegate(monitor).getChildModules(module);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate getChildModules() " + this.toString(), e);
            return null;
        }
    }

    public IModule[] getRootModules(IModule module, IProgressMonitor monitor) throws CoreException {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            return this.getDelegate(monitor).getRootModules(module);
        }
        catch (CoreException se) {
            throw se;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate getParentModules() " + this.toString(), e);
            return null;
        }
    }

    public IStatus canControlModule(IModule[] module, IProgressMonitor monitor) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            boolean b = this.getBehaviourDelegate(monitor).canControlModule(module);
            if (b) {
                return new Status(0, "org.eclipse.wst.server.core", 0, Messages.canRestartModuleOk, null);
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate canRestartRuntime() " + this.toString(), e);
        }
        return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorRestartModule, null);
    }

    public boolean getModuleRestartState(IModule[] module) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            Boolean b = (Boolean)this.moduleRestartState.get(this.getKey(module));
            if (b != null) {
                return b;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void startModule(IModule[] module, IServer.IOperationListener listener) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            this.getBehaviourDelegate(null).startModule(module, null);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate restartModule() " + this.toString(), e);
        }
    }

    public void stopModule(IModule[] module, IServer.IOperationListener listener) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            this.getBehaviourDelegate(null).stopModule(module, null);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate restartModule() " + this.toString(), e);
        }
    }

    public void restartModule(IModule[] module, IServer.IOperationListener listener) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            this.getBehaviourDelegate(null).stopModule(module, null);
            this.getBehaviourDelegate(null).startModule(module, null);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate restartModule() " + this.toString(), e);
        }
    }

    public ServerPort[] getServerPorts(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).getServerPorts();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate getServerPorts() " + this.toString(), e);
            return null;
        }
    }

    public void visit(IModuleVisitor visitor, IProgressMonitor monitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor cannot be null");
        }
        IModule[] modules2 = this.getModules();
        if (modules2 != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                if (!this.visitModule(new IModule[]{modules2[i]}, visitor, monitor)) {
                    return;
                }
                ++i;
            }
        }
    }

    private boolean visitModule(IModule[] module, IModuleVisitor visitor, IProgressMonitor monitor) {
        if (module == null) {
            return true;
        }
        if (!visitor.visit(module)) {
            return false;
        }
        IModule[] children = this.getChildModules(module, monitor);
        if (children != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                IModule[] module2 = new IModule[module.length + 1];
                System.arraycopy(module, 0, module2, 0, module.length);
                module2[module.length] = children[i];
                if (!this.visitModule(module2, visitor, monitor)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String getKey(IModule[] module) {
        StringBuffer sb = new StringBuffer();
        if (module != null) {
            int size = module.length;
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    sb.append("#");
                }
                sb.append(module[i].getId());
                ++i;
            }
        }
        return sb.toString();
    }

    public void setModuleStatus(IModule[] module, IStatus status) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        this.moduleStatus.put(this.getKey(module), status);
    }

    public IStatus getModuleStatus(IModule[] module) {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            return (IStatus)this.moduleStatus.get(this.getKey(module));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setServerStatus(IStatus status) {
        this.serverStatus = status;
    }

    public IStatus getServerStatus() {
        return this.serverStatus;
    }

    public static void switchLocation(Server server, IProgressMonitor monitor) throws CoreException {
        IFile file = server.getFile();
        ServerWorkingCopy wc = (ServerWorkingCopy)server.createWorkingCopy();
        server.delete();
        if (file == null) {
            IProject project = ServerType.getServerProject();
            file = ServerUtil.getUnusedServerFile(project, wc.getServerType());
            wc.setFile(file);
            server.file = file;
        } else {
            wc.setFile(null);
            server.file = null;
        }
        wc.save(true, monitor);
    }

    public class AutoPublishThread
    extends Thread {
        public boolean stop;
        public int time = 0;

        public void run() {
            Trace.trace(Trace.FINEST, "Auto-publish thread starting for " + Server.this + " - " + this.time + "s");
            if (this.stop) {
                return;
            }
            try {
                AutoPublishThread.sleep(this.time * 1000);
            }
            catch (Exception exception) {}
            if (this.stop) {
                return;
            }
            Trace.trace(Trace.FINEST, "Auto-publish thread publishing " + Server.this);
            PublishServerJob publishJob = new PublishServerJob(Server.this, 3, false);
            publishJob.schedule();
        }
    }
}

