/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.WorkingCopyHelper;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class RuntimeWorkingCopy
extends Runtime
implements IRuntimeWorkingCopy {
    protected String PROP_ID_SET = "id-set";
    protected Runtime runtime;
    protected WorkingCopyHelper wch;
    protected RuntimeDelegate workingCopyDelegate;

    public RuntimeWorkingCopy(Runtime runtime) {
        super(runtime.getFile());
        this.runtime = runtime;
        this.runtimeType = runtime.getRuntimeType();
        this.map = new HashMap(runtime.map);
        this.wch = new WorkingCopyHelper(this);
    }

    public RuntimeWorkingCopy(IFile file, String id, IRuntimeType runtimeType) {
        super(file, id, runtimeType);
        this.wch = new WorkingCopyHelper(this);
        this.wch.setDirty(true);
        if (id == null || id.length() == 0) {
            id = ServerPlugin.generateId();
            this.map.put("id", id);
        } else {
            this.setAttribute(this.PROP_ID_SET, true);
        }
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public IRuntimeWorkingCopy createWorkingCopy() {
        return this;
    }

    public void setAttribute(String attributeName, int value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, String value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, List value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Map value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setName(String name) {
        this.wch.setName(name);
        boolean set = this.getAttribute(this.PROP_ID_SET, false);
        if (this.runtime == null && !set) {
            this.setAttribute("id", name);
        }
    }

    public void setTestEnvironment(boolean b) {
        this.setAttribute("test-environment", b);
    }

    public void setStub(boolean b) {
        this.setAttribute("stub", b);
    }

    public boolean isDirty() {
        return this.wch.isDirty();
    }

    public IRuntime getOriginal() {
        return this.runtime;
    }

    public void setReadOnly(boolean b) {
        this.wch.setLocked(b);
    }

    public void setPrivate(boolean b) {
        this.wch.setPrivate(b);
    }

    public void setLocation(IPath path) {
        if (path == null) {
            this.setAttribute("location", (String)null);
        } else {
            this.setAttribute("location", path.toString());
        }
    }

    public IRuntime save(boolean force, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.subTask(NLS.bind((String)Messages.savingTask, (Object)this.getName()));
        if (!force && this.getOriginal() != null) {
            this.wch.validateTimestamp(((Runtime)this.getOriginal()).getTimestamp());
        }
        Runtime origRuntime = this.runtime;
        if (this.runtime == null) {
            this.runtime = new Runtime(this.file);
        }
        String oldId = this.getId();
        String name = this.getName();
        boolean set = this.getAttribute(this.PROP_ID_SET, false);
        if (!oldId.equals(name) && !set) {
            this.setAttribute("id", name);
        } else {
            oldId = null;
        }
        this.runtime.setInternal(this);
        this.runtime.saveToMetadata(monitor);
        this.wch.setDirty(false);
        if (oldId != null) {
            this.updateRuntimeReferences(oldId, name, origRuntime);
        }
        return this.runtime;
    }

    protected void updateRuntimeReferences(String oldId, String newId, IRuntime origRuntime) {
        class UpdateRuntimeReferencesJob
        extends Job {
            final /* synthetic */ RuntimeWorkingCopy this$0;
            private final /* synthetic */ String val$oldId;
            private final /* synthetic */ String val$newId;

            public UpdateRuntimeReferencesJob(RuntimeWorkingCopy runtimeWorkingCopy, String string, String string2) {
                super(NLS.bind((String)Messages.savingTask, (Object)string));
                this.this$0 = runtimeWorkingCopy;
                this.val$newId = string;
                this.val$oldId = string2;
            }

            public IStatus run(IProgressMonitor monitor) {
                ResourceManager rm;
                IServer[] servers;
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                if (projects != null) {
                    int size = projects.length;
                    int i = 0;
                    while (i < size) {
                        ProjectProperties props = (ProjectProperties)ServerCore.getProjectProperties(projects[i]);
                        if (this.val$oldId.equals(props.getRuntimeTargetId())) {
                            try {
                                props.setRuntimeTargetId(this.val$newId, monitor);
                            }
                            catch (Exception e) {
                                Trace.trace(Trace.SEVERE, "Error setting runtime target", e);
                            }
                        }
                        ++i;
                    }
                }
                if (this.this$0.runtime != null && (servers = (rm = ResourceManager.getInstance()).getServers()) != null) {
                    int size = servers.length;
                    int i = 0;
                    while (i < size) {
                        if (this.val$oldId.equals(((Server)servers[i]).getRuntimeId())) {
                            try {
                                ServerWorkingCopy wc = (ServerWorkingCopy)servers[i].createWorkingCopy();
                                wc.setRuntimeId(this.val$newId);
                                wc.save(false, monitor);
                            }
                            catch (Exception exception) {}
                        }
                        ++i;
                    }
                }
                return new Status(0, "org.eclipse.wst.server.core", 0, "", null);
            }
        }
        UpdateRuntimeReferencesJob job = new UpdateRuntimeReferencesJob(this, newId, oldId);
        job.schedule();
    }

    protected static void rebuildRuntime(IRuntime runtime, boolean add) {
        if (runtime == null) {
            return;
        }
        class RebuildRuntimeReferencesJob
        extends Job {
            private final /* synthetic */ IRuntime val$runtime;
            private final /* synthetic */ boolean val$add;

            public RebuildRuntimeReferencesJob(IRuntime iRuntime, boolean bl) {
                super(Messages.taskPerforming);
                this.val$runtime = iRuntime;
                this.val$add = bl;
            }

            public IStatus run(IProgressMonitor monitor) {
                String id = this.val$runtime.getId();
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                if (projects != null) {
                    int size = projects.length;
                    int i = 0;
                    while (i < size) {
                        ProjectProperties props = (ProjectProperties)ServerCore.getProjectProperties(projects[i]);
                        if (id.equals(props.getRuntimeTargetId())) {
                            try {
                                if (this.val$add) {
                                    props.setRuntimeTarget(null, this.val$runtime, false, monitor);
                                } else {
                                    props.setRuntimeTarget(this.val$runtime, null, false, monitor);
                                }
                                projects[i].build(6, monitor);
                            }
                            catch (Exception e) {
                                Trace.trace(Trace.SEVERE, "Error setting runtime target", e);
                            }
                        }
                        ++i;
                    }
                }
                return new Status(0, "org.eclipse.wst.server.core", 0, "", null);
            }
        }
        RebuildRuntimeReferencesJob job = new RebuildRuntimeReferencesJob(runtime, add);
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeDelegate getWorkingCopyDelegate(IProgressMonitor monitor) {
        if (this.workingCopyDelegate != null) {
            return this.workingCopyDelegate;
        }
        RuntimeWorkingCopy runtimeWorkingCopy = this;
        synchronized (runtimeWorkingCopy) {
            if (this.workingCopyDelegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    RuntimeType runtimeType2 = (RuntimeType)this.runtimeType;
                    this.workingCopyDelegate = (RuntimeDelegate)runtimeType2.getElement().createExecutableExtension("class");
                    InternalInitializer.initializeRuntimeDelegate(this.workingCopyDelegate, this, monitor);
                    Trace.trace(Trace.PERFORMANCE, "RuntimeWorkingCopy.getWorkingCopyDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getRuntimeType().getId());
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString(), e);
                }
            }
        }
        return this.workingCopyDelegate;
    }

    public void dispose() {
        super.dispose();
        if (this.workingCopyDelegate != null) {
            this.workingCopyDelegate.dispose();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.wch.removePropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        this.wch.firePropertyChangeEvent(propertyName, oldValue, newValue);
    }

    protected void setDefaults(IProgressMonitor monitor) {
        try {
            this.getWorkingCopyDelegate(monitor).setDefaults(monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate setDefaults() " + this.toString(), e);
        }
    }
}

