/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeTargetHandler;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.IOrdered;
import org.eclipse.wst.server.core.internal.IStartup;
import org.eclipse.wst.server.core.internal.ModuleProperties;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeTargetHandler;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerCore {
    private static List runtimeTypes;
    private static List runtimeTargetHandlers;
    private static List serverTypes;

    static {
        ServerCore.executeStartups();
    }

    private ServerCore() {
    }

    private static ResourceManager getResourceManager() {
        return ResourceManager.getInstance();
    }

    public static IProjectProperties getProjectProperties(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        return new ProjectProperties(project);
    }

    public static IRuntimeType[] getRuntimeTypes() {
        if (runtimeTypes == null) {
            ServerCore.loadRuntimeTypes();
        }
        IRuntimeType[] rt = new IRuntimeType[runtimeTypes.size()];
        runtimeTypes.toArray(rt);
        return rt;
    }

    public static IRuntimeType findRuntimeType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeTypes == null) {
            ServerCore.loadRuntimeTypes();
        }
        Iterator iterator = runtimeTypes.iterator();
        while (iterator.hasNext()) {
            IRuntimeType runtimeType = (IRuntimeType)iterator.next();
            if (!id.equals(runtimeType.getId())) continue;
            return runtimeType;
        }
        return null;
    }

    public static IRuntimeTargetHandler[] getRuntimeTargetHandlers() {
        if (runtimeTargetHandlers == null) {
            ServerCore.loadRuntimeTargetHandlers();
        }
        IRuntimeTargetHandler[] rth = new IRuntimeTargetHandler[runtimeTargetHandlers.size()];
        runtimeTargetHandlers.toArray(rth);
        return rth;
    }

    public static IRuntimeTargetHandler findRuntimeTargetHandler(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeTargetHandlers == null) {
            ServerCore.loadRuntimeTargetHandlers();
        }
        Iterator iterator = runtimeTargetHandlers.iterator();
        while (iterator.hasNext()) {
            IRuntimeTargetHandler runtimeTargetListener = (IRuntimeTargetHandler)iterator.next();
            if (!id.equals(runtimeTargetListener.getId())) continue;
            return runtimeTargetListener;
        }
        return null;
    }

    public static IServerType[] getServerTypes() {
        if (serverTypes == null) {
            ServerCore.loadServerTypes();
        }
        IServerType[] st = new IServerType[serverTypes.size()];
        serverTypes.toArray(st);
        return st;
    }

    public static IServerType findServerType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (serverTypes == null) {
            ServerCore.loadServerTypes();
        }
        Iterator iterator = serverTypes.iterator();
        while (iterator.hasNext()) {
            IServerType serverType = (IServerType)iterator.next();
            if (!id.equals(serverType.getId())) continue;
            return serverType;
        }
        return null;
    }

    private static synchronized void executeStartups() {
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .startup extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "internalStartup");
        int size = cf.length;
        int i = 0;
        while (i < size) {
            try {
                IStartup startup = (IStartup)cf[i].createExecutableExtension("class");
                try {
                    startup.startup();
                }
                catch (Exception ex) {
                    Trace.trace(Trace.SEVERE, "Startup failed" + startup.toString(), ex);
                }
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded startup: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load startup: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .startup extension point -<-");
    }

    private static synchronized void loadRuntimeTypes() {
        if (runtimeTypes != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .runtimeTypes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "runtimeTypes");
        int size = cf.length;
        runtimeTypes = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                RuntimeType runtimeType = new RuntimeType(cf[i]);
                runtimeTypes.add(runtimeType);
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded runtimeType: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeType: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .runtimeTypes extension point -<-");
    }

    private static synchronized void loadRuntimeTargetHandlers() {
        if (runtimeTargetHandlers != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .runtimeTargetHandlers extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "runtimeTargetHandlers");
        int size = cf.length;
        runtimeTargetHandlers = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                RuntimeTargetHandler runtimeTargetListener = new RuntimeTargetHandler(cf[i]);
                runtimeTargetHandlers.add(runtimeTargetListener);
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded runtimeTargetHandler: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeTargetHandler: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        ServerCore.sortOrderedList(runtimeTargetHandlers);
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .runtimeTargetHandlers extension point -<-");
    }

    private static synchronized void loadServerTypes() {
        if (serverTypes != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .serverTypes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "serverTypes");
        int size = cf.length;
        serverTypes = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                ServerType serverType = new ServerType(cf[i]);
                serverTypes.add(serverType);
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded serverType: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load serverType: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .serverTypes extension point -<-");
    }

    public static IRuntime findRuntime(String id) {
        return ServerCore.getResourceManager().getRuntime(id);
    }

    public static IRuntime[] getRuntimes() {
        return ServerCore.getResourceManager().getRuntimes();
    }

    public static IServer findServer(String id) {
        return ServerCore.getResourceManager().getServer(id);
    }

    public static IServer[] getServers() {
        return ServerCore.getResourceManager().getServers();
    }

    public static void addRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        ServerCore.getResourceManager().addRuntimeLifecycleListener(listener);
    }

    public static void removeRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        ServerCore.getResourceManager().removeRuntimeLifecycleListener(listener);
    }

    public static void addServerLifecycleListener(IServerLifecycleListener listener) {
        ServerCore.getResourceManager().addServerLifecycleListener(listener);
    }

    public static void removeServerLifecycleListener(IServerLifecycleListener listener) {
        ServerCore.getResourceManager().removeServerLifecycleListener(listener);
    }

    private static List sortOrderedList(List list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                IOrdered a = (IOrdered)list.get(i);
                IOrdered b = (IOrdered)list.get(j);
                if (a.getOrder() > b.getOrder()) {
                    IOrdered temp = a;
                    list.set(i, b);
                    list.set(j, temp);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static IServer getDefaultServer(IModule module) {
        return ModuleProperties.getInstance().getDefaultServer(module);
    }

    public static void setDefaultServer(IModule module, IServer server, IProgressMonitor monitor) throws CoreException {
        ModuleProperties.getInstance().setDefaultServer(module, server, monitor);
    }
}

