/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.bean;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.JavaResourceFilter;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;

public class BeanClassWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private String thisPlugin = "org.eclipse.jst.ws.axis.creation.ui";
    private IProject serverProject_ = null;
    private Composite parent_ = null;
    private IWizardContainer context_ = null;
    private JavaResourceFilter filter_ = new JavaResourceFilter();
    private IResource initialResource_ = null;
    private String INFOPOP_PBCL_PAGE = "PBCL0001";
    private Text beanClassText_;
    private String INFOPOP_PBCL_TEXT_BEAN_CLASS = "PBCL0002";
    private Button beanClassBrowseButton_;
    private String INFOPOP_PBCL_BUTTON_BEAN_CLASS_BROWSE = "PBCL0003";
    private Button beanResourceBrowseButton_;
    private String INFOPOP_PBCL_BUTTON_BEAN_RESOURCE_BROWSE = "PBCL0004";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        MessageUtils msgUtils = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(msgUtils, this.thisPlugin);
        this.parent_ = parent;
        Composite group = uiUtils.createComposite(parent, 4);
        group.setToolTipText(msgUtils.getMessage("TOOLTIP_PBCL_PAGE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, String.valueOf(this.pluginId_) + "." + this.INFOPOP_PBCL_PAGE);
        this.beanClassText_ = uiUtils.createText(group, "LABEL_BEAN_CLASS_NAME", "TOOLTIP_PBCL_TEXT_BEAN_CLASS", this.INFOPOP_PBCL_TEXT_BEAN_CLASS, 2052);
        this.beanClassBrowseButton_ = uiUtils.createPushButton(group, "BUTTON_BROWSE_CLASSES", "TOOLTIP_PBCL_BUTTON_BEAN_CLASS_BROWSE", this.INFOPOP_PBCL_BUTTON_BEAN_CLASS_BROWSE);
        this.beanClassBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanClassWidget.this.handleBrowseClasses();
            }
        });
        this.beanResourceBrowseButton_ = uiUtils.createPushButton(group, "BUTTON_BROWSE_FILES", "TOOLTIP_PBCL_BUTTON_BEAN_RESOURCE_BROWSE", this.INFOPOP_PBCL_BUTTON_BEAN_RESOURCE_BROWSE);
        this.beanResourceBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanClassWidget.this.handleBrowseFiles();
            }
        });
        return this;
    }

    private void handleBrowseClasses() {
        String className = DialogUtils.browseClasses((Shell)this.parent_.getShell(), (IProject)this.serverProject_, (IWizardContainer)this.context_);
        if (className != null) {
            this.beanClassText_.setText(className);
        }
    }

    private void handleBrowseFiles() {
        IPath path;
        String basename;
        IResource resource;
        IProject topResource = this.serverProject_;
        if (topResource == null) {
            topResource = ResourceUtils.getWorkspaceRoot();
        }
        if ((resource = DialogUtils.browseResources((Shell)this.parent_.getShell(), (IResource)topResource, (IResource)this.initialResource_, (Filter)this.filter_)) != null && (basename = (path = resource.getFullPath()).lastSegment()) != null && basename.length() > 0) {
            String beanClass;
            String beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)path);
            String string = beanClass = beanPackage == null ? basename : String.valueOf(beanPackage) + "." + basename;
            if (beanClass.toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class")) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
            this.beanClassText_.setText(beanClass);
        }
    }

    public void setCurrentPage(IWizardPage page) {
        this.context_ = page.getWizard().getContainer();
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClassText_.setText(beanClassName);
    }

    public String getBeanClassName() {
        return this.beanClassText_.getText().trim();
    }

    public void setServerProjectName(String name) {
        this.serverProject_ = (IProject)ResourceUtils.findResource((IPath)new Path(name).makeAbsolute());
    }

    public void setInitialResource(IResource resource) {
        this.initialResource_ = resource;
    }
}

