/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.command;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.axis.tools.ant.axis.AdminClientTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.eclipse.jst.ws.internal.axis.consumption.core.command.AxisDeployCommand;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class AxisDeployCommand
extends SimpleCommand {
    private static final String SERVICE_EXT = "/services/AdminService";
    private JavaWSDLParameter javaWSDLParam;
    private ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.jst.ws.axis.consumption.core.consumption");

    public AxisDeployCommand() {
        super("org.eclipse.jst.ws.internal.axis.consumption.core.command.AxisDeployCommand", "org.eclipse.jst.ws.internal.axis.consumption.core.command.AxisDeployCommand");
    }

    public Status execute(Environment environment) {
        if (this.javaWSDLParam == null) {
            return new SimpleStatus("Java2WSDLCommand", this.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
        }
        if (this.javaWSDLParam.getProjectURL() == null || this.javaWSDLParam.getProjectURL().equals("")) {
            return new SimpleStatus("Java2WSDLCommand", this.getMessage("MSG_ERROR_PROJECT_URL_PARAM_NOT_SET"), 4);
        }
        if (this.javaWSDLParam.getDeploymentFiles() == null || this.javaWSDLParam.getDeploymentFiles().length == 0) {
            return new SimpleStatus("Java2WSDLCommand", this.getMessage("MSG_ERROR_DEPLOY_FILE_PARAM_NOT_SET"), 4);
        }
        environment.getProgressMonitor().report(this.getMessage("MSG_AXIS_DEPLOY"));
        Status status = this.executeAntTask();
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    protected Status executeAntTask() {
        final class DeployTask
        extends AdminClientTask {
            final /* synthetic */ AxisDeployCommand this$0;

            public DeployTask(AxisDeployCommand axisDeployCommand) {
                this.this$0 = axisDeployCommand;
                this.project = new Project();
                this.project.init();
                this.taskType = "axis";
                this.taskName = "axis-admin";
                this.target = new Target();
            }
        }
        DeployTask adminClient = new DeployTask(this);
        String url = String.valueOf(this.javaWSDLParam.getProjectURL()) + SERVICE_EXT;
        adminClient.setUrl(url);
        adminClient.setXmlFile(new File(this.javaWSDLParam.getDeploymentFiles()[0]));
        try {
            BuildException lastException = null;
            int index = 0;
            while (index < 20) {
                try {
                    lastException = null;
                    adminClient.execute();
                }
                catch (BuildException exc) {
                    lastException = exc;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (lastException == null) break;
                ++index;
            }
            if (lastException != null) {
                throw lastException;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().toString();
            }
            Status[] childStatus = new Status[]{new SimpleStatus("AxisDeployCommand", message, 4)};
            return new SimpleStatus("AxisDeployCommand", this.getMessage("MSG_ERROR_AXIS_DEPLOY"), childStatus);
        }
        return new SimpleStatus("AxisDeployCommand", this.getMessage("MSG_AXIS_DEPLOY_OK"), 0);
    }

    private String getMessage(String messageId, String parm1) {
        String message = this.resource.getString(messageId);
        return MessageFormat.format(message, parm1);
    }

    public String getMessage(String key) {
        return this.resource.getString(key);
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }
}

