/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RemoveReferenceComponentOperation
extends AbstractDataModelOperation {
    public RemoveReferenceComponentOperation() {
    }

    public RemoveReferenceComponentOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.removeReferencedComponents(monitor);
        this.removeProjectReferences();
        return OK_STATUS;
    }

    private void removeProjectReferences() {
        ComponentHandle handle = (ComponentHandle)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE");
        IProject sourceProject = handle.getProject();
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i = 0;
        while (i < modList.size()) {
            ComponentHandle targethandle = (ComponentHandle)modList.get(i);
            IProject targetProject = targethandle.getProject();
            targetprojectList.add(targetProject);
            ++i;
        }
        try {
            ProjectUtilities.removeReferenceProjects((IProject)sourceProject, targetprojectList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void removeReferencedComponents(IProgressMonitor monitor) {
        ComponentHandle sourceHandle = (ComponentHandle)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE");
        IVirtualComponent sourceComp = ComponentCore.createComponent(sourceHandle.getProject(), sourceHandle.getName());
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        int i = 0;
        while (i < modList.size()) {
            ComponentHandle handle = (ComponentHandle)modList.get(i);
            IVirtualReference ref = sourceComp.getReference(handle.getName());
            if (ref != null && ref.getReferencedComponent() != null && ref.getReferencedComponent().isBinary()) {
                this.removeRefereneceInComponent(sourceComp, ref);
            } else {
                IVirtualComponent comp = ComponentCore.createComponent(handle.getProject(), handle.getName());
                if (Arrays.asList(comp.getReferencingComponents()).contains(sourceComp)) {
                    this.removeRefereneceInComponent(sourceComp, sourceComp.getReference(comp.getName()));
                }
            }
            ++i;
        }
    }

    private void removeRefereneceInComponent(IVirtualComponent component, IVirtualReference reference) {
        ArrayList<IVirtualReference> refList = new ArrayList<IVirtualReference>();
        IVirtualReference[] refArray = component.getReferences();
        int i = 0;
        while (i < refArray.length) {
            if (!refArray[i].getReferencedComponent().equals(reference.getReferencedComponent())) {
                refList.add(refArray[i]);
            }
            ++i;
        }
        component.setReferences(refList.toArray(new IVirtualReference[refList.size()]));
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

