/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;

public class SlaveDescriptor {
    public static final String SLAVE_OPERATION = "slaveOperation";
    public static final String ATT_OPERATION_CLASS = "operationClass";
    public static final String ATT_ID = "id";
    private static final String ATT_OVERRIDE_ID = "overrideId";
    public static final String ATT_NAME = "name";
    public static final String ATT_DESCRIPTION = "description";
    private String id;
    private String name;
    private String description;
    private String operationClass;
    private String overrideId;
    private final IConfigurationElement element;

    public SlaveDescriptor(IConfigurationElement element) {
        this.element = element;
        this.init();
    }

    private void init() {
        this.id = this.element.getAttribute(ATT_ID);
        this.overrideId = this.element.getAttribute(ATT_OVERRIDE_ID);
        this.name = this.element.getAttribute(ATT_NAME);
        this.description = this.element.getAttribute(ATT_DESCRIPTION);
        this.operationClass = this.element.getAttribute(ATT_OPERATION_CLASS);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public WTPOperation createOperation() {
        try {
            return (WTPOperation)this.element.createExecutableExtension(ATT_OPERATION_CLASS);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
            return null;
        }
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getOperationClass() {
        return this.operationClass;
    }

    public String toString() {
        return this.getClass() + "[name=" + this.getName() + ", operationClass=" + this.getOperationClass() + "]";
    }

    public String getId() {
        return this.id;
    }

    public String getOverrideId() {
        return this.overrideId;
    }
}

