/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.servertarget;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ResourceManager;

public class J2EEProjectServerTargetOp
extends AbstractDataModelOperation {
    public J2EEProjectServerTargetOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String serverTargetId = this.model.getStringProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        IRuntime runtime = ResourceManager.getInstance().getRuntime(serverTargetId);
        IProject project = null;
        String name = this.model.getStringProperty("IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME");
        if (name != null && name.length() > 0) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        if (runtime != null && project != null) {
            try {
                ServerCore.getProjectProperties(project).setRuntimeTarget(runtime, monitor);
                if (this.model.getBooleanProperty("IJ2EEProjectServerTargetDataModelProperties.UPDATE_MODULES")) {
                    project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature");
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

