/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.rename;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.internal.J2EEEditModel;
import org.eclipse.jst.j2ee.internal.earcreation.AddModuleToEARProjectCommand;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.earcreation.RemoveModuleFromEARProjectCommand;
import org.eclipse.jst.j2ee.internal.earcreation.UpdateModuleReferencesInEARProjectCommand;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.rename.RenameModuleDependencyOperation;
import org.eclipse.jst.j2ee.internal.rename.RenameOptions;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.ComposedEditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.LooseComposedEditModel;

public class RenameModuleOperation
extends WTPOperation {
    protected RenameOptions options;
    protected IProject renamedProject = null;
    protected LooseComposedEditModel renameEditModel = null;
    protected Map deferredCommands;
    protected IProgressMonitor monitor;
    protected RenameModuleDependencyOperation renameModuleDependencyOperation;
    protected List dirtyEarModels;
    protected static String EDIT_MODEL_KEY = "RENAME_MODULES";

    public RenameModuleOperation(RenameOptions options) {
        this.options = options;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = aMonitor;
        try {
            this.buildRenameCommandsIfNecessary();
            if (this.options.shouldRenameModuleDependencies()) {
                this.renameModuleDependencies();
            }
            this.checkIfEarsAreDirty();
            this.executeDeferredCommands();
            this.saveModelsIfNecessary();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.releaseModels();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.releaseModels();
            return;
        }
    }

    protected void checkIfEarsAreDirty() {
        this.dirtyEarModels = new ArrayList();
        if (this.deferredCommands == null) {
            return;
        }
        Iterator models = this.deferredCommands.keySet().iterator();
        while (models.hasNext()) {
            EAREditModel model = (EAREditModel)((Object)models.next());
            if (!model.isDirty() || this.dirtyEarModels.contains((Object)model)) continue;
            this.dirtyEarModels.add(model);
        }
    }

    protected void buildRenameCommands() {
        this.deferredCommands = new HashMap();
        List earProjects = EARNatureRuntime.getAllEARProjectsInWorkbench();
        int i = 0;
        while (i < earProjects.size()) {
            IProject p = (IProject)earProjects.get(i);
            EARNatureRuntime runtime = EARNatureRuntime.getRuntime(p);
            if (runtime != null) {
                this.buildRenameCommands(runtime);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildRenameCommands(EARNatureRuntime runtime) {
        EAREditModel model;
        block10: {
            ArrayList<CompoundCommand> commands = new ArrayList<CompoundCommand>();
            List projects = this.options.getModuleAndUtilityProjects();
            model = null;
            try {
                model = runtime.getEarEditModelForWrite((Object)this);
                if (this.options.shouldRenameModules()) {
                    int i = 0;
                    while (i < projects.size()) {
                        IProject project = (IProject)projects.get(i);
                        Module m = runtime.getModule(project);
                        if (m != null) {
                            String uri;
                            boolean changedUri = false;
                            if (!m.getUri().startsWith(project.getName())) {
                                uri = m.getUri();
                            } else {
                                changedUri = true;
                                uri = this.options.getNewName().replace(' ', '_');
                                uri = String.valueOf(uri) + "." + URI.createURI((String)m.getUri()).fileExtension();
                            }
                            CompoundCommand compoundCommand = new CompoundCommand();
                            compoundCommand.append((Command)new RemoveModuleFromEARProjectCommand(m, runtime.getProject()));
                            this.renamedProject = project.getWorkspace().getRoot().getProject(this.options.getNewName());
                            compoundCommand.append((Command)new AddModuleToEARProjectCommand(this.renamedProject, runtime.getProject(), uri, this.options.getNewContextRoot(), null));
                            if (changedUri) {
                                compoundCommand.append((Command)new UpdateModuleReferencesInEARProjectCommand(runtime.getProject(), m, uri));
                            }
                            commands.add(compoundCommand);
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (!commands.isEmpty()) {
                    this.deferredCommands.put(model, commands);
                    throw throwable;
                }
                model.releaseAccess((Object)this);
                throw throwable;
            }
            {
                Object var11_13 = null;
                if (commands.isEmpty()) break block10;
                this.deferredCommands.put(model, commands);
            }
            return;
        }
        model.releaseAccess((Object)this);
    }

    protected void releaseModels() {
        if (this.renameEditModel != null) {
            this.renameEditModel = null;
        }
        if (this.deferredCommands != null) {
            Iterator iterator = this.deferredCommands.keySet().iterator();
            EditModel model = null;
            while (iterator.hasNext()) {
                model = (EditModel)iterator.next();
                model.releaseAccess((Object)this);
            }
            this.deferredCommands.clear();
        }
    }

    public void release() {
        this.releaseModels();
    }

    protected void saveModelsIfNecessary() {
        if (this.deferredCommands == null) {
            return;
        }
        Iterator models = this.deferredCommands.keySet().iterator();
        while (models.hasNext()) {
            EAREditModel model = (EAREditModel)((Object)models.next());
            if (!model.isDirty()) continue;
            if (this.dirtyEarModels.contains((Object)model)) {
                model.saveIfNecessary((Object)this);
                continue;
            }
            model.save((Object)this);
        }
    }

    protected void renameModuleDependencies() throws InvocationTargetException, InterruptedException {
        this.getRenameModuleDependencyOperation().run(this.monitor);
    }

    protected void executeDeferredCommands() {
        Iterator it = this.deferredCommands.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List commands = (List)entry.getValue();
            this.executeCommands(commands);
        }
    }

    protected void executeCommands(List commands) {
        int i = 0;
        while (i < commands.size()) {
            AbstractCommand cmd = (AbstractCommand)commands.get(i);
            cmd.execute();
            ++i;
        }
    }

    public ComposedEditModel getRenameEditModel() {
        if (this.renameEditModel == null) {
            this.initializeRenameEditModel();
        }
        return this.renameEditModel;
    }

    protected void initializeRenameEditModel() {
        if (this.options.getAllProjectsToRename().size() == 0) {
            throw new RuntimeException(J2EECreationResourceHandler.getString("RenameModuleOperation_UI_0"));
        }
        IProject project = null;
        project = (IProject)this.options.getAllProjectsToRename().get(0);
        this.buildRenameCommandsIfNecessary();
        this.renameEditModel = new LooseComposedEditModel(EDIT_MODEL_KEY, (EMFWorkbenchContext)WorkbenchResourceHelper.getEMFContext((IProject)project)){

            public List getNonResourceFiles() {
                List result = super.getNonResourceFiles();
                result.addAll(RenameModuleOperation.this.getAffectedNonResourceFiles());
                return result;
            }
        };
        Iterator it = this.deferredCommands.keySet().iterator();
        while (it.hasNext()) {
            this.renameEditModel.addChild((EditModel)((J2EEEditModel)((Object)it.next())));
        }
    }

    protected void buildRenameCommandsIfNecessary() {
        if (this.deferredCommands != null && !this.deferredCommands.isEmpty()) {
            return;
        }
        this.buildRenameCommands();
    }

    protected List getAffectedNonResourceFiles() {
        if (this.options.shouldRenameModuleDependencies()) {
            return this.getRenameModuleDependencyOperation().getAffectedFiles();
        }
        return Collections.EMPTY_LIST;
    }

    protected RenameModuleDependencyOperation getRenameModuleDependencyOperation() {
        if (this.renameModuleDependencyOperation == null) {
            ArrayList earEditModels = new ArrayList();
            earEditModels.addAll(this.deferredCommands.keySet());
            this.renameModuleDependencyOperation = new RenameModuleDependencyOperation(earEditModels, new HashSet(this.options.getModuleAndUtilityProjects()), this.renamedProject);
        }
        return this.renameModuleDependencyOperation;
    }

    public IStatus getStatus() {
        return this.renameModuleDependencyOperation.getStatus();
    }
}

