/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.internal.emfworkbench.CompatibilityWorkbenchURIConverterImpl;

public class J2EEWorkbenchURIConverterImpl
extends CompatibilityWorkbenchURIConverterImpl
implements ISynchronizerExtender {
    protected J2EENature nature;
    protected List inputChangedListeners;

    public J2EEWorkbenchURIConverterImpl(J2EENature aNature, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        super((IContainer)aNature.getProject(), aSynchronizer);
        this.nature = aNature;
        this.initialize();
    }

    protected void initialize() {
        if (this.resourceSetSynchronizer != null) {
            this.resourceSetSynchronizer.addExtender((ISynchronizerExtender)this);
        }
    }

    protected void deNormalize(List resources) {
        int i = 0;
        while (i < resources.size()) {
            Resource aResource = (Resource)resources.get(i);
            aResource.setURI(this.deNormalize(aResource.getURI()));
            ++i;
        }
    }

    protected void normalize(List resources) {
        int i = 0;
        while (i < resources.size()) {
            Resource aResource = (Resource)resources.get(i);
            aResource.setURI(this.normalize(aResource.getURI()));
            ++i;
        }
    }

    protected boolean isBroken() {
        return this.getInputContainer() == null;
    }

    public J2EENature getNature() {
        return this.nature;
    }

    public void setNature(J2EENature nature) {
        this.nature = nature;
    }

    public void projectChanged(IResourceDelta delta) {
        if (this.shouldNotifyChangedListeners(delta)) {
            this.notifyInputChangedListeners();
        }
    }

    protected boolean shouldNotifyChangedListeners(IResourceDelta delta) {
        return this.isInputContainerChanged(delta) || this.isBroken() && this.isFolderAdded(delta);
    }

    public void addListener(InputChangedListener aListener) {
        if (this.inputChangedListeners == null) {
            this.inputChangedListeners = new ArrayList();
        }
        this.inputChangedListeners.add(aListener);
    }

    private void notifyInputChangedListeners() {
        if (this.inputChangedListeners != null && !this.inputChangedListeners.isEmpty()) {
            int i = 0;
            while (i < this.inputChangedListeners.size()) {
                InputChangedListener listener = (InputChangedListener)this.inputChangedListeners.get(i);
                listener.inputsChanged(this);
                ++i;
            }
        }
    }

    protected boolean isFolderAdded(IResourceDelta delta) {
        final boolean[] result = new boolean[]{false};
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta aDelta) throws CoreException {
                if (result[0] || aDelta.getResource() == null) {
                    return false;
                }
                switch (aDelta.getResource().getType()) {
                    case 2: {
                        if (aDelta.getKind() == 1) {
                            result[0] = true;
                            return false;
                        }
                        return true;
                    }
                }
                return true;
            }
        };
        try {
            visitor.visit(delta);
        }
        catch (CoreException core) {
            Logger.getLogger().logError((Throwable)core);
        }
        return result[0];
    }

    protected boolean isInputContainerChanged(IResourceDelta delta) {
        IContainer input = this.getInputContainer();
        if (input == null) {
            return false;
        }
        IResourceDelta child = delta.findMember(input.getProjectRelativePath());
        return child != null && (child.getKind() == 2 || child.getKind() == 4);
    }

    protected boolean objectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public void projectClosed() {
    }

    public IContainer getInputContainer() {
        List list = this.getInputContainers();
        if (!list.isEmpty()) {
            int i = 0;
            while (i < list.size()) {
                IFolder sourceFolder;
                IContainer container = (IContainer)list.get(i);
                if (container instanceof IFolder && J2EEProjectUtilities.isSourceFolderAnInputContainer(sourceFolder = (IFolder)container)) {
                    return sourceFolder;
                }
                ++i;
            }
            return (IContainer)list.get(0);
        }
        return null;
    }

    public static interface InputChangedListener {
        public void inputsChanged(J2EEWorkbenchURIConverterImpl var1);
    }
}

