/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.util.ArrayList;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.internal.operations.DefaultJ2EEComponentCreationOperation;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.earcreation.IDefaultJ2EEComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.moduleextension.EjbModuleExtension;
import org.eclipse.jst.j2ee.internal.moduleextension.JcaModuleExtension;
import org.eclipse.jst.j2ee.internal.moduleextension.WebModuleExtension;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class DefaultJ2EEComponentCreationDataModelProvider
extends AbstractDataModelProvider
implements IDefaultJ2EEComponentCreationDataModelProperties {
    private static String CREATE_BASE = "DefaultJ2EEComponentCreationDataModel.CREATE_";
    private static final int EJB = 0;
    private static final int WEB = 1;
    private static final int RAR = 2;
    private static final int CLIENT = 3;
    private static final String WEB_SUFFIX = "Web";
    private static final String EJB_SUFFIX = "EJB";
    private static final String CLIENT_SUFFIX = "Client";
    private static final String CONNECTOR_SUFFIX = "Connector";
    private IDataModel ejbModel;
    private IDataModel webModel;
    private IDataModel jcaModel;
    private IDataModel clientModel;

    public String[] getPropertyNames() {
        String[] props = new String[]{"DefaultJ2EEComponentCreationDataModel.PROJECT_NAME", "DefaultJ2EEComponentCreationDataModel.EAR_NAME", "DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME", "DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME", "DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME", "DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME", "DefaultJ2EEComponentCreationDataModel.J2EE_VERSION", "DefaultJ2EEComponentCreationDataModel.CREATE_EJB", "DefaultJ2EEComponentCreationDataModel.CREATE_WEB", "DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT", "DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR", "DefaultJ2EEComponentCreationDataModel.MODULE_NAME_COLLISIONS_VALIDATION", "DefaultJ2EEComponentCreationDataModel.ENABLED", "DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_CLIENT", "DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_EJB", "DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_JCA", "DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB"};
        return props;
    }

    public IDataModelOperation getDefaultOperation() {
        return new DefaultJ2EEComponentCreationOperation(this.getDataModel());
    }

    public void init() {
        this.initNestedCreationModels();
        super.init();
    }

    protected void initNestedCreationModels() {
        JcaModuleExtension rarExt;
        WebModuleExtension webExt;
        this.clientModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentCreationDataModelProvider());
        this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_CLIENT", this.clientModel);
        EjbModuleExtension ejbExt = EarModuleManager.getEJBModuleExtension();
        if (ejbExt != null) {
            this.ejbModel = ejbExt.createProjectDataModel();
            if (this.ejbModel != null) {
                this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_EJB", this.ejbModel);
            }
        }
        if ((webExt = EarModuleManager.getWebModuleExtension()) != null) {
            this.webModel = webExt.createProjectDataModel();
            if (this.webModel != null) {
                this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB", this.webModel);
            }
        }
        if ((rarExt = EarModuleManager.getJCAModuleExtension()) != null) {
            this.jcaModel = rarExt.createProjectDataModel();
            if (this.jcaModel != null) {
                this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_JCA", this.jcaModel);
            }
        }
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.startsWith(CREATE_BASE)) {
            return this.getDefaultCreateValue(propertyName);
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.ENABLED")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultCreateValue(String propertyName) {
        int version;
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR") && (version = this.getIntProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION")) < 13) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private int convertPropertyNameToInt(String propertyName) {
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_WEB")) {
            return 1;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_EJB")) {
            return 0;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
            return 2;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT")) {
            return 3;
        }
        return -1;
    }

    private String ensureUniqueProjectName(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String newName = projectName;
        int index = 0;
        IProject proj = root.getProject(newName);
        while (proj.exists()) {
            newName = String.valueOf(projectName) + ++index;
            proj = root.getProject(newName);
        }
        return newName;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean notify = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION")) {
            this.updatedJ2EEVersion((Integer)propertyValue);
            return true;
        }
        if (propertyName.startsWith(CREATE_BASE)) {
            this.notifyEnablement(this.convertPropertyNameToInt(propertyName));
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.EAR_NAME")) {
            this.setDefaultComponentNames((String)propertyValue);
        }
        return notify;
    }

    private void notifyEnablement(int flag) {
        String propertyName = null;
        switch (flag) {
            case 0: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME";
                break;
            }
            case 1: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME";
                break;
            }
            case 3: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME";
                break;
            }
            case 2: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME";
            }
        }
        if (propertyName != null) {
            this.model.notifyPropertyChange(propertyName, 3);
        }
    }

    private void updatedJ2EEVersion(Integer version) {
        this.setNestedJ2EEVersion(version);
        if (version < 13 && this.model.isPropertySet("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
            this.model.setProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR", (Object)Boolean.FALSE);
        }
    }

    public IStatus validateModuleNameCollisions() {
        if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.ENABLED")) {
            ArrayList<String> list = new ArrayList<String>();
            String projectName = null;
            String actualProjectName = null;
            boolean errorCollision = false;
            boolean errorNoSelection = true;
            if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT")) {
                actualProjectName = this.clientModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
                projectName = CoreFileSystemLibrary.isCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                list.add(projectName);
                errorNoSelection = false;
            }
            if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB")) {
                actualProjectName = this.ejbModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
                String string = projectName = CoreFileSystemLibrary.isCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                if (!list.contains(projectName)) {
                    list.add(projectName);
                } else {
                    errorCollision = true;
                }
                errorNoSelection = false;
            }
            if (!errorCollision && this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB")) {
                actualProjectName = this.webModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
                String string = projectName = CoreFileSystemLibrary.isCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                if (!list.contains(projectName)) {
                    list.add(projectName);
                } else {
                    errorCollision = true;
                }
                errorNoSelection = false;
            }
            if (!errorCollision && this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
                actualProjectName = this.jcaModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
                String string = projectName = CoreFileSystemLibrary.isCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                if (!list.contains(projectName)) {
                    list.add(projectName);
                } else {
                    errorCollision = true;
                }
                errorNoSelection = false;
            }
            if (errorCollision) {
                return J2EEPlugin.newErrorStatus(EARCreationResourceHandler.getString("DuplicateModuleNames", new Object[]{actualProjectName}), null);
            }
            if (errorNoSelection) {
                return J2EEPlugin.newErrorStatus(EARCreationResourceHandler.getString("NoModulesSelected"), null);
            }
        }
        return OK_STATUS;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME")) {
            return this.validateComponentName(this.getStringProperty("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME"));
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME")) {
            return this.validateComponentName(this.getStringProperty("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME"));
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME")) {
            return this.validateComponentName(this.getStringProperty("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME"));
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME")) {
            return this.validateComponentName(this.getStringProperty("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME"));
        }
        return super.validate(propertyName);
    }

    private IStatus validateComponentName(String componentName) {
        IStatus status = OK_STATUS;
        if (status.isOK()) {
            if (componentName.indexOf("#") != -1) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"35");
                return WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
            if (componentName == null || componentName.equals("")) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"34");
                return WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
        }
        return status;
    }

    private void setDefaultNestedComponentName(String name, int flag) {
        IDataModel modModule = this.getNestedModel(flag);
        if (modModule != null) {
            String compName = this.ensureUniqueProjectName(name);
            modModule.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)compName);
        }
    }

    private void setDefaultComponentNames(String base) {
        String componentName = base.endsWith(EJB_SUFFIX) ? base : String.valueOf(base) + EJB_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 0);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME", componentName);
        componentName = base.endsWith(WEB_SUFFIX) ? base : String.valueOf(base) + WEB_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 1);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME", componentName);
        componentName = base.endsWith(CLIENT_SUFFIX) ? base : String.valueOf(base) + CLIENT_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 3);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME", componentName);
        componentName = base.endsWith(CONNECTOR_SUFFIX) ? base : String.valueOf(base) + CONNECTOR_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 2);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME", componentName);
    }

    private void setNestedJ2EEVersion(Object j2eeVersion) {
        int j2eeVer = (Integer)j2eeVersion;
        if (this.ejbModel != null) {
            int ejbVersion = J2EEVersionUtil.convertJ2EEVersionIDToEJBVersionID(j2eeVer);
            this.ejbModel.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", ejbVersion);
        }
        if (this.webModel != null) {
            int webVersion = J2EEVersionUtil.convertJ2EEVersionIDToWebVersionID(j2eeVer);
            this.webModel.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", webVersion);
        }
        if (this.jcaModel != null) {
            int jcaVersion = J2EEVersionUtil.convertJ2EEVersionIDToConnectorVersionID(j2eeVer);
            this.jcaModel.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", jcaVersion);
        }
        if (this.clientModel != null) {
            this.clientModel.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        }
    }

    private void setNestedComponentName(int flag, String compName) {
        IDataModel model = this.getNestedModel(flag);
        if (model != null) {
            model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)compName);
        }
    }

    private IStatus validateNestedProjectName(int flag) {
        IDataModel model = this.getNestedModel(flag);
        if (model != null) {
            String createProperty = null;
            switch (flag) {
                case 0: {
                    createProperty = "DefaultJ2EEComponentCreationDataModel.CREATE_EJB";
                    break;
                }
                case 1: {
                    createProperty = "DefaultJ2EEComponentCreationDataModel.CREATE_WEB";
                    break;
                }
                case 3: {
                    createProperty = "DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT";
                    break;
                }
                case 2: {
                    createProperty = "DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR";
                }
            }
            if (createProperty != null && this.getBooleanProperty(createProperty)) {
                return model.validateProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
            }
        }
        return J2EEPlugin.OK_STATUS;
    }

    private IDataModel getNestedModel(int flag) {
        switch (flag) {
            case 0: {
                return this.ejbModel;
            }
            case 1: {
                return this.webModel;
            }
            case 2: {
                return this.jcaModel;
            }
            case 3: {
                return this.clientModel;
            }
        }
        return null;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR") || propertyName.equals("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME")) {
            boolean result;
            int version = this.getIntProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION");
            boolean bl = result = version > 12;
            if (result) {
                return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR");
            }
            return result;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB");
        }
        return super.isPropertyEnabled(propertyName);
    }
}

