/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistry;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.internal.emf.utilities.CommandContext;
import org.eclipse.wst.common.internal.emf.utilities.ICommand;
import org.eclipse.wst.common.internal.emf.utilities.ICommandContext;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class J2EEDeployOperation
extends WTPOperation {
    private Object[] selection;
    private List multiStatus = new ArrayList();

    public J2EEDeployOperation(Object[] deployableObjects) {
        this.selection = deployableObjects;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        DeployerRegistry reg = DeployerRegistry.instance();
        List modules = DeployerRegistry.getSelectedModules(this.selection);
        monitor.beginTask(J2EEPluginResourceHandler.getString("J2EEDeployOperation_UI_0"), modules.size());
        int i = 0;
        while (i < modules.size()) {
            EObject module = (EObject)modules.get(i);
            IProject proj = ProjectUtilities.getProject((EObject)module);
            IRuntime runtime = ServerCore.getProjectProperties((IProject)proj).getRuntimeTarget();
            if (runtime != null) {
                List visitors = reg.getDeployModuleExtensions(module, runtime);
                this.deploy(visitors, module, monitor);
                monitor.worked(1);
            }
            ++i;
        }
    }

    private void deploy(List visitors, EObject module, IProgressMonitor monitor) {
        IProject proj = ProjectUtilities.getProject((EObject)module);
        IStatus main = this.addMainStatus(proj);
        int i = 0;
        while (i < visitors.size()) {
            if (visitors.get(i) instanceof ICommand) {
                ICommand dep = (ICommand)visitors.get(i);
                CommandContext ctx = new CommandContext(monitor, null, module.eResource().getResourceSet());
                dep.init(this.selection);
                monitor.setTaskName(J2EEPluginResourceHandler.getString("J2EEDeployOperation_1_UI_", new Object[]{proj.getName(), dep.getClass().getName()}));
                try {
                    dep.execute((IResource)proj, null, (ICommandContext)ctx);
                    this.addOKStatus(dep.getClass().getName(), main);
                }
                catch (CoreException ex) {
                    Logger.getLogger().logError((Throwable)ex);
                    monitor.setCanceled(true);
                    CoreException statusException = ex.getStatus().getException() != null ? ex.getStatus().getException() : ex;
                    this.addErrorStatus(ex.getStatus(), dep.getClass().getName(), statusException, main);
                }
            }
            ++i;
        }
    }

    private void addOKStatus(String DeployerName, IStatus main) {
        Status statusLocal = new Status(0, " ", 0, J2EEPluginResourceHandler.getString("J2EEDeployOperation_2_UI_", new Object[]{DeployerName}), null);
        this.addStatus((IStatus)statusLocal);
    }

    private void addErrorStatus(IStatus exceptionStatus, String DeployerName, Throwable ex, IStatus main) {
        if (exceptionStatus instanceof MultiStatus) {
            IStatus[] stati = ((MultiStatus)exceptionStatus).getChildren();
            int i = 0;
            while (1 < stati.length) {
                this.addErrorStatus(stati[i], DeployerName, stati[i].getException(), main);
                ++i;
            }
        }
        String errorNotes = ex != null && ex.getMessage() != null ? ex.getMessage() : main.getMessage();
        String message = J2EEPluginResourceHandler.getString("J2EEDeployOperation_3_UI_", new Object[]{DeployerName, errorNotes});
        Status statusLocal = new Status(4, J2EEPlugin.getPlugin().getPluginID(), 4, message, ex);
        this.addStatus((IStatus)statusLocal);
    }

    private IStatus addMainStatus(IProject proj) {
        MultiStatus aStatus = new MultiStatus(J2EEPlugin.getPlugin().getPluginID(), 0, J2EEPluginResourceHandler.getString("J2EEDeployOperation_4_UI_", new Object[]{proj.getName()}), null);
        this.getMultiStatus().add(aStatus);
        return aStatus;
    }

    public List getMultiStatus() {
        return this.multiStatus;
    }

    public void setMultiStatus(List multiStatus) {
        this.multiStatus = multiStatus;
    }
}

