/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.delete;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.delete.ClasspathDeleteInfo;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;

public class DeleteModuleDependencyOperation
extends WTPOperation {
    protected List earNatures;
    protected Set projects;
    protected Map deleteInfos;
    protected IProgressMonitor monitor;
    protected static String MOD_DEP_DELETE_ERRORS = J2EECreationResourceHandler.getString("Errors_occurred_deleting_module_dependencies_UI_");
    protected List affectedFiles = null;

    public DeleteModuleDependencyOperation(List earNatures, Set projects) {
        this.earNatures = earNatures;
        this.projects = projects;
    }

    protected Map getDeleteInfos() {
        if (this.deleteInfos == null) {
            this.deleteInfos = new HashMap();
        }
        return this.deleteInfos;
    }

    protected ClasspathDeleteInfo getDeleteInfo(IProject referencingProject) {
        ClasspathDeleteInfo info = (ClasspathDeleteInfo)this.getDeleteInfos().get(referencingProject);
        if (info != null) {
            return info;
        }
        info = new ClasspathDeleteInfo(referencingProject);
        this.deleteInfos.put(referencingProject, info);
        return info;
    }

    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = aMonitor;
        this.gatherDeleteInfoIfNecessary();
        this.executeDeleteInfo();
    }

    protected void gatherDeleteInfoIfNecessary() {
        if (this.deleteInfos == null || this.deleteInfos.isEmpty()) {
            int i = 0;
            while (i < this.earNatures.size()) {
                EARNatureRuntime nature = (EARNatureRuntime)((Object)this.earNatures.get(i));
                this.gatherDeleteInfo(nature);
                ++i;
            }
        }
    }

    protected void gatherDeleteInfo(EARNatureRuntime runtime) {
        Map urisToProjects = runtime.getAllMappedProjects();
        Iterator iterator = this.projects.iterator();
        while (iterator.hasNext()) {
            IProject project = (IProject)iterator.next();
            this.gatherDeleteInfo(runtime, urisToProjects, project);
        }
    }

    protected void gatherDeleteInfo(EARNatureRuntime runtime, Map urisToProjects, IProject referencedProject) {
        String referencedProjectURI = runtime.getJARUri(referencedProject);
        if (referencedProjectURI == null) {
            return;
        }
        Iterator it = urisToProjects.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String uri = (String)entry.getKey();
            IProject project = (IProject)entry.getValue();
            if (referencedProject.equals((Object)project) || this.projects.contains(project)) continue;
            this.gatherDeleteInfo(uri, project, referencedProject, referencedProjectURI);
        }
    }

    protected void gatherDeleteInfo(String testUri, IProject testProject, IProject referencedProject, String moduleUri) {
        ArchiveManifest mf = J2EEProjectUtilities.readManifest(testProject);
        if (mf == null) {
            return;
        }
        String[] classpath = mf.getClassPathTokenized();
        int i = 0;
        while (i < classpath.length) {
            String resolved = ArchiveUtil.deriveEARRelativeURI((String)classpath[i], (String)testUri);
            if (moduleUri.equals(resolved)) {
                ClasspathDeleteInfo info = this.getDeleteInfo(testProject);
                info.getManifestEntries().add(classpath[i]);
                info.getReferencedProjects().add(referencedProject);
            }
            ++i;
        }
    }

    protected void executeDeleteInfo() throws InvocationTargetException {
        if (this.deleteInfos == null) {
            return;
        }
        Iterator it = this.deleteInfos.values().iterator();
        while (it.hasNext()) {
            ClasspathDeleteInfo info = (ClasspathDeleteInfo)it.next();
            IProject p = info.getTargetProject();
            if (JemProjectUtilities.isBinaryProject((IProject)p)) {
                String message = J2EECreationResourceHandler.getString("Can_not_remove_module_dependency_from_project_UI_", new Object[]{p.getName()});
                this.addErrorStatus(message);
                continue;
            }
            try {
                this.replaceManifest(p, info);
                this.replaceBuildPath(p, info);
            }
            catch (Exception ex) {
                throw new WFTWrappedException((Throwable)ex);
            }
        }
    }

    protected void replaceManifest(IProject project, ClasspathDeleteInfo info) throws IOException {
        ArchiveManifest mf = J2EEProjectUtilities.readManifest(project);
        if (mf == null) {
            return;
        }
        String[] entries = mf.getClassPathTokenized();
        StringBuffer sb = new StringBuffer();
        boolean empty = true;
        int i = 0;
        while (i < entries.length) {
            String entry = entries[i];
            if (!info.getManifestEntries().contains(entry)) {
                if (!empty) {
                    sb.append(" ");
                }
                empty = false;
                sb.append(entries[i]);
            }
            ++i;
        }
        mf.setClassPath(sb.toString());
        J2EEProjectUtilities.writeManifest(project, mf);
    }

    protected void replaceBuildPath(IProject project, ClasspathDeleteInfo info) throws JavaModelException {
        IJavaProject javaP = JemProjectUtilities.getJavaProject((IProject)project);
        if (javaP == null) {
            return;
        }
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] entries = javaP.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (this.shouldKeepEntry(entry, info)) {
                result.add(entry);
            }
            ++i;
        }
        IClasspathEntry[] toArray = result.toArray(new IClasspathEntry[result.size()]);
        javaP.setRawClasspath(toArray, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
    }

    protected boolean shouldKeepEntry(IClasspathEntry entry, ClasspathDeleteInfo info) {
        if (entry.getEntryKind() != 2) {
            return true;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString());
        return !info.getReferencedProjects().contains(project);
    }

    protected List getAffectedFiles() {
        if (this.affectedFiles == null) {
            this.affectedFiles = this.gatherAffectedFiles();
        }
        return this.affectedFiles;
    }

    protected List gatherAffectedFiles() {
        this.gatherDeleteInfoIfNecessary();
        if (this.deleteInfos == null || this.deleteInfos.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        Iterator it = this.deleteInfos.values().iterator();
        while (it.hasNext()) {
            ClasspathDeleteInfo info = (ClasspathDeleteInfo)it.next();
            IProject p = info.getTargetProject();
            IFile aFile = J2EEProjectUtilities.getManifestFile(p);
            if (aFile == null || !aFile.exists()) continue;
            result.add(aFile);
            result.addAll(ProjectUtilities.getFilesAffectedByClasspathChange((IProject)p));
        }
        return result;
    }

    protected void addErrorStatus(String message) {
        IStatus newStatus = J2EEPlugin.newErrorStatus(message, null);
        this.addStatus(newStatus);
    }
}

