/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.common.CommonEditResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEComponentUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

public class ClasspathModel
implements ResourceStateInputProvider,
ResourceStateValidator {
    protected IProject project;
    protected IVirtualComponent selectedEARComponent;
    protected EARFile earFile;
    protected IVirtualComponent component;
    protected Archive archive;
    public EARArtifactEdit earArtifactEdit;
    protected IVirtualComponent[] availableEARComponents = null;
    protected ClassPathSelection classPathSelection;
    protected List listeners;
    protected List nonResourceFiles;
    protected ResourceStateValidator stateValidator;
    protected ArchiveManifest manifest;
    public static String NO_EAR_MESSAGE = CommonEditResourceHandler.getString("NO_EAR_JARDEP_FOR_MOD_UI_");
    protected List targetWLPRefComponentList;
    protected boolean isWLPModel = false;
    protected ClassPathSelection classPathWLPSelection;
    protected Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            IVirtualComponent e1 = (IVirtualComponent)o1;
            IVirtualComponent e2 = (IVirtualComponent)o2;
            return e1.getProject().getName().compareTo(e2.getProject().getName());
        }
    };

    public ClasspathModel(ArchiveManifest initialManifest) {
        this.manifest = initialManifest;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.initializeComponent();
        this.getAvailableEARComponents();
    }

    private void initializeComponent() {
        IFlexibleProject flexProject = ComponentCore.createFlexibleProject((IProject)this.getProject());
        this.setComponent(flexProject.getComponents()[0]);
    }

    protected IVirtualComponent[] refreshAvailableEARs() {
        this.availableEARComponents = J2EEComponentUtilities.getReferencingEARComponents(this.getComponent());
        if (this.availableEARComponents != null && this.availableEARComponents.length > 0) {
            Arrays.sort(this.availableEARComponents, this.comparator);
            if (this.selectedEARComponent == null || !Arrays.asList(this.availableEARComponents).contains(this.selectedEARComponent)) {
                this.selectedEARComponent = this.availableEARComponents.length > 0 ? this.availableEARComponents[0] : null;
            }
        }
        return this.availableEARComponents;
    }

    public IVirtualComponent[] getAvailableEARComponents() {
        if (this.availableEARComponents == null) {
            this.refreshAvailableEARs();
        }
        return this.availableEARComponents;
    }

    public IVirtualComponent getSelectedEARComponent() {
        return this.selectedEARComponent;
    }

    public String getArchiveURI() {
        if (this.selectedEARComponent != null) {
            return this.getEARArtifactEdit().getModuleURI(this.getComponent());
        }
        return null;
    }

    public EARArtifactEdit getEARArtifactEdit() {
        if (this.earArtifactEdit == null || this.selectedEARComponentChanged()) {
            this.earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead(this.selectedEARComponent);
        }
        return this.earArtifactEdit;
    }

    private boolean selectedEARComponentChanged() {
        if (this.earArtifactEdit != null && !this.earArtifactEdit.getComponent().getName().equals(this.selectedEARComponent.getName())) {
            this.earArtifactEdit.dispose();
            this.earArtifactEdit = null;
            return true;
        }
        return false;
    }

    protected void initializeEARFile() {
        if (this.selectedEARComponent == null || !this.isDDInEAR(this.selectedEARComponent)) {
            this.earFile = null;
            return;
        }
        try {
            this.earFile = (EARFile)this.getEARArtifactEdit().asArchive(false);
        }
        catch (OpenFailureException ex) {
            this.handleOpenFailureException(ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeSelection(ArchiveManifest existing) {
        block14: {
            try {
                this.initializeEARFile();
                this.initializeArchive();
                if (this.archive != null) {
                    if (existing == null) {
                        if (this.manifest != null) {
                            this.archive.setManifest(this.manifest);
                        } else {
                            this.archive.getManifest();
                        }
                    } else {
                        this.archive.setManifest(existing);
                    }
                    List archiveFiles = this.earFile.getArchiveFiles();
                    int i = 0;
                    while (i < archiveFiles.size()) {
                        Archive anArchive = (Archive)archiveFiles.get(i);
                        try {
                            if (anArchive.isEJBJarFile()) {
                                ((EJBJarFile)anArchive).getDeploymentDescriptor();
                            }
                            anArchive.getManifest();
                        }
                        catch (ManifestException mfEx) {
                            Logger.getLogger().logError((Throwable)mfEx);
                            anArchive.setManifest((ArchiveManifest)new ArchiveManifestImpl());
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.earFile != null) {
                    this.earFile.close();
                }
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (this.earFile == null) break block14;
            }
            this.earFile.close();
        }
        this.createClassPathSelection();
    }

    protected void initializeArchive() {
        if (this.earFile == null) {
            this.archive = null;
            return;
        }
        String uri = this.getArchiveURI();
        if (uri != null) {
            try {
                this.archive = (Archive)this.earFile.getFile(uri);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.archive = null;
            }
        }
    }

    protected void createClassPathSelection() {
        this.classPathSelection = this.archive != null ? new ClassPathSelection(this.archive, this.earFile) : null;
    }

    protected boolean isDDInEAR(IVirtualComponent component) {
        IProject mofRoot = component.getProject();
        if (mofRoot == null || !mofRoot.exists()) {
            return false;
        }
        return mofRoot.exists((IPath)new Path(String.valueOf(component.getRootFolder().getProjectRelativePath().toString()) + "//" + "META-INF/application.xml"));
    }

    protected void handleOpenFailureException(OpenFailureException ex) {
        Logger.getLogger().logError((Throwable)ex);
    }

    public void dispose() {
        if (this.earArtifactEdit != null) {
            this.earArtifactEdit.dispose();
            this.earArtifactEdit = null;
        }
    }

    public ClassPathSelection getClassPathSelection() {
        if (this.classPathSelection == null) {
            this.initializeSelection(null);
        }
        return this.classPathSelection;
    }

    public void resetClassPathSelection(ArchiveManifest mf) {
        this.initializeSelection(mf);
        this.fireNotification(new ClasspathModelEvent(4));
    }

    public void resetClassPathSelection() {
        this.resetClassPathSelection(null);
    }

    public void addListener(ClasspathModelListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ClasspathModelListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void fireNotification(ClasspathModelEvent evt) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ClasspathModelListener listener = (ClasspathModelListener)this.listeners.get(i);
            listener.modelChanged(evt);
            ++i;
        }
    }

    public void setSelection(ClasspathElement element, boolean selected) {
        element.setSelected(selected);
        if (!this.isWLPModel()) {
            this.updateManifestClasspath();
        }
    }

    public void setAllClasspathElementsSelected(boolean selected) {
        ClassPathSelection s = this.getClassPathSelection();
        if (s != null) {
            s.setAllSelected(selected);
            this.updateManifestClasspath();
        }
    }

    public void setAllClasspathElementsSelected(List elements, boolean selected) {
        ClassPathSelection s = this.getClassPathSelection();
        if (s != null) {
            s.setAllSelected(elements, selected);
            this.updateManifestClasspath();
        }
    }

    public Archive getArchive() {
        return this.archive;
    }

    public void updateManifestClasspath() {
        if (this.classPathSelection != null && this.classPathSelection.isModified()) {
            this.archive.getManifest().setClassPath(this.classPathSelection.toString());
            this.fireNotification(new ClasspathModelEvent(1));
        }
    }

    public void updateMainClass(String mainClass) {
        this.archive.getManifest().setMainClass(mainClass);
        this.fireNotification(new ClasspathModelEvent(5));
    }

    public void fireSavedEvent() {
        this.fireNotification(new ClasspathModelEvent(6));
    }

    public void primSetManifest(ArchiveManifest mf) {
        this.manifest = mf;
    }

    public void setManifest(ArchiveManifest manifest) {
        this.archive.setManifest(manifest);
        this.getClassPathSelection();
        this.fireNotification(new ClasspathModelEvent(3));
    }

    public void selectEAR(int index) {
        ArchiveManifestImpl mf = new ArchiveManifestImpl((Manifest)((ArchiveManifestImpl)this.getArchive().getManifest()));
        this.earFile.close();
        this.selectedEARComponent = this.availableEARComponents[index];
        this.initializeSelection((ArchiveManifest)mf);
        this.fireNotification(new ClasspathModelEvent(2));
    }

    public void moveUp(List toMoveUp) {
        this.getClassPathSelection().moveUp(toMoveUp);
        this.updateManifestClasspath();
    }

    public void moveDown(List toMoveDown) {
        this.getClassPathSelection().moveDown(toMoveDown);
        this.updateManifestClasspath();
    }

    public void refresh() {
        ArchiveManifestImpl mf = null;
        if (this.archive != null) {
            mf = new ArchiveManifestImpl((Manifest)((ArchiveManifestImpl)this.getArchive().getManifest()));
        }
        this.refreshAvailableEARs();
        this.resetClassPathSelection((ArchiveManifest)mf);
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public List getNonResourceFiles() {
        if (this.nonResourceFiles == null) {
            this.initNonResourceFiles();
        }
        return this.nonResourceFiles;
    }

    protected void initNonResourceFiles() {
        if (this.getComponent() == null) {
            return;
        }
        this.nonResourceFiles = new ArrayList(3);
        this.nonResourceFiles.add(this.getComponent().getProject().getFile(".project"));
        this.nonResourceFiles.add(this.getComponent().getProject().getFile(".classpath"));
        IFile mf = J2EEProjectUtilities.getManifestFile(this.getComponent().getProject());
        if (mf != null) {
            this.nonResourceFiles.add(mf);
        }
    }

    public List getNonResourceInconsistentFiles() {
        return null;
    }

    public boolean isDirty() {
        ClassPathSelection selection = this.getClassPathSelection();
        if (selection == null) {
            return false;
        }
        return selection.isModified();
    }

    public Set getAffectedFiles() {
        HashSet<IFile> result = new HashSet<IFile>();
        IFile aFile = J2EEProjectUtilities.getManifestFile(this.getComponent().getProject());
        if (aFile != null && aFile.exists()) {
            result.add(aFile);
        }
        result.addAll(ProjectUtilities.getFilesAffectedByClasspathChange((IProject)this.getComponent().getProject()));
        return result;
    }

    public List getResources() {
        return Collections.EMPTY_LIST;
    }

    public boolean selectDependencyIfNecessary(IProject referencedProject) {
        this.getClassPathSelection();
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(referencedProject)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public boolean selectDependencyIfNecessary(String jarName) {
        this.getClassPathSelection();
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(jarName)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public void removeDependency(String jarName) {
        this.getClassPathSelection();
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }

    public void removeDependency(IProject referencedProject) {
        this.getClassPathSelection();
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }

    public void selectFilterLevel(int filterLevel) {
        this.getClassPathSelection();
        if (this.classPathSelection != null) {
            this.classPathSelection.selectFilterLevel(filterLevel);
        }
        this.updateManifestClasspath();
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().validateState(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public void setComponent(IVirtualComponent component) {
        this.component = component;
    }

    public ClassPathSelection getClassPathSelectionForWLPs() {
        if (this.classPathWLPSelection == null) {
            this.initializeSelectionForWLPs();
        }
        return this.classPathWLPSelection;
    }

    private void initializeSelectionForWLPs() {
        this.classPathWLPSelection = new ClassPathSelection();
        try {
            IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)this.component.getProject());
            IClasspathEntry[] entry = javaProject.getRawClasspath();
            List allValidUtilityProjects = ComponentUtilities.getAllJavaNonFlexProjects();
            allValidUtilityProjects.addAll(Arrays.asList(ComponentUtilities.getAllComponentsInWorkspaceOfType((String)"jst.utility")));
            int i = 0;
            while (i < allValidUtilityProjects.size()) {
                IProject utilProject = null;
                if (allValidUtilityProjects.get(i) instanceof IProject) {
                    utilProject = (IProject)allValidUtilityProjects.get(i);
                } else if (allValidUtilityProjects.get(i) instanceof IVirtualComponent) {
                    utilProject = ((IVirtualComponent)allValidUtilityProjects.get(i)).getProject();
                }
                boolean existingEntry = false;
                int j = 0;
                while (j < entry.length) {
                    IClasspathEntry eachEntry = entry[j];
                    if (eachEntry.getEntryKind() == 2 && eachEntry.getPath().toString().equals("/" + utilProject.getName())) {
                        existingEntry = true;
                        break;
                    }
                    ++j;
                }
                this.classPathWLPSelection.createProjectElement(utilProject, existingEntry);
                this.classPathWLPSelection.setFilterLevel(2);
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean isWLPModel() {
        return this.isWLPModel;
    }

    public void setWLPModel(boolean isWLPModel) {
        this.isWLPModel = isWLPModel;
    }
}

