/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverterImpl;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IJ2EEImportExportConstants;
import org.eclipse.jst.j2ee.internal.common.impl.J2EEResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class J2EELoadStrategyImpl
extends LoadStrategyImpl
implements IJ2EEImportExportConstants {
    protected IProject project;
    protected ArrayList filesList;
    protected WorkbenchURIConverter projectMetaURIConverter;
    protected WorkbenchURIConverter projectURIConverter;
    protected Set visitedURIs;
    private boolean exportSource = false;
    private boolean includeProjectMetaFiles = false;
    protected List sourceFolders;

    public boolean contains(String uri) {
        if (this.projectURIConverter == null) {
            this.getProjectURIConverter();
        }
        return this.projectURIConverter.getFile(uri).exists();
    }

    protected boolean primContains(String uri) {
        return false;
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    public List getFiles() {
        this.filesList.clear();
        try {
            List<IResource> projMembers = Arrays.asList(this.project.members());
            ArrayList<IResource> exopProjMembers = new ArrayList<IResource>();
            Iterator<IResource> iterator = projMembers.iterator();
            while (iterator.hasNext()) {
                exopProjMembers.add(iterator.next());
            }
            this.filesList = this.getFiles(exopProjMembers);
        }
        catch (Exception exc) {
            throw new ArchiveRuntimeException(EJBArchiveOpsResourceHandler.getString("ARCHIVE_OPERATION_FilesFromProject"), exc);
        }
        return this.filesList;
    }

    protected ArrayList getFiles(List projectResources) throws Exception {
        if (projectResources.isEmpty()) {
            return this.filesList;
        }
        IContainer outputFolder = JemProjectUtilities.getJavaProjectOutputContainer((IProject)this.getProject());
        Iterator iterator = projectResources.iterator();
        while (iterator.hasNext()) {
            File cFile = null;
            IResource res = (IResource)iterator.next();
            if (res.getType() == 1) {
                String uri;
                IPath path = this.getOutputPathForFile(res.getProjectRelativePath());
                String string = uri = path == null ? null : path.toString();
                if (outputFolder != null && !outputFolder.exists(path) && uri != null && !this.isSource(uri) && !uri.equals(".project") && !uri.equals(".classpath") || uri == null || !this.shouldInclude(uri) || this.getVisitedURIs().contains(uri)) continue;
                cFile = this.createFile(uri);
                cFile.setLastModified(this.getLastModified(res));
                this.getVisitedURIs().add(uri);
                this.filesList.add(cFile);
                continue;
            }
            if (!this.shouldInclude((IContainer)res)) continue;
            this.getFiles(Arrays.asList(((IContainer)res).members()));
        }
        return this.filesList;
    }

    protected boolean isSource(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.endsWith(".java") || uri.endsWith(".sqlj");
    }

    protected boolean shouldInclude(IContainer iContainer) {
        return true;
    }

    protected boolean shouldInclude(String uri) {
        return this.isExportSource() || !this.isSource(uri);
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        try {
            if (this.projectURIConverter == null) {
                this.getProjectURIConverter();
            }
            if (this.isProjectMetaFile(uri)) {
                return this.getProjectMetaURIConverter().createInputStream(URI.createURI((String)uri));
            }
            return this.projectURIConverter.createInputStream(URI.createURI((String)uri));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ArchiveRuntimeException(e);
        }
    }

    protected boolean isProjectMetaFile(String uri) {
        return ".project".equals(uri) || ".classpath".equals(uri);
    }

    public abstract IContainer getModuleContainer();

    protected IPath getOutputPathForFile(IPath aPath) throws Exception {
        IPath tempPath;
        if (this.isProjectMetaFile(aPath.toString())) {
            if (this.includeProjectMetaFiles) {
                return aPath;
            }
            return null;
        }
        IContainer moduleContainer = this.getModuleContainer();
        IPath moduleContainerPath = moduleContainer.getProjectRelativePath();
        if (aPath.segmentCount() > moduleContainerPath.segmentCount() && aPath.removeLastSegments(aPath.segmentCount() - moduleContainerPath.segmentCount()).equals((Object)moduleContainerPath) && moduleContainer.exists(tempPath = aPath.removeFirstSegments(moduleContainerPath.segmentCount()))) {
            return tempPath;
        }
        List lSourceFolders = this.getSourceFolders();
        int i = 0;
        while (i < lSourceFolders.size()) {
            IPath folderPath = ((IFolder)lSourceFolders.get(i)).getProjectRelativePath();
            if (aPath.segmentCount() > folderPath.segmentCount() && aPath.removeLastSegments(aPath.segmentCount() - folderPath.segmentCount()).equals((Object)folderPath)) {
                return aPath.removeFirstSegments(folderPath.segmentCount());
            }
            ++i;
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public abstract WorkbenchURIConverter getProjectURIConverter();

    public String getSourceFolderName() throws Exception {
        try {
            return JemProjectUtilities.getSourceFolderOrFirst((IProject)this.project, null).getName();
        }
        catch (Exception e) {
            throw new SaveFailureException(EJBArchiveOpsResourceHandler.getString("ARCHIVE_OPERATION_ProjectNature"), e);
        }
    }

    public List getSourceFoldersNames() throws Exception {
        try {
            ArrayList<String> sourceFolderNames = new ArrayList<String>();
            List localSourceFolders = this.getSourceFolders();
            int i = 0;
            while (i < localSourceFolders.size()) {
                sourceFolderNames.add(((IFolder)localSourceFolders.get(i)).getName());
                ++i;
            }
            return sourceFolderNames;
        }
        catch (Exception e) {
            throw new SaveFailureException(EJBArchiveOpsResourceHandler.getString("ARCHIVE_OPERATION_ProjectNature"), e);
        }
    }

    protected List getSourceFolders() {
        if (this.sourceFolders == null) {
            this.sourceFolders = JemProjectUtilities.getSourceContainers((IProject)this.project);
        }
        return this.sourceFolders;
    }

    public Set getVisitedURIs() {
        if (this.visitedURIs == null) {
            this.visitedURIs = new HashSet();
        }
        return this.visitedURIs;
    }

    public boolean isClassLoaderNeeded() {
        return false;
    }

    public boolean isExportSource() {
        return this.exportSource;
    }

    public void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    public boolean shouldIncludeProjectMetaFiles() {
        return this.includeProjectMetaFiles;
    }

    public void setIncludeProjectMetaFiles(boolean includeProjectMetaFiles) {
        this.includeProjectMetaFiles = includeProjectMetaFiles;
    }

    protected URIConverter getProjectMetaURIConverter() {
        if (this.projectMetaURIConverter == null) {
            this.projectMetaURIConverter = new WorkbenchURIConverterImpl((IContainer)this.getProject());
        }
        return this.projectMetaURIConverter;
    }

    public boolean requiresIterationOnSave() {
        return true;
    }

    protected void initializeResourceSet() {
        this.resourceSet = WorkbenchResourceHelper.getResourceSet((IProject)this.project);
    }

    protected Resource.Factory.Registry createResourceFactoryRegistry() {
        return new J2EEResourceFactoryRegistry();
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.project.getLocation().toOSString();
    }
}

