/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModel;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;

public class UpdateManifestOperation
extends WTPOperation {
    public UpdateManifestOperation(UpdateManifestDataModel dataModel) {
        super((WTPOperationDataModel)dataModel);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        UpdateManifestDataModel dataModel = (UpdateManifestDataModel)this.operationDataModel;
        IFile file = (IFile)dataModel.getProperty("UpdateManifestDataModel.MANIFEST_FILE");
        String classPathValue = dataModel.getClasspathAsString();
        try {
            ArchiveManifest mf = J2EEProjectUtilities.readManifest(file);
            if (mf == null) {
                mf = new ArchiveManifestImpl();
            }
            mf.addVersionIfNecessary();
            if (dataModel.getBooleanProperty("UpdateManifestDataModel.MERGE")) {
                mf.mergeClassPath(ArchiveUtil.getTokens((String)classPathValue));
            } else {
                mf.setClassPath(classPathValue);
            }
            if (dataModel.isSet("UpdateManifestDataModel.MAIN_CLASS")) {
                mf.setMainClass(dataModel.getStringProperty("UpdateManifestDataModel.MAIN_CLASS"));
            }
            J2EEProjectUtilities.writeManifest(file, mf);
        }
        catch (IOException ex) {
            throw new WFTWrappedException((Throwable)ex);
        }
    }
}

