/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModelEvent;

public class UpdateManifestDataModel
extends WTPOperationDataModel {
    public static final String PROJECT_NAME = "UpdateManifestDataModel.PROJECT_NAME";
    public static final String JAR_LIST = "UpdateManifestDataModel.CLASSPATH_LIST";
    public static final String JAR_LIST_TEXT_UI = "UpdateManifestDataModel.CLASSPATH_LIST_TEXT_UI";
    public static final String MERGE = "UpdateManifestDataModel.MERGE";
    public static final String MAIN_CLASS = "UpdateManifestDataModel.MAIN_CLASS";
    public static final String MANIFEST_FILE = "UpdateManifestDataModel.MANIFEST_FILE";

    public WTPOperation getDefaultOperation() {
        return new UpdateManifestOperation(this);
    }

    protected void init() {
        super.init();
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(PROJECT_NAME);
        this.addValidBaseProperty(JAR_LIST);
        this.addValidBaseProperty(JAR_LIST_TEXT_UI);
        this.addValidBaseProperty(MERGE);
        this.addValidBaseProperty(MAIN_CLASS);
        this.addValidBaseProperty(MANIFEST_FILE);
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(MERGE)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(JAR_LIST)) {
            return new ArrayList();
        }
        if (propertyName.equals(JAR_LIST_TEXT_UI)) {
            return this.getClasspathAsString();
        }
        return super.getDefaultProperty(propertyName);
    }

    public void propertyChanged(WTPOperationDataModelEvent event) {
        super.propertyChanged(event);
        if (event.getPropertyName().equals(JAR_LIST)) {
            this.getClasspathAsString();
            this.propertyChanged(new WTPOperationDataModelEvent((WTPOperationDataModel)this, JAR_LIST_TEXT_UI, event.getFlag()));
        }
    }

    public IProject getProject() {
        String projectName = (String)this.getProperty(PROJECT_NAME);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public String getClasspathAsString() {
        List classpathList = (List)this.getProperty(JAR_LIST);
        return UpdateManifestDataModel.convertClasspathListToString(classpathList);
    }

    public static String convertClasspathListToString(List list) {
        String classpathString = "";
        int i = 0;
        while (i < list.size()) {
            classpathString = String.valueOf(classpathString) + (String)list.get(i) + " ";
            ++i;
        }
        return classpathString.trim();
    }

    public static List convertClasspathStringToList(String string) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, " ");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }
}

