/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.application.internal.operations.IAnnotationsDataModel;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.UpdateProjectClasspath;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.operation.ComponentCreationOperation;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.FlexibleJavaProjectPreferenceUtil;

public abstract class J2EEComponentCreationOperation
extends ComponentCreationOperation
implements IJ2EEComponentCreationDataModelProperties,
IAnnotationsDataModel {
    protected static final String TEMPLATE_EMITTER = "org.eclipse.jst.j2ee.ejb.annotations.emitter.template";
    protected static final String BUILDER_ID = "builderId";

    public J2EEComponentCreationOperation(IDataModel model) {
        super(model);
    }

    protected void execute(String componentType, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        super.execute(componentType, monitor, null);
        if (this.model.getBooleanProperty("IComponentCreationDataModelProperties.CREATE_DEFAULT_FILES")) {
            this.createDeploymentDescriptor(monitor);
            this.createManifest(monitor);
        }
        this.addSrcFolderToProject();
        if (this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations")) {
            this.addAnnotationsBuilder();
        }
        this.linkToEARIfNecessary(monitor);
    }

    protected abstract void createDeploymentDescriptor(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

    public void linkToEARIfNecessary(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.model.getBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR")) {
            this.createEARComponentIfNecessary(monitor);
            this.runAddToEAROperation(monitor);
        }
    }

    protected void runAddToEAROperation(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getProject(), (String)this.getModuleDeployName());
        IDataModel dm = (IDataModel)this.model.getProperty("IComponentCreationDataModelProperties.NESTED_ADD_COMPONENT_TO_EAR_DM");
        ComponentHandle earhandle = (ComponentHandle)this.model.getProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_HANDLE");
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE", (Object)earhandle);
        List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        modList.add(component.getComponentHandle());
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST", (Object)modList);
        try {
            dm.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    protected void createEARComponentIfNecessary(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IDataModel earModel = (IDataModel)this.model.getProperty("IComponentCreationDataModelProperties.NESTED_EAR_COMPONENT_CREATION_DM");
        ComponentHandle handle = (ComponentHandle)this.model.getProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_HANDLE");
        earModel.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)handle.getName());
        earModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)handle.getProject().getName());
        try {
            earModel.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Object)e.getMessage());
        }
    }

    public String getModuleName() {
        return (String)this.model.getProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
    }

    public String getModuleDeployName() {
        return (String)this.model.getProperty("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME");
    }

    protected abstract String getVersion();

    protected void setupComponentType(String typeID) {
        Property javaOutputProp;
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getProject(), (String)this.getModuleDeployName());
        ComponentType componentType = ComponentcoreFactory.eINSTANCE.createComponentType();
        componentType.setComponentTypeId(typeID);
        componentType.setVersion(this.getVersion());
        List newProps = this.getProperties();
        EList existingProps = componentType.getProperties();
        if (newProps != null && !newProps.isEmpty()) {
            int i = 0;
            while (i < newProps.size()) {
                existingProps.add(newProps.get(i));
                ++i;
            }
        }
        if ((javaOutputProp = this.getOutputProperty()) != null) {
            existingProps.add((Object)javaOutputProp);
        }
        StructureEdit.setComponentType((IVirtualComponent)component, (ComponentType)componentType);
    }

    protected List getProperties() {
        return null;
    }

    protected void createManifest(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String manifestFolder = this.model.getStringProperty("IJavaComponentCreationDataModelProperties.MANIFEST_FOLDER");
        IFolder container = this.getProject().getFolder(manifestFolder);
        IFile file = container.getFile((IPath)new Path("MANIFEST.MF"));
        try {
            ManifestFileCreationAction.createManifestFile(file, this.getProject());
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    protected final void addAnnotationsBuilder() {
        AnnotationsControllerManager.Descriptor descriptor = AnnotationsControllerManager.INSTANCE.getDescriptor(ProjectUtilities.getProject((String)this.model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME")));
        if (descriptor != null) {
            return;
        }
        try {
            IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATE_EMITTER);
            String builderID = String.valueOf(configurationElements[0].getNamespace()) + "." + configurationElements[0].getAttribute(BUILDER_ID);
            IProject project = ProjectUtilities.getProject((Object)this.model.getProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
            if (project != null && project.isAccessible()) {
                IProjectDescription description = project.getDescription();
                ICommand[] commands = description.getBuildSpec();
                boolean found = false;
                int i = 0;
                while (i < commands.length) {
                    if (commands[i].getBuilderName().equals(builderID)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    ICommand command = description.newCommand();
                    command.setBuilderName(builderID);
                    ICommand[] newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 0, commands.length);
                    newCommands[commands.length] = command;
                    IProjectDescription desc = project.getDescription();
                    desc.setBuildSpec(newCommands);
                    project.setDescription(desc, null);
                }
            }
        }
        catch (Exception exception) {}
    }

    private void addSrcFolderToProject() {
        new UpdateProjectClasspath(this.model.getStringProperty("IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER"), this.model.getStringProperty("IComponentCreationDataModelProperties.COMPONENT_NAME"), ProjectUtilities.getProject((String)this.model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME")));
    }

    protected Property getOutputProperty() {
        String javaSourceFolder = this.model.getStringProperty("IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER");
        if (javaSourceFolder != null && !javaSourceFolder.equals("")) {
            Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
            IPath newOutputPath = null;
            newOutputPath = FlexibleJavaProjectPreferenceUtil.getMultipleModulesPerProjectProp() ? Path.fromOSString((String)("/bin/" + this.getComponentName() + '/')) : Path.fromOSString((String)"/bin/");
            prop.setName("java-output-path");
            prop.setValue(newOutputPath.toString());
            return prop;
        }
        return null;
    }
}

