/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NullLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;

public class ClasspathSelectionHelper {
    public static ClassPathSelection createClasspathSelection(IProject moduleProject, String moduleExtension, IProject earProject, EClass moduleType) {
        if (earProject == null || !earProject.exists()) {
            return null;
        }
        EARFile earFile = null;
        try {
            EARNatureRuntime earNature = (EARNatureRuntime)earProject.getNature("org.eclipse.jst.j2ee.EARNature");
            earFile = (EARFile)earNature.asArchive();
            CommonarchiveFactory factory = ClasspathSelectionHelper.getCommonArchiveFactory();
            CommonarchivePackage pkg = ClasspathSelectionHelper.getCommonArchiveFactory().getCommonarchivePackage();
            EJBJarFile bogusModuleFile = null;
            if (moduleType == pkg.getEJBJarFile()) {
                bogusModuleFile = factory.createEJBJarFile();
            } else if (moduleType == pkg.getApplicationClientFile()) {
                bogusModuleFile = factory.createApplicationClientFile();
            } else if (moduleType == pkg.getWARFile()) {
                bogusModuleFile = factory.createWARFile();
            } else if (moduleType == pkg.getRARFile()) {
                bogusModuleFile = factory.createRARFile();
            }
            bogusModuleFile.setURI(ClasspathSelectionHelper.getUniqueUriInEAR(moduleProject, moduleExtension, earNature));
            bogusModuleFile.setManifest((ArchiveManifest)new ArchiveManifestImpl());
            bogusModuleFile.setLoadStrategy((LoadStrategy)new NullLoadStrategyImpl());
            earFile.getFiles().add((Object)bogusModuleFile);
            return new ClassPathSelection((Archive)bogusModuleFile, moduleProject.getName(), earFile);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        catch (OpenFailureException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return null;
    }

    protected static CommonarchiveFactory getCommonArchiveFactory() {
        return ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getUniqueUriInEAR(IProject moduleProject, String moduleExtension, EARNatureRuntime earNature) {
        Object key;
        EAREditModel earEditModel;
        String result;
        block12: {
            String string;
            block11: {
                String string2;
                block9: {
                    block10: {
                        String base = moduleProject.getName().replace(' ', '_');
                        result = String.valueOf(base) + moduleExtension;
                        earEditModel = null;
                        key = new Object();
                        try {
                            if (earNature == null) {
                                string2 = result;
                                Object var9_9 = null;
                                if (earEditModel == null) break block9;
                                break block10;
                            }
                            earEditModel = earNature.getEarEditModelForRead(key);
                            Application app = earEditModel.getApplication();
                            if (app == null) {
                                string = result;
                                break block11;
                            }
                            int counter = 1;
                            while (app.getFirstModule(result) != null) {
                                result = String.valueOf(base) + counter++ + moduleExtension;
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            if (earEditModel != null) {
                                earEditModel.releaseAccess(key);
                            }
                            earEditModel = null;
                            throw throwable;
                        }
                    }
                    earEditModel.releaseAccess(key);
                }
                earEditModel = null;
                return string2;
            }
            Object var9_10 = null;
            if (earEditModel != null) {
                earEditModel.releaseAccess(key);
            }
            earEditModel = null;
            return string;
        }
        Object var9_12 = null;
        if (earEditModel != null) {
            earEditModel.releaseAccess(key);
        }
        earEditModel = null;
        return result;
    }
}

