/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.datamodel.properties.IAddWebComponentToEnterpriseApplicationDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;

public class AddWebComponentToEARDataModelProvider
extends AddComponentToEnterpriseApplicationDataModelProvider
implements IAddWebComponentToEnterpriseApplicationDataModelProperties {
    public String[] getPropertyNames() {
        String[] props = new String[]{"IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT"};
        return AddWebComponentToEARDataModelProvider.combineProperties((String[])super.getPropertyNames(), (String[])props);
    }

    protected String getDefaultURIExtension() {
        return "war";
    }

    public boolean isWebModuleArchive() {
        return true;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean notify = super.propertySet(propertyName, propertyValue);
        if (notify && propertyName.equals("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT")) {
            this.model.notifyPropertyChange("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT", 2);
        }
        return notify;
    }

    public Object getDefaultProperty(String propertyName) {
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if ("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT".equals(propertyName)) {
            return this.validateContextRoot(this.getStringProperty("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT"));
        }
        return super.validate(propertyName);
    }

    public IStatus validateContextRoot(String contextRoot) {
        if (contextRoot.equals("") || contextRoot == null) {
            return J2EEPlugin.newErrorStatus(ProjectSupportResourceHandler.getString("Context_Root_cannot_be_empty_2", new Object[]{contextRoot}), null);
        }
        if (contextRoot.trim().equals(contextRoot)) {
            StringTokenizer stok = new StringTokenizer(contextRoot, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i))) {
                        Object[] invalidChar = new Object[]{new Character(token.charAt(i)).toString()};
                        String errorStatus = ProjectSupportResourceHandler.getString("The_character_is_invalid_in_a_context_root", invalidChar);
                        return J2EEPlugin.newErrorStatus(errorStatus, null);
                    }
                    ++i;
                }
            }
        } else {
            return J2EEPlugin.newErrorStatus(ProjectSupportResourceHandler.getString("Names_cannot_begin_or_end_with_whitespace_5", new Object[]{contextRoot}), null);
        }
        return OK_STATUS;
    }
}

