/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatRuntimeComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class TomcatRuntimeWizardFragment
extends WizardFragment {
    protected TomcatRuntimeComposite comp;

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime == null) {
            return false;
        }
        IStatus status = runtime.validate(null);
        return status != null && status.getSeverity() != 4;
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new TomcatRuntimeComposite(parent, wizard);
        return this.comp;
    }

    public void enter() {
        if (this.comp != null) {
            IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
            this.comp.setRuntime(runtime);
        }
    }

    public void exit() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        IPath path = runtime.getLocation();
        if (runtime.validate(null).isOK()) {
            TomcatPlugin.setPreference((String)("location" + runtime.getRuntimeType().getId()), (String)path.toString());
        }
    }
}

