/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.ant.internal.ui.launchConfigurations.AntJRETab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAnnotationPlugin;

public class AntLauncherUtility {
    private static final int MAX_TARGET_APPEND_LENGTH = 30;
    private URL url;
    private IPath output;
    private Properties properties;
    private Map templates;
    private boolean useLauncher = false;

    public AntLauncherUtility(URL templateUrl, IPath outputFolder, Properties properties, Map templates) {
        this.url = templateUrl;
        this.output = outputFolder;
        this.properties = properties;
        this.templates = templates;
    }

    public String getBuildFile() throws Exception {
        int c;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.url.openStream()));
        StringBuffer buildFile = new StringBuffer(512);
        do {
            if ((c = reader.read()) == -1) continue;
            buildFile.append((char)c);
        } while (c != -1);
        String build = buildFile.toString();
        Iterator keys = this.templates.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            build = build.replaceAll(key, (String)this.templates.get(key));
        }
        return build;
    }

    public IStatus[] launch(String target, IProgressMonitor monitor) throws Exception {
        String build = this.getBuildFile();
        if (build == null || build.length() < 1) {
            return new IStatus[]{new Status(4, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet", 0, "AntBuildFileDoesNotExist", null)};
        }
        IPath file = XDocletAnnotationPlugin.getDefault().getStateLocation().append("tempAnt.xml");
        try {
            this.createNewFile(file.toFile(), build.getBytes());
        }
        catch (IOException iOException) {}
        this.runAnt(file, new String[]{target}, this.properties, monitor);
        return new IStatus[]{new Status(0, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet", 0, "Finished", null)};
    }

    private void runAnt(IPath buildFile, String[] targets, Properties properties, IProgressMonitor monitor) throws Exception {
        IPath propfile = XDocletAnnotationPlugin.getDefault().getStateLocation().append("build.properties");
        File buildProp = propfile.toFile();
        if (buildProp.exists()) {
            buildProp.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(propfile.toFile());
        properties.store(fileOutputStream, "WTP BUILD FILE PROPERTIES- UPDATED:" + new Date());
        fileOutputStream.close();
        if (this.useLauncher) {
            this.runUsingLauncher(buildFile, targets, monitor);
        } else {
            AntRunner antRunner = new AntRunner();
            antRunner.setBuildFileLocation(buildFile.toString());
            antRunner.setExecutionTargets(targets);
            antRunner.run(monitor);
        }
    }

    private void runUsingLauncher(IPath buildFile, String[] targets, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration configuration = this.createDefaultLaunchConfiguration(buildFile, null, targets[0]);
        DebugUITools.buildAndLaunch((ILaunchConfiguration)configuration, (String)"run", (IProgressMonitor)monitor);
    }

    public ILaunchConfiguration createDefaultLaunchConfiguration(IPath filePath, IProject project, String targetAttribute) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        String projectName = project != null ? project.getName() : null;
        String name = this.getNewLaunchConfigurationName(filePath, projectName, targetAttribute);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", filePath.toString());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targetAttribute);
        CommonTab tab = new CommonTab();
        tab.setDefaults(workingCopy);
        tab.dispose();
        AntJRETab jreTab = new AntJRETab();
        jreTab.setDefaults(workingCopy);
        jreTab.dispose();
        workingCopy.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, false);
        return workingCopy.doSave();
    }

    public String getNewLaunchConfigurationName(IPath filePath, String projectName, String targetAttribute) {
        StringBuffer buffer = new StringBuffer();
        if (projectName != null) {
            buffer.append(projectName);
            buffer.append(' ');
            buffer.append(filePath.lastSegment());
        } else {
            buffer.append(filePath.toOSString());
        }
        if (targetAttribute != null) {
            buffer.append(" [");
            if (targetAttribute.length() > 33) {
                buffer.append(targetAttribute.substring(0, 30));
                buffer.append("...");
            } else {
                buffer.append(targetAttribute);
            }
            buffer.append(']');
        }
        String name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(buffer.toString());
        return name;
    }

    /*
     * Exception decompiling
     */
    public boolean createNewFile(File f, byte[] content) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 55->58)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setUseLauncher(boolean useLauncher) {
        this.useLauncher = useLauncher;
    }
}

