/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.wizard;

import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;
import org.eclipse.wst.javascript.ui.internal.editor.Logger;

public class NewJSWizard
extends Wizard
implements INewWizard {
    static String PAGE_IMAGE = "/icons/full/wizban/newjscriptfile_wiz.gif";
    private WizardNewFileCreationPage fNewFilePage;
    private IStructuredSelection fSelection;

    public void addPages() {
        this.fNewFilePage = new WizardNewFileCreationPage("JSWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection))){

            protected boolean validatePage() {
                Path handlePath = new Path(this.getFileName());
                String extension = handlePath.getFileExtension();
                if (extension == null || !extension.equalsIgnoreCase("js")) {
                    this.setErrorMessage(JavaScriptUIMessages._ERROR_FILENAME_MUST_END_JS);
                    return false;
                }
                this.setErrorMessage(null);
                return super.validatePage();
            }
        };
        this.fNewFilePage.setTitle(JavaScriptUIMessages._UI_WIZARD_NEW_HEADING);
        this.fNewFilePage.setDescription(JavaScriptUIMessages._UI_WIZARD_NEW_DESCRIPTION);
        this.addPage((IWizardPage)this.fNewFilePage);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.fSelection = aSelection;
        this.setWindowTitle(JavaScriptUIMessages._UI_WIZARD_NEW_TITLE);
        if (PAGE_IMAGE != null) {
            ImageDescriptor descriptor = JSEditorPlugin.getDefault().getImageRegistry().getDescriptor(PAGE_IMAGE);
            if (descriptor == null) {
                descriptor = ImageDescriptor.createFromURL((URL)JSEditorPlugin.getDefault().getBundle().getEntry(PAGE_IMAGE));
                JSEditorPlugin.getDefault().getImageRegistry().put(PAGE_IMAGE, descriptor);
            }
            this.setDefaultPageImageDescriptor(descriptor);
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        IFile file = this.fNewFilePage.createNewFile();
        this.openEditor(file);
        return true;
    }
}

