/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wst.javascript.ui.internal.editor.FilteredFileSelectionDialog;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditor;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;

public class JSPreviewContributor {
    private ViewForm fViewForm = null;
    private Browser fBrowser = null;
    private JSEditor fEditor = null;
    private Composite fPreviewToolBar = null;
    private Combo fCombo = null;
    private IProject fProject = null;

    public JSPreviewContributor(ViewForm form, Browser browser, JSEditor editor) {
        this.fViewForm = form;
        this.fBrowser = browser;
        this.fEditor = editor;
    }

    public void createPreviewToolBar() {
        if (this.fViewForm == null) {
            return;
        }
        this.fViewForm.setTopCenterSeparate(true);
        this.fPreviewToolBar = new Composite((Composite)this.fViewForm, 0);
        RowLayout layout = new RowLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        this.fPreviewToolBar.setLayout((Layout)layout);
        this.fViewForm.setTopRight((Control)this.fPreviewToolBar);
        ToolBar toolBar = new ToolBar(this.fPreviewToolBar, 0x800000);
        ToolItem browseButton = new ToolItem(toolBar, 8);
        browseButton.setText(JavaScriptUIMessages.BrowseButtonText);
        browseButton.setToolTipText(JavaScriptUIMessages.BrowseButtonToolTipText);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = ((ToolItem)e.widget).getParent().getShell();
                IContentType[] contentTypes = new IContentType[2];
                IContentTypeManager manager = Platform.getContentTypeManager();
                contentTypes[0] = manager.getContentType("org.eclipse.wst.html.core.htmlsource");
                contentTypes[1] = manager.getContentType("org.eclipse.jst.jsp.core.jspsource");
                FilteredFileSelectionDialog dialog = new FilteredFileSelectionDialog(shell, contentTypes);
                IProject resource = JSPreviewContributor.this.fProject;
                if (resource == null) {
                    resource = ResourcesPlugin.getWorkspace().getRoot();
                }
                dialog.setInput(resource);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null && result.length > 0) {
                    String previewFileName = ((IResource)result[0]).getFullPath().toString();
                    JSPreviewContributor.this.fCombo.add(previewFileName);
                    JSPreviewContributor.this.fCombo.setText(previewFileName);
                    JSPreviewContributor.this.refresh();
                }
            }
        });
        Composite topLeft = new Composite((Composite)this.fViewForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        topLeft.setLayout((Layout)gridLayout);
        CLabel title = new CLabel(topLeft, 0);
        title.setText(JavaScriptUIMessages.PreviewPageDropDownLabel);
        title.setLayoutData((Object)new GridData());
        this.fCombo = new Combo(topLeft, 4);
        String defaultFileName = JavaScriptUIMessages.DefaultFileName;
        this.fCombo.add(defaultFileName);
        this.fCombo.setText(defaultFileName);
        this.fCombo.setLayoutData((Object)new GridData(768));
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSPreviewContributor.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JSPreviewContributor.this.refresh();
            }
        });
        this.fViewForm.setTopLeft((Control)topLeft);
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void refresh() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fCombo.getText());
        if (resource != null && resource.getType() == 1) {
            String url = "file://" + resource.getLocation();
            this.fBrowser.setUrl(url);
        } else {
            String editorText = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput()).get();
            String previewText = "<HTML><BODY><SCRIPT language=\"JavaScript\"><!--\n" + editorText + "\n" + "//-->" + "</SCRIPT></BODY></HTML>";
            this.fBrowser.setText(previewText);
        }
    }
}

