/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.config.CommandLine;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejarClassesForAnalysis {
    static int analysisCount = 0;

    public static List<String> readFromStandardInput() throws IOException {
        return RejarClassesForAnalysis.readFrom(new InputStreamReader(System.in));
    }

    public static List<String> readFrom(Reader r) throws IOException {
        BufferedReader in = new BufferedReader(r);
        LinkedList<String> lst = new LinkedList<String>();
        while (true) {
            String s;
            if ((s = in.readLine()) == null) {
                in.close();
                return lst;
            }
            lst.add(s);
        }
    }

    static String getNextAnalyzeFileOutput(RejarClassesForAnalysisCommandLine commandLine) {
        if (commandLine.maxClasses == Integer.MAX_VALUE) {
            return "analyze.jar";
        }
        String result = "analyze" + analysisCount++ + ".jar";
        System.out.println("Starting " + result);
        return result;
    }

    public static void main(String[] args) throws Exception {
        RejarClassesForAnalysisCommandLine commandLine = new RejarClassesForAnalysisCommandLine();
        int argCount = commandLine.parse(args, 0, Integer.MAX_VALUE, "Usage: " + RejarClassesForAnalysis.class.getName() + " [options] [<jarFile>+] ");
        ZipOutputStream analyzeOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(RejarClassesForAnalysis.getNextAnalyzeFileOutput(commandLine))));
        String classPrefix = commandLine.prefix;
        int analysisClassCount = 0;
        ZipOutputStream auxilaryOut = null;
        if (classPrefix.length() > 0 || commandLine.maxClasses < Integer.MAX_VALUE) {
            auxilaryOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream("auxilary.jar")));
        }
        HashSet<String> copied = new HashSet<String>();
        List<String> fileList = commandLine.inputFileList != null ? RejarClassesForAnalysis.readFrom(new FileReader(commandLine.inputFileList)) : (argCount == args.length ? RejarClassesForAnalysis.readFromStandardInput() : Arrays.asList(args).subList(argCount, args.length - 1));
        for (String fInName : fileList) {
            ZipEntry ze;
            ZipFile zipInputFile;
            File f = new File(fInName);
            if (f.lastModified() < commandLine.maxAge) {
                System.err.println("Skipping " + fInName + ", too old (" + new Date(f.lastModified()) + ")");
                continue;
            }
            System.err.println("Opening " + f);
            try {
                zipInputFile = new ZipFile(f);
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            byte[] buffer = new byte[8192];
            Enumeration<? extends ZipEntry> e = zipInputFile.entries();
            while (e.hasMoreElements() && (ze = e.nextElement()) != null) {
                int bytesRead;
                String name;
                if (ze.isDirectory() || !(name = ze.getName()).endsWith(".class")) continue;
                if (copied.contains(name)) {
                    System.err.println("Skipping duplicate of " + name);
                    continue;
                }
                copied.add(name);
                boolean writeToAnalyzeOut = false;
                boolean writeToAuxilaryOut = false;
                if (name.replace('/', '.').startsWith(classPrefix)) {
                    writeToAnalyzeOut = true;
                    if (commandLine.maxClasses < Integer.MAX_VALUE) {
                        writeToAuxilaryOut = true;
                    }
                    if (++analysisClassCount >= commandLine.maxClasses) {
                        analysisClassCount = 0;
                        analyzeOut.close();
                        analyzeOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(RejarClassesForAnalysis.getNextAnalyzeFileOutput(commandLine))));
                    }
                } else {
                    boolean bl = writeToAuxilaryOut = auxilaryOut != null;
                }
                if (writeToAnalyzeOut) {
                    analyzeOut.putNextEntry(new ZipEntry(name));
                }
                if (writeToAuxilaryOut) {
                    auxilaryOut.putNextEntry(new ZipEntry(name));
                }
                InputStream zipIn = zipInputFile.getInputStream(ze);
                while ((bytesRead = zipIn.read(buffer)) >= 0) {
                    if (writeToAnalyzeOut) {
                        analyzeOut.write(buffer, 0, bytesRead);
                    }
                    if (!writeToAuxilaryOut) continue;
                    auxilaryOut.write(buffer, 0, bytesRead);
                }
                if (writeToAnalyzeOut) {
                    analyzeOut.closeEntry();
                }
                if (!writeToAuxilaryOut) continue;
                auxilaryOut.closeEntry();
            }
            zipInputFile.close();
        }
        analyzeOut.close();
        if (auxilaryOut != null) {
            auxilaryOut.close();
        }
    }

    static class RejarClassesForAnalysisCommandLine
    extends CommandLine {
        public String prefix = "";
        int maxClasses = Integer.MAX_VALUE;
        long maxAge = Long.MIN_VALUE;
        public String inputFileList;

        RejarClassesForAnalysisCommandLine() {
            this.addOption("-maxAge", "days", "maximum age in days (ignore jar files older than this)");
            this.addOption("-inputFileList", "filename", "text file containing names of jar files");
            this.addOption("-maxClasses", "num", "maximum number of classes per analysis*.jar file");
            this.addOption("-prefix", "class name prefix", "prefix of class names that should be analyzed (e.g., edu.umd.cs.)");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            throw new IllegalArgumentException("Unknown option : " + option);
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-prefix")) {
                this.prefix = argument;
            } else if (option.equals("-inputFileList")) {
                this.inputFileList = argument;
            } else if (option.equals("-maxClasses")) {
                this.maxClasses = Integer.parseInt(argument);
            } else if (option.equals("-maxAge")) {
                this.maxAge = System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(argument);
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }
    }
}

