/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;

public abstract class ClassName {
    public static String toSignature(@SlashedClassName String className) {
        if (className.charAt(0) == '[' || className.endsWith(";")) {
            return className;
        }
        return "L" + className + ";";
    }

    @CheckForNull
    public static String fromFieldSignature(String signature) {
        if (signature.charAt(0) != 'L') {
            return null;
        }
        return signature.substring(1, signature.length() - 1);
    }

    public static String fromSignature(String signature) {
        if (signature.charAt(0) == '[') {
            if (signature.charAt(signature.length() - 1) == ';') {
                int start = 1;
                while (signature.charAt(start) == '[') {
                    ++start;
                }
                return signature.substring(start + 1, signature.length() - 1);
            }
            return signature;
        }
        return signature;
    }

    @SlashedClassName
    public static String toSlashedClassName(String className) {
        if (className.indexOf(46) >= 0) {
            return DescriptorFactory.canonicalizeString(className.replace('.', '/'));
        }
        return className;
    }

    public static String toDottedClassName(String className) {
        if (className.indexOf(47) >= 0) {
            className = DescriptorFactory.canonicalizeString(className.replace('/', '.'));
        }
        return className;
    }

    @DottedClassName
    public static String extractPackageName(@DottedClassName String className) {
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return className.substring(0, i);
    }

    @DottedClassName
    public static String extractSimpleName(@DottedClassName String className) {
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    public static boolean isValidClassName(String className) {
        return className.indexOf(40) < 0;
    }

    public static boolean isAnonymous(String className) {
        int i = className.lastIndexOf(36);
        if (i >= 0 && i + 1 < className.length()) {
            return Character.isDigit(className.charAt(i + 1));
        }
        return false;
    }
}

