/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.jaif;

import edu.umd.cs.findbugs.jaif.JAIFEnumConstant;
import edu.umd.cs.findbugs.jaif.JAIFEvents;
import edu.umd.cs.findbugs.jaif.JAIFScanner;
import edu.umd.cs.findbugs.jaif.JAIFSyntaxException;
import edu.umd.cs.findbugs.jaif.JAIFToken;
import edu.umd.cs.findbugs.jaif.JAIFTokenKind;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;

public class JAIFParser {
    private JAIFScanner scanner;
    private JAIFEvents callback;

    public JAIFParser(Reader reader, JAIFEvents callback) {
        this.scanner = new JAIFScanner(reader);
        this.callback = callback;
    }

    public void parse() throws IOException, JAIFSyntaxException {
        this.parseAnnotationFile();
    }

    int getLineNumber() {
        return this.scanner.getLineNumber();
    }

    private JAIFToken expect(String s) throws IOException, JAIFSyntaxException {
        JAIFToken t = this.scanner.nextToken();
        if (!t.lexeme.equals(s)) {
            throw new JAIFSyntaxException(this, "Unexpected token " + t + " (was expecting " + s + ")");
        }
        return t;
    }

    private JAIFToken expect(JAIFTokenKind kind) throws IOException, JAIFSyntaxException {
        JAIFToken t = this.scanner.nextToken();
        if (t.kind != kind) {
            throw new JAIFSyntaxException(this, "Unexpected token " + t + " (was expecting a `" + kind.toString() + "' token)");
        }
        return t;
    }

    private void expectEndOfLine() throws IOException, JAIFSyntaxException {
        JAIFToken t;
        int nlCount = 0;
        while (true) {
            if (this.scanner.atEOF()) {
                t = null;
                break;
            }
            t = this.scanner.peekToken();
            if (t.kind != JAIFTokenKind.NEWLINE) break;
            ++nlCount;
            this.scanner.nextToken();
        }
        if (nlCount < 1) {
            String msg = t == null ? "Unexpected end of file" : "Unexpected token " + t + " (was expecting <newline>)";
            throw new JAIFSyntaxException(this, msg);
        }
    }

    private String readCompoundName() throws IOException, JAIFSyntaxException {
        StringBuffer buf = new StringBuffer();
        boolean firstToken = true;
        while (true) {
            JAIFToken t = this.scanner.nextToken();
            assert (t.kind == JAIFTokenKind.IDENTIFIER_OR_KEYWORD);
            if (firstToken) {
                firstToken = false;
            } else if (t.lexeme.startsWith("@")) {
                throw new JAIFSyntaxException(this, "Illegal compound name (unexpected '@' character)");
            }
            buf.append(t.lexeme);
            t = this.scanner.peekToken();
            if (t.kind != JAIFTokenKind.DOT) break;
            buf.append(t.lexeme);
            this.scanner.nextToken();
        }
        return buf.toString();
    }

    private String readType() throws IOException, JAIFSyntaxException {
        StringBuffer buf = new StringBuffer();
        JAIFToken t = this.expect(JAIFTokenKind.IDENTIFIER_OR_KEYWORD);
        if (t.lexeme.equals("enum")) {
            // empty if block
        }
        return buf.toString();
    }

    private void parseAnnotationFile() throws IOException, JAIFSyntaxException {
        this.parsePackageDefinition();
        while (!this.scanner.atEOF()) {
            this.parsePackageDefinition();
        }
    }

    private void parsePackageDefinition() throws IOException, JAIFSyntaxException {
        String pkgName;
        this.expect("package");
        JAIFToken t = this.scanner.peekToken();
        if (t.kind != JAIFTokenKind.NEWLINE) {
            pkgName = this.readCompoundName();
            this.expect(":");
            t = this.scanner.peekToken();
            while (t.isStartOfAnnotationName()) {
                this.parseAnnotation();
            }
        } else {
            pkgName = "";
        }
        this.expectEndOfLine();
        this.callback.startPackageDefinition(pkgName);
        while (!this.scanner.atEOF()) {
            t = this.scanner.peekToken();
            if (t.lexeme.equals("package")) break;
            this.parseAnnotationDefinitionOrClassDefinition();
        }
        this.callback.endPackageDefinition(pkgName);
    }

    private void parseAnnotation() throws IOException, JAIFSyntaxException {
        String annotationName = this.readCompoundName();
        assert (annotationName.startsWith("@"));
        this.callback.startAnnotation(annotationName);
        JAIFToken t = this.scanner.peekToken();
        if (t.kind == JAIFTokenKind.LPAREN) {
            this.parseAnnotationField();
            t = this.scanner.peekToken();
            while (t.kind != JAIFTokenKind.RPAREN) {
                this.expect(",");
                this.parseAnnotationField();
                t = this.scanner.peekToken();
            }
            assert (t.kind == JAIFTokenKind.RPAREN);
            this.scanner.nextToken();
        }
        this.callback.endAnnotation(annotationName);
    }

    private void parseAnnotationField() throws IOException, JAIFSyntaxException {
        JAIFToken id = this.expect(JAIFTokenKind.IDENTIFIER_OR_KEYWORD);
        this.expect("=");
        Object constant = this.parseConstant();
        this.callback.annotationField(id.lexeme, constant);
    }

    private Object parseConstant() throws IOException, JAIFSyntaxException {
        JAIFToken t = this.scanner.peekToken();
        switch (t.kind) {
            case IDENTIFIER_OR_KEYWORD: {
                String name = this.readCompoundName();
                return new JAIFEnumConstant(name);
            }
            case DECIMAL_LITERAL: {
                t = this.scanner.nextToken();
                return Integer.parseInt(t.lexeme);
            }
            case OCTAL_LITERAL: {
                t = this.scanner.nextToken();
                return Integer.parseInt(t.lexeme, 8);
            }
            case HEX_LITERAL: {
                t = this.scanner.nextToken();
                return Integer.parseInt(t.lexeme, 16);
            }
            case FLOATING_POINT_LITERAL: {
                t = this.scanner.nextToken();
                boolean isFloat = t.lexeme.toLowerCase(Locale.ENGLISH).endsWith("f");
                if (isFloat) {
                    return Float.valueOf(Float.parseFloat(t.lexeme));
                }
                return Double.parseDouble(t.lexeme);
            }
            case STRING_LITERAL: {
                t = this.scanner.nextToken();
                return this.unparseStringLiteral(t.lexeme);
            }
        }
        throw new JAIFSyntaxException(this, "Illegal constant");
    }

    private Object unparseStringLiteral(String lexeme) {
        StringBuffer buf = new StringBuffer();
        int where = 1;
        block10: while (true) {
            assert (where < lexeme.length());
            char c = lexeme.charAt(where);
            if (c == '\"') break;
            if (c != '\\') {
                buf.append(c);
                ++where;
                continue;
            }
            assert (++where < lexeme.length());
            c = lexeme.charAt(where);
            switch (c) {
                case 'b': {
                    buf.append('\b');
                    ++where;
                    continue block10;
                }
                case 't': {
                    buf.append('\t');
                    ++where;
                    continue block10;
                }
                case 'n': {
                    buf.append('\n');
                    ++where;
                    continue block10;
                }
                case 'f': {
                    buf.append('\t');
                    ++where;
                    continue block10;
                }
                case 'r': {
                    buf.append('\r');
                    ++where;
                    continue block10;
                }
                case '\"': {
                    buf.append('\"');
                    ++where;
                    continue block10;
                }
                case '\'': {
                    buf.append('\'');
                    ++where;
                    continue block10;
                }
                case '\\': {
                    buf.append('\\');
                    ++where;
                    continue block10;
                }
            }
            char value = '\u0000';
            while (c >= '0' && c <= '7') {
                value = (char)(value * 8);
                value = (char)(value + (c - 48));
                assert (++where < lexeme.length());
                c = lexeme.charAt(where);
            }
            buf.append(value);
        }
        return buf.toString();
    }

    private void parseAnnotationDefinitionOrClassDefinition() throws IOException, JAIFSyntaxException {
        JAIFToken t = this.scanner.peekToken();
        if (t.lexeme.equals("annotation")) {
            this.parseAnnotationDefinition();
        } else if (t.lexeme.equals("class")) {
            this.parseClassDefinition();
        } else {
            throw new JAIFSyntaxException(this, "Unexpected token " + t + " (expected `annotation' or `class')");
        }
    }

    private void parseAnnotationDefinition() throws IOException, JAIFSyntaxException {
        this.expect("annotation");
        String retention = null;
        JAIFToken t = this.scanner.peekToken();
        if (t.lexeme.equals("visible") || t.lexeme.equals("invisible") || t.lexeme.equals("source")) {
            retention = t.lexeme;
            this.scanner.nextToken();
        }
        String annotationName = this.expect((JAIFTokenKind)JAIFTokenKind.IDENTIFIER_OR_KEYWORD).lexeme;
        this.expect(JAIFTokenKind.COLON);
        this.expectEndOfLine();
        this.callback.startAnnotationDefinition(annotationName, retention);
        t = this.scanner.peekToken();
        while (t.kind != JAIFTokenKind.NEWLINE) {
            this.parseAnnotationFieldDefinition();
        }
    }

    private void parseAnnotationFieldDefinition() throws IOException, JAIFSyntaxException {
        String type = this.readType();
        String fieldName = this.expect((JAIFTokenKind)JAIFTokenKind.IDENTIFIER_OR_KEYWORD).lexeme;
        this.callback.annotationFieldDefinition(type, fieldName);
    }

    private void parseClassDefinition() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: " + JAIFParser.class.getName() + " <jaif file>");
            System.exit(1);
        }
        JAIFEvents callback = new JAIFEvents(){

            public void annotationField(String fieldName, Object constant) {
                System.out.println("    " + fieldName + "=" + constant);
            }

            public void endAnnotation(String annotationName) {
            }

            public void endPackageDefinition(String pkgName) {
            }

            public void startAnnotation(String annotationName) {
                System.out.println("  annotation " + annotationName);
            }

            public void startPackageDefinition(String pkgName) {
                System.out.println("package " + pkgName);
            }

            public void startAnnotationDefinition(String annotationName, String retention) {
                System.out.println("  annotation " + annotationName + " " + retention);
            }

            public void endAnnotationDefinition(String annotationName) {
            }

            public void annotationFieldDefinition(String type, String fieldName) {
                System.out.println("    " + type + " " + fieldName);
            }
        };
        JAIFParser parser = new JAIFParser(new FileReader(args[0]), callback);
        parser.parse();
    }
}

