/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.config;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFilterSettings
implements Cloneable {
    public static final String HIGH_PRIORITY = "High";
    public static final String MEDIUM_PRIORITY = "Medium";
    public static final String LOW_PRIORITY = "Low";
    public static final String EXPERIMENTAL_PRIORITY = "Experimental";
    public static final String DEFAULT_PRIORITY = "Medium";
    private static Map<String, Integer> priorityNameToValueMap = new HashMap<String, Integer>();
    private static String FIELD_DELIMITER;
    private static String LISTITEM_DELIMITER;
    private Set<String> activeBugCategorySet;
    private Set<String> hiddenBugCategorySet;
    private String minPriority;
    private int minPriorityAsInt;
    private boolean displayFalseWarnings;

    private ProjectFilterSettings() {
        DetectorFactoryCollection.instance();
        this.activeBugCategorySet = new TreeSet<String>(I18N.instance().getBugCategories());
        this.hiddenBugCategorySet = new HashSet<String>();
        this.setMinPriority("Medium");
        this.displayFalseWarnings = false;
    }

    public static ProjectFilterSettings createDefault() {
        ProjectFilterSettings result = new ProjectFilterSettings();
        result.setMinPriority("Medium");
        return result;
    }

    public static ProjectFilterSettings fromEncodedString(String s) {
        int bar;
        ProjectFilterSettings result = new ProjectFilterSettings();
        if (s.length() > 0) {
            String minPriority;
            bar = s.indexOf(FIELD_DELIMITER);
            if (bar >= 0) {
                minPriority = s.substring(0, bar);
                s = s.substring(bar + 1);
            } else {
                minPriority = s;
                s = "";
            }
            if (priorityNameToValueMap.get(minPriority) == null) {
                minPriority = "Medium";
            }
            result.setMinPriority(minPriority);
        }
        if (s.length() > 0) {
            String categories;
            bar = s.indexOf(FIELD_DELIMITER);
            if (bar >= 0) {
                categories = s.substring(0, bar);
                s = s.substring(bar + 1);
            } else {
                categories = s;
                s = "";
            }
            StringTokenizer t = new StringTokenizer(categories, LISTITEM_DELIMITER);
            while (t.hasMoreTokens()) {
                String category = t.nextToken();
                result.addCategory(category);
            }
        }
        if (s.length() > 0) {
            String displayFalseWarnings;
            bar = s.indexOf(FIELD_DELIMITER);
            if (bar >= 0) {
                displayFalseWarnings = s.substring(0, bar);
                s = s.substring(bar + 1);
            } else {
                displayFalseWarnings = s;
                s = "";
            }
            result.setDisplayFalseWarnings(Boolean.valueOf(displayFalseWarnings));
        }
        if (s.length() > 0) {
            // empty if block
        }
        return result;
    }

    public static void hiddenFromEncodedString(ProjectFilterSettings result, String s) {
        if (s.length() > 0) {
            int bar = s.indexOf(FIELD_DELIMITER);
            String categories = bar >= 0 ? s.substring(0, bar) : s;
            StringTokenizer t = new StringTokenizer(categories, LISTITEM_DELIMITER);
            while (t.hasMoreTokens()) {
                String category = t.nextToken();
                result.removeCategory(category);
            }
        }
    }

    public boolean displayWarning(BugInstance bugInstance) {
        int priority = bugInstance.getPriority();
        if (priority > this.getMinPriorityAsInt()) {
            return false;
        }
        BugPattern bugPattern = bugInstance.getBugPattern();
        if (bugPattern != null && !this.containsCategory(bugPattern.getCategory())) {
            return false;
        }
        if (!this.displayFalseWarnings) {
            boolean isFalseWarning;
            boolean bl = isFalseWarning = Boolean.valueOf(bugInstance.getProperty("isBug", "true")) == false;
            if (isFalseWarning) {
                return false;
            }
        }
        return true;
    }

    public void setMinPriority(String minPriority) {
        this.minPriority = minPriority;
        Integer value = priorityNameToValueMap.get(minPriority);
        if (value == null && (value = priorityNameToValueMap.get("Medium")) == null) {
            throw new IllegalStateException();
        }
        this.minPriorityAsInt = value;
    }

    public String getMinPriority() {
        return this.minPriority;
    }

    public int getMinPriorityAsInt() {
        return this.minPriorityAsInt;
    }

    public void addCategory(String category) {
        this.hiddenBugCategorySet.remove(category);
        this.activeBugCategorySet.add(category);
    }

    public void removeCategory(String category) {
        this.hiddenBugCategorySet.add(category);
        this.activeBugCategorySet.remove(category);
    }

    public void clearAllCategories() {
        this.activeBugCategorySet.addAll(this.hiddenBugCategorySet);
        this.hiddenBugCategorySet.clear();
    }

    public boolean containsCategory(String category) {
        return !this.hiddenBugCategorySet.contains(category);
    }

    public Set<String> getActiveCategorySet() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.activeBugCategorySet);
        return result;
    }

    public void setDisplayFalseWarnings(boolean displayFalseWarnings) {
        this.displayFalseWarnings = displayFalseWarnings;
    }

    public boolean displayFalseWarnings() {
        return this.displayFalseWarnings;
    }

    public String hiddenToEncodedString() {
        StringBuffer buf = new StringBuffer();
        Iterator<String> i = this.hiddenBugCategorySet.iterator();
        while (i.hasNext()) {
            buf.append(i.next());
            if (!i.hasNext()) continue;
            buf.append(LISTITEM_DELIMITER);
        }
        buf.append(FIELD_DELIMITER);
        return buf.toString();
    }

    public String toEncodedString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getMinPriority());
        buf.append(FIELD_DELIMITER);
        Iterator<String> i = this.activeBugCategorySet.iterator();
        while (i.hasNext()) {
            buf.append(i.next());
            if (!i.hasNext()) continue;
            buf.append(LISTITEM_DELIMITER);
        }
        buf.append(FIELD_DELIMITER);
        buf.append(this.displayFalseWarnings ? "true" : "false");
        return buf.toString();
    }

    public String toString() {
        return this.toEncodedString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ProjectFilterSettings other = (ProjectFilterSettings)obj;
        if (!this.getMinPriority().equals(other.getMinPriority())) {
            return false;
        }
        if (!((Object)this.hiddenBugCategorySet).equals(other.hiddenBugCategorySet)) {
            return false;
        }
        return this.displayFalseWarnings == other.displayFalseWarnings;
    }

    public Object clone() {
        try {
            ProjectFilterSettings clone = (ProjectFilterSettings)super.clone();
            clone.hiddenBugCategorySet = new HashSet<String>();
            clone.hiddenBugCategorySet.addAll(this.hiddenBugCategorySet);
            clone.activeBugCategorySet = new TreeSet<String>();
            clone.activeBugCategorySet.addAll(this.activeBugCategorySet);
            clone.setMinPriority(this.getMinPriority());
            clone.displayFalseWarnings = this.displayFalseWarnings;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return this.minPriority.hashCode() + 1009 * ((Object)this.hiddenBugCategorySet).hashCode() + (this.displayFalseWarnings ? 7919 : 0);
    }

    public static String getIntPriorityAsString(int prio) {
        String minPriority;
        switch (prio) {
            case 4: {
                minPriority = EXPERIMENTAL_PRIORITY;
                break;
            }
            case 3: {
                minPriority = LOW_PRIORITY;
                break;
            }
            case 2: {
                minPriority = "Medium";
                break;
            }
            case 1: {
                minPriority = HIGH_PRIORITY;
                break;
            }
            default: {
                minPriority = "Medium";
            }
        }
        return minPriority;
    }

    static {
        priorityNameToValueMap.put(HIGH_PRIORITY, 1);
        priorityNameToValueMap.put("Medium", 2);
        priorityNameToValueMap.put(LOW_PRIORITY, 3);
        priorityNameToValueMap.put(EXPERIMENTAL_PRIORITY, 4);
        FIELD_DELIMITER = "|";
        LISTITEM_DELIMITER = ",";
    }
}

