/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipInputStreamCodeBaseEntry;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.util.MapCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipInputStreamCodeBase
extends AbstractScannableCodeBase {
    static final boolean DEBUG = false;
    final File file;
    final MapCache<String, ZipInputStreamCodeBaseEntry> map = new MapCache(10000);
    final HashSet<String> entries = new HashSet();

    public ZipInputStreamCodeBase(ICodeBaseLocator codeBaseLocator, File file) throws IOException {
        super(codeBaseLocator);
        ZipEntry ze;
        this.file = file;
        this.setLastModifiedTime(file.lastModified());
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        boolean count = false;
        while ((ze = zis.getNextEntry()) != null) {
            if (!ze.isDirectory() && (ze.getName().equals("META-INF/MANIFEST.MF") || ze.getName().endsWith(".class"))) {
                this.entries.add(ze.getName());
                if (ze.getName().equals("META-INF/MANIFEST.MF")) {
                    this.map.put(ze.getName(), this.build(zis, ze));
                }
            }
            zis.closeEntry();
        }
    }

    public ICodeBaseEntry lookupResource(String resourceName) {
        if (!this.entries.contains(resourceName = this.translateResourceName(resourceName))) {
            return null;
        }
        try {
            ZipEntry ze;
            ZipInputStreamCodeBaseEntry z = (ZipInputStreamCodeBaseEntry)this.map.get(resourceName);
            if (z != null) {
                return z;
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(this.file));
            boolean found = false;
            int countDown = 20;
            while ((ze = zis.getNextEntry()) != null && countDown >= 0) {
                if (ze.getName().equals(resourceName)) {
                    found = true;
                }
                if (found) {
                    --countDown;
                    if (this.map.containsKey(ze.getName())) continue;
                    z = this.build(zis, ze);
                    this.map.put(ze.getName(), z);
                }
                zis.closeEntry();
            }
            z = (ZipInputStreamCodeBaseEntry)this.map.get(resourceName);
            if (z == null) {
                throw new AssertionError((Object)("Could not find " + resourceName));
            }
            return z;
        }
        catch (IOException e) {
            return null;
        }
    }

    ZipInputStreamCodeBaseEntry build(ZipInputStream zis, ZipEntry ze) throws IOException {
        long sz = ze.getSize();
        ByteArrayOutputStream out = sz < 0L || sz > Integer.MAX_VALUE ? new ByteArrayOutputStream() : new ByteArrayOutputStream((int)sz);
        IO.copy(zis, out);
        byte[] bytes = out.toByteArray();
        this.setLastModifiedTime(ze.getTime());
        return new ZipInputStreamCodeBaseEntry(this, ze, bytes);
    }

    public ICodeBaseIterator iterator() {
        return new MyIterator();
    }

    public String getPathName() {
        return this.file.getName();
    }

    public void close() {
    }

    public String toString() {
        return this.file.getName();
    }

    class MyIterator
    implements ICodeBaseIterator {
        ZipInputStream zis;
        ZipEntry ze;

        MyIterator() {
            try {
                this.zis = new ZipInputStream(new FileInputStream(ZipInputStreamCodeBase.this.file));
                this.ze = this.zis.getNextEntry();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void getNextEntry() throws IOException {
            this.ze = this.zis.getNextEntry();
            if (this.ze == null) {
                this.zis.close();
            }
        }

        public boolean hasNext() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            return this.ze != null;
        }

        public ICodeBaseEntry next() throws InterruptedException {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ZipInputStreamCodeBaseEntry z = ZipInputStreamCodeBase.this.build(this.zis, this.ze);
                this.zis.closeEntry();
                this.getNextEntry();
                return z;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

