/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractScannableCodeBase
implements IScannableCodeBase {
    private ICodeBaseLocator codeBaseLocator;
    private boolean isAppCodeBase;
    private int howDiscovered;
    private long lastModifiedTime;
    private Map<String, String> resourceNameTranslationMap;

    public AbstractScannableCodeBase(ICodeBaseLocator codeBaseLocator) {
        this.codeBaseLocator = codeBaseLocator;
        this.lastModifiedTime = -1L;
        this.resourceNameTranslationMap = new HashMap<String, String>();
    }

    public ICodeBaseLocator getCodeBaseLocator() {
        return this.codeBaseLocator;
    }

    public boolean containsSourceFiles() {
        return false;
    }

    public void setApplicationCodeBase(boolean isAppCodeBase) {
        this.isAppCodeBase = isAppCodeBase;
    }

    public boolean isApplicationCodeBase() {
        return this.isAppCodeBase;
    }

    public void setHowDiscovered(int howDiscovered) {
        this.howDiscovered = howDiscovered;
    }

    public int getHowDiscovered() {
        return this.howDiscovered;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        if (lastModifiedTime > 0L) {
            this.lastModifiedTime = lastModifiedTime;
        }
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void addResourceNameTranslation(String origResourceName, String newResourceName) {
        if (!origResourceName.equals(newResourceName)) {
            this.resourceNameTranslationMap.put(origResourceName, newResourceName);
        }
    }

    public String translateResourceName(String resourceName) {
        String translatedName = this.resourceNameTranslationMap.get(resourceName);
        return translatedName != null ? translatedName : resourceName;
    }
}

