/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorFactory {
    private static ThreadLocal<DescriptorFactory> instance = new ThreadLocal<DescriptorFactory>(){

        @Override
        protected DescriptorFactory initialValue() {
            return new DescriptorFactory();
        }
    };
    private Map<String, ClassDescriptor> classDescriptorMap;
    private Map<MethodDescriptor, MethodDescriptor> methodDescriptorMap;
    private Map<FieldDescriptor, FieldDescriptor> fieldDescriptorMap;
    MapCache<String, String> stringCache = new MapCache(10000);

    private DescriptorFactory() {
        this.classDescriptorMap = new HashMap<String, ClassDescriptor>();
        this.methodDescriptorMap = new HashMap<MethodDescriptor, MethodDescriptor>();
        this.fieldDescriptorMap = new HashMap<FieldDescriptor, FieldDescriptor>();
    }

    public static String canonicalizeString(String s) {
        if (s == null) {
            return null;
        }
        DescriptorFactory instance = DescriptorFactory.instance();
        String result = (String)instance.stringCache.get(s);
        if (result != null) {
            return result;
        }
        instance.stringCache.put(s, s);
        return s;
    }

    public static DescriptorFactory instance() {
        return instance.get();
    }

    public static void clearInstance() {
        instance.remove();
    }

    public Collection<ClassDescriptor> getAllClassDescriptors() {
        return this.classDescriptorMap.values();
    }

    public void purge(Collection<ClassDescriptor> unusable) {
        for (ClassDescriptor c : unusable) {
            this.classDescriptorMap.remove(c.getClassName());
        }
    }

    public ClassDescriptor getClassDescriptor(@SlashedClassName String className) {
        assert (className.indexOf(46) == -1);
        ClassDescriptor classDescriptor = this.classDescriptorMap.get(className = DescriptorFactory.canonicalizeString(className));
        if (classDescriptor == null) {
            classDescriptor = new ClassDescriptor(className);
            this.classDescriptorMap.put(className, classDescriptor);
        }
        return classDescriptor;
    }

    public ClassDescriptor getClassDescriptorForDottedClassName(@DottedClassName String dottedClassName) {
        return this.getClassDescriptor(dottedClassName.replace('.', '/'));
    }

    public MethodDescriptor getMethodDescriptor(JavaClass jClass, Method method) {
        return this.getMethodDescriptor(ClassName.toSlashedClassName(jClass.getClassName()), method.getName(), method.getSignature(), method.isStatic());
    }

    public MethodDescriptor getMethodDescriptor(@SlashedClassName String className, String name, String signature, boolean isStatic) {
        if (className == null) {
            throw new NullPointerException("className must be nonnull");
        }
        MethodDescriptor methodDescriptor = new MethodDescriptor(className, name, signature, isStatic);
        MethodDescriptor existing = this.methodDescriptorMap.get(methodDescriptor);
        if (existing == null) {
            this.methodDescriptorMap.put(methodDescriptor, methodDescriptor);
            existing = methodDescriptor;
        }
        return existing;
    }

    public void profile() {
        int total = 0;
        int keys = 0;
        int values = 0;
        boolean bad = false;
        for (Map.Entry<MethodDescriptor, MethodDescriptor> e : this.methodDescriptorMap.entrySet()) {
            ++total;
            if (e.getKey() instanceof MethodInfo) {
                ++keys;
            } else if (total - keys < 10) {
                System.out.println(e.getKey());
            }
            if (!(e.getValue() instanceof MethodInfo)) continue;
            ++values;
        }
        System.out.printf("Descriptor factory: %d/%d/%d\n", keys, values, total);
    }

    public void canonicalize(MethodDescriptor m) {
        MethodDescriptor existing = this.methodDescriptorMap.get(m);
        if (m != existing) {
            this.methodDescriptorMap.remove(m);
            this.methodDescriptorMap.put(m, m);
        }
    }

    public void canonicalize(FieldDescriptor m) {
        FieldDescriptor existing = this.fieldDescriptorMap.get(m);
        if (m != existing) {
            this.fieldDescriptorMap.remove(m);
            this.fieldDescriptorMap.put(m, m);
        }
    }

    public MethodDescriptor getMethodDescriptor(MethodAnnotation ma) {
        return this.getMethodDescriptor(ClassName.toSlashedClassName(ma.getClassName()), ma.getMethodName(), ma.getMethodSignature(), ma.isStatic());
    }

    public FieldDescriptor getFieldDescriptor(@SlashedClassName String className, String name, String signature, boolean isStatic) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor(className, name, signature, isStatic);
        FieldDescriptor existing = this.fieldDescriptorMap.get(fieldDescriptor);
        if (existing == null) {
            this.fieldDescriptorMap.put(fieldDescriptor, fieldDescriptor);
            existing = fieldDescriptor;
        }
        return existing;
    }

    public FieldDescriptor getFieldDescriptor(FieldAnnotation ma) {
        return this.getFieldDescriptor(ClassName.toSlashedClassName(ma.getClassName()), ma.getFieldName(), ma.getFieldSignature(), ma.isStatic());
    }

    public static ClassDescriptor createClassDescriptor(JavaClass c) {
        return DescriptorFactory.createClassDescriptorFromDottedClassName(c.getClassName());
    }

    public static ClassDescriptor createClassDescriptorFromResourceName(String resourceName) {
        if (!DescriptorFactory.isClassResource(resourceName)) {
            throw new IllegalArgumentException("Resource " + resourceName + " is not a class");
        }
        return DescriptorFactory.createClassDescriptor(resourceName.substring(0, resourceName.length() - 6));
    }

    @CheckForNull
    public static ClassDescriptor createClassDescriptorFromFieldSignature(String signature) {
        int start = signature.indexOf(76);
        if (start < 0) {
            return null;
        }
        int end = signature.indexOf(59, start);
        if (end < 0) {
            return null;
        }
        return DescriptorFactory.createClassDescriptor(signature.substring(start + 1, end));
    }

    public static boolean isClassResource(String resourceName) {
        return resourceName.endsWith(".class");
    }

    public static ClassDescriptor createClassDescriptorFromSignature(String signature) {
        int first = 0;
        while (signature.charAt(first) == '[') {
            ++first;
        }
        if ((signature = signature.substring(first)).endsWith(";")) {
            signature = signature.substring(1, signature.length() - 1);
        }
        return DescriptorFactory.createClassDescriptor(signature);
    }

    public static ClassDescriptor createClassDescriptor(@SlashedClassName String className) {
        className = ClassName.fromSignature(className);
        return DescriptorFactory.instance().getClassDescriptor(className);
    }

    public static ClassDescriptor[] createClassDescriptor(String[] classNames) {
        ClassDescriptor[] result = new ClassDescriptor[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            result[i] = DescriptorFactory.createClassDescriptor(classNames[i]);
        }
        return result;
    }

    public static ClassDescriptor createClassDescriptorFromDottedClassName(String dottedClassName) {
        return DescriptorFactory.createClassDescriptor(dottedClassName.replace('.', '/'));
    }
}

