/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.HashMap;
import org.apache.bcel.generic.ConstantPoolGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeQualifierDataflowFactory<AnalysisType extends TypeQualifierDataflowAnalysis, DataflowType extends TypeQualifierDataflow<AnalysisType>> {
    private HashMap<TypeQualifierValue, DataflowResult<DataflowType>> dataflowMap;
    private MethodDescriptor methodDescriptor;

    public TypeQualifierDataflowFactory(MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
        this.dataflowMap = new HashMap();
    }

    public DataflowType getDataflow(TypeQualifierValue typeQualifierValue) throws CheckedAnalysisException {
        DataflowResult<DataflowType> result = this.dataflowMap.get(typeQualifierValue);
        if (result == null) {
            result = this.compute(typeQualifierValue);
            this.dataflowMap.put(typeQualifierValue, result);
        }
        return (DataflowType)((TypeQualifierDataflow)result.get());
    }

    private DataflowResult<DataflowType> compute(TypeQualifierValue typeQualifierValue) {
        DataflowResult result = new DataflowResult();
        try {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            DepthFirstSearch dfs = analysisCache.getMethodAnalysis(DepthFirstSearch.class, this.methodDescriptor);
            XMethod xmethod = XFactory.createXMethod(this.methodDescriptor);
            CFG cfg = analysisCache.getMethodAnalysis(CFG.class, this.methodDescriptor);
            ValueNumberDataflow vnaDataflow = analysisCache.getMethodAnalysis(ValueNumberDataflow.class, this.methodDescriptor);
            ConstantPoolGen cpg = analysisCache.getClassAnalysis(ConstantPoolGen.class, this.methodDescriptor.getClassDescriptor());
            DataflowType dataflow = this.getDataflow(dfs, xmethod, cfg, vnaDataflow, cpg, analysisCache, this.methodDescriptor, typeQualifierValue);
            result.dataflow = dataflow;
        }
        catch (CheckedAnalysisException e) {
            result.checkedException = e;
        }
        catch (RuntimeException e) {
            result.runtimeException = e;
        }
        return result;
    }

    protected abstract DataflowType getDataflow(DepthFirstSearch var1, XMethod var2, CFG var3, ValueNumberDataflow var4, ConstantPoolGen var5, IAnalysisCache var6, MethodDescriptor var7, TypeQualifierValue var8) throws CheckedAnalysisException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataflowResult<DataflowType> {
        DataflowType dataflow;
        CheckedAnalysisException checkedException;
        RuntimeException runtimeException;

        private DataflowResult() {
        }

        DataflowType get() throws CheckedAnalysisException {
            if (this.dataflow != null) {
                return this.dataflow;
            }
            if (this.checkedException != null) {
                throw this.checkedException;
            }
            throw this.runtimeException;
        }
    }
}

