/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AbstractMethod;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.lang.annotation.ElementType;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnresolvedXMethod
extends AbstractMethod
implements XMethod {
    protected UnresolvedXMethod(@DottedClassName String className, String methodName, String methodSig, int accessFlags) {
        super(className, methodName, methodSig, accessFlags);
        if (XFactory.DEBUG_UNRESOLVED) {
            System.out.println("Unresolved xmethod: " + this);
        }
    }

    protected UnresolvedXMethod(MethodDescriptor m) {
        super(m.getClassDescriptor().getDottedClassName(), m.getName(), m.getSignature(), 0);
        if (XFactory.DEBUG_UNRESOLVED) {
            System.out.println("Unresolved xmethod: " + this);
        }
    }

    @Override
    public boolean isReturnTypeReferenceType() {
        SignatureParser parser = new SignatureParser(this.getSignature());
        String returnTypeSig = parser.getReturnTypeSignature();
        return SignatureParser.isReferenceType(returnTypeSig);
    }

    public int compareTo(Object o) {
        if (o instanceof XMethod) {
            return XFactory.compare(this, (XMethod)o);
        }
        throw new ClassCastException("Don't know how to compare " + this.getClass().getName() + " to " + o.getClass().getName());
    }

    @Override
    public AnnotationValue getAnnotation(ClassDescriptor desc) {
        return null;
    }

    @Override
    public Collection<ClassDescriptor> getAnnotationDescriptors() {
        return TigerSubstitutes.emptyList();
    }

    @Override
    public Collection<AnnotationValue> getAnnotations() {
        return TigerSubstitutes.emptyList();
    }

    @Override
    public AnnotationValue getParameterAnnotation(int param, ClassDescriptor desc) {
        return null;
    }

    @Override
    public Collection<ClassDescriptor> getParameterAnnotationDescriptors(int param) {
        return TigerSubstitutes.emptyList();
    }

    @Override
    public Collection<AnnotationValue> getParameterAnnotations(int param) {
        return TigerSubstitutes.emptyList();
    }

    @Override
    public ElementType getElementType() {
        if (this.getName().equals("<init>")) {
            return ElementType.CONSTRUCTOR;
        }
        return ElementType.METHOD;
    }

    @Override
    @CheckForNull
    public AnnotatedObject getContainingScope() {
        try {
            return (ClassInfo)Global.getAnalysisCache().getClassAnalysis(XClass.class, this.getClassDescriptor());
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    @Override
    public String[] getThrownExceptions() {
        return new String[0];
    }

    @Override
    public boolean isUnconditionalThrower() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }
}

