/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class SourceLineAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROLE = "SOURCE_LINE_DEFAULT";
    public static final String DEFAULT_ROLE_UNKNOWN_LINE = "SOURCE_LINE_DEFAULT_UNKNOWN_LINE";
    public static final String ROLE_ANOTHER_INSTANCE = "SOURCE_LINE_ANOTHER_INSTANCE";
    public static final String UNKNOWN_SOURCE_FILE = "<Unknown>";
    private String description;
    private final String className;
    private String sourceFile;
    private final int startLine;
    private final int endLine;
    private final int startBytecode;
    private final int endBytecode;
    private boolean synthetic;
    public static final String DESCRIPTION_LAST_CHANGE = "SOURCE_LINE_LAST_CHANGE";
    public static final String DESCRIPTION_LOOP_BOTTOM = "SOURCE_LINE_LOOP_BOTTOM\t";
    private static final String ELEMENT_NAME = "SourceLine";

    public SourceLineAnnotation(@NonNull String className, @NonNull String sourceFile, int startLine, int endLine, int startBytecode, int endBytecode) {
        if (className == null) {
            throw new IllegalArgumentException("class name is null");
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException("source file is null");
        }
        this.description = DEFAULT_ROLE;
        this.className = className;
        this.sourceFile = sourceFile;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startBytecode = startBytecode;
        this.endBytecode = endBytecode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SourceLineAnnotation createUnknown(String className, String sourceFile) {
        return SourceLineAnnotation.createUnknown(className, sourceFile, -1, -1);
    }

    public static SourceLineAnnotation createUnknown(String className) {
        return SourceLineAnnotation.createUnknown(className, AnalysisContext.currentAnalysisContext().lookupSourceFile(className), -1, -1);
    }

    public static SourceLineAnnotation createReallyUnknown(String className) {
        return SourceLineAnnotation.createUnknown(className, UNKNOWN_SOURCE_FILE, -1, -1);
    }

    public static SourceLineAnnotation createUnknown(String className, String sourceFile, int startBytecode, int endBytecode) {
        SourceLineAnnotation result = new SourceLineAnnotation(className, sourceFile, -1, -1, startBytecode, endBytecode);
        return result;
    }

    public static SourceLineAnnotation fromVisitedMethod(PreorderVisitor visitor) {
        SourceLineAnnotation sourceLines = SourceLineAnnotation.getSourceAnnotationForMethod(visitor.getDottedClassName(), visitor.getMethodName(), visitor.getMethodSig());
        return sourceLines;
    }

    public static SourceLineAnnotation fromVisitedMethod(MethodGen methodGen, String sourceFile) {
        LineNumberTable lineNumberTable = methodGen.getLineNumberTable(methodGen.getConstantPool());
        String className = methodGen.getClassName();
        int codeSize = methodGen.getInstructionList().getLength();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, 0, codeSize - 1);
        }
        return SourceLineAnnotation.forEntireMethod(className, sourceFile, lineNumberTable, codeSize);
    }

    public static SourceLineAnnotation forEntireMethod(String className, String sourceFile, LineNumberTable lineNumberTable, int codeSize) {
        LineNumber[] table = lineNumberTable.getLineNumberTable();
        if (table != null && table.length > 0) {
            LineNumber first = table[0];
            LineNumber last = table[table.length - 1];
            return new SourceLineAnnotation(className, sourceFile, first.getLineNumber(), last.getLineNumber(), 0, codeSize - 1);
        }
        return SourceLineAnnotation.createUnknown(className, sourceFile, 0, codeSize - 1);
    }

    public static SourceLineAnnotation forEntireMethod(JavaClass javaClass, @CheckForNull Method method) {
        String sourceFile = javaClass.getSourceFileName();
        if (method == null) {
            return SourceLineAnnotation.createUnknown(javaClass.getClassName(), sourceFile);
        }
        Code code = method.getCode();
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (code == null || lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(javaClass.getClassName(), sourceFile);
        }
        return SourceLineAnnotation.forEntireMethod(javaClass.getClassName(), sourceFile, lineNumberTable, code.getLength());
    }

    public static SourceLineAnnotation forEntireMethod(JavaClass javaClass, XMethod xmethod) {
        JavaClassAndMethod m = Hierarchy.findMethod(javaClass, xmethod.getName(), xmethod.getSignature());
        if (m == null) {
            return SourceLineAnnotation.createUnknown(javaClass.getClassName(), javaClass.getSourceFileName());
        }
        return SourceLineAnnotation.forEntireMethod(javaClass, m.getMethod());
    }

    public static SourceLineAnnotation fromVisitedInstruction(BytecodeScanningDetector visitor, int pc) {
        return SourceLineAnnotation.fromVisitedInstructionRange(visitor.getClassContext(), visitor, pc, pc);
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, PreorderVisitor visitor, int pc) {
        return SourceLineAnnotation.fromVisitedInstructionRange(classContext, visitor, pc, pc);
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, Method method, Location loc) {
        return SourceLineAnnotation.fromVisitedInstruction(classContext, method, loc.getHandle());
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, Method method, InstructionHandle handle) {
        return SourceLineAnnotation.fromVisitedInstruction(classContext, method, handle.getPosition());
    }

    public static SourceLineAnnotation fromVisitedInstruction(MethodDescriptor methodDescriptor, Location location) {
        return SourceLineAnnotation.fromVisitedInstruction(methodDescriptor, location.getHandle().getPosition());
    }

    public static SourceLineAnnotation fromVisitedInstruction(MethodDescriptor methodDescriptor, int position) {
        try {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, methodDescriptor.getClassDescriptor());
            Method method = analysisCache.getMethodAnalysis(Method.class, methodDescriptor);
            return SourceLineAnnotation.fromVisitedInstruction(jclass, method, position);
        }
        catch (CheckedAnalysisException e) {
            return SourceLineAnnotation.createReallyUnknown(methodDescriptor.getClassDescriptor().toDottedClassName());
        }
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, Method method, int pc) {
        return SourceLineAnnotation.fromVisitedInstruction(classContext.getJavaClass(), method, pc);
    }

    public static SourceLineAnnotation fromVisitedInstruction(JavaClass jclass, Method method, int pc) {
        LineNumberTable lineNumberTable = method.getCode().getLineNumberTable();
        String className = jclass.getClassName();
        String sourceFile = jclass.getSourceFileName();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, pc, pc);
        }
        int startLine = lineNumberTable.getSourceLine(pc);
        return new SourceLineAnnotation(className, sourceFile, startLine, startLine, pc, pc);
    }

    public static SourceLineAnnotation fromVisitedInstructionRange(BytecodeScanningDetector visitor, int startPC, int endPC) {
        LineNumberTable lineNumberTable = SourceLineAnnotation.getLineNumberTable(visitor);
        String className = visitor.getDottedClassName();
        String sourceFile = visitor.getSourceFile();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, startPC, endPC);
        }
        int startLine = lineNumberTable.getSourceLine(startPC);
        int endLine = lineNumberTable.getSourceLine(endPC);
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, startPC, endPC);
    }

    public static SourceLineAnnotation fromVisitedInstructionRange(ClassContext classContext, PreorderVisitor visitor, int startPC, int endPC) {
        LineNumberTable lineNumberTable = SourceLineAnnotation.getLineNumberTable(visitor);
        String className = visitor.getDottedClassName();
        String sourceFile = visitor.getSourceFile();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, startPC, endPC);
        }
        int startLine = lineNumberTable.getSourceLine(startPC);
        int endLine = lineNumberTable.getSourceLine(endPC);
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, startPC, endPC);
    }

    public static SourceLineAnnotation fromRawData(String className, String sourceFile, int startLine, int endLine, int startPC, int endPC) {
        if (startLine == -1) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, startPC, endPC);
        }
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, startPC, endPC);
    }

    public static SourceLineAnnotation fromVisitedInstruction(BytecodeScanningDetector visitor) {
        return SourceLineAnnotation.fromVisitedInstruction(visitor.getClassContext(), visitor, visitor.getPC());
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, MethodGen methodGen, String sourceFile, @NonNull InstructionHandle handle) {
        LineNumberTable table = methodGen.getLineNumberTable(methodGen.getConstantPool());
        String className = methodGen.getClassName();
        int bytecodeOffset = handle.getPosition();
        if (table == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, bytecodeOffset, bytecodeOffset);
        }
        int lineNumber = table.getSourceLine(handle.getPosition());
        return new SourceLineAnnotation(className, sourceFile, lineNumber, lineNumber, bytecodeOffset, bytecodeOffset);
    }

    public static SourceLineAnnotation fromVisitedInstructionRange(ClassContext classContext, MethodGen methodGen, String sourceFile, InstructionHandle start, InstructionHandle end) {
        LineNumberTable lineNumberTable = methodGen.getLineNumberTable(methodGen.getConstantPool());
        String className = methodGen.getClassName();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, start.getPosition(), end.getPosition());
        }
        int startLine = lineNumberTable.getSourceLine(start.getPosition());
        int endLine = lineNumberTable.getSourceLine(end.getPosition());
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, start.getPosition(), end.getPosition());
    }

    private static LineNumberTable getLineNumberTable(PreorderVisitor visitor) {
        Code code = visitor.getMethod().getCode();
        if (code == null) {
            return null;
        }
        return code.getLineNumberTable();
    }

    public String getClassName() {
        return this.className;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public boolean isSourceFileKnown() {
        return !this.sourceFile.equals(UNKNOWN_SOURCE_FILE);
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getSimpleClassName() {
        int lastDot = this.className.lastIndexOf(46);
        return this.className.substring(lastDot + 1);
    }

    public String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return this.className.substring(0, lastDot);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartBytecode() {
        return this.startBytecode;
    }

    public int getEndBytecode() {
        return this.endBytecode;
    }

    public boolean isUnknown() {
        return this.startLine < 0 || this.endLine < 0;
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitSourceLineAnnotation(this);
    }

    public String format(String key, ClassAnnotation primaryClass) {
        if (key.equals("hash")) {
            return "";
        }
        if (key.equals("")) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.sourceFile);
            this.appendLines(buf);
            return buf.toString();
        }
        if (key.equals("lineNumber")) {
            StringBuffer buf = new StringBuffer();
            this.appendLinesRaw(buf);
            return buf.toString();
        }
        if (key.equals("full")) {
            StringBuffer buf = new StringBuffer();
            String pkgName = this.getPackageName();
            if (!pkgName.equals("")) {
                buf.append(pkgName.replace('.', '/'));
                buf.append('/');
            }
            buf.append(this.sourceFile);
            this.appendLines(buf);
            return buf.toString();
        }
        throw new IllegalArgumentException("Unknown format key " + key);
    }

    private void appendLines(StringBuffer buf) {
        if (this.isUnknown()) {
            return;
        }
        buf.append(":[");
        this.appendLinesRaw(buf);
        buf.append(']');
    }

    private void appendLinesRaw(StringBuffer buf) {
        if (this.isUnknown()) {
            return;
        }
        if (this.startLine == this.endLine) {
            buf.append("line ");
            buf.append(this.startLine);
        } else {
            buf.append("lines ");
            buf.append(this.startLine);
            buf.append('-');
            buf.append(this.endLine);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        String desc = this.description;
        if (desc.equals(DEFAULT_ROLE) && this.isUnknown()) {
            desc = DEFAULT_ROLE_UNKNOWN_LINE;
        }
        String pattern = I18N.instance().getAnnotationDescription(desc);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof SourceLineAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        SourceLineAnnotation other = (SourceLineAnnotation)o;
        int cmp = this.className.compareTo(other.className);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.startLine - other.startLine;
        if (cmp != 0) {
            return cmp;
        }
        return this.endLine - other.endLine;
    }

    public int hashCode() {
        return this.className.hashCode() + this.startLine + 3 * this.endLine;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceLineAnnotation)) {
            return false;
        }
        SourceLineAnnotation other = (SourceLineAnnotation)o;
        return this.className.equals(other.className) && this.startLine == other.startLine && this.endLine == other.endLine;
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages) throws IOException {
        String role;
        String classname = this.getClassName();
        String packageName = "";
        if (classname.indexOf(46) > 0) {
            packageName = classname.substring(0, 1 + classname.lastIndexOf(46));
        }
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("classname", classname);
        int n = this.getStartLine();
        if (n >= 0) {
            attributeList.addAttribute("start", String.valueOf(n));
        }
        if ((n = this.getEndLine()) >= 0) {
            attributeList.addAttribute("end", String.valueOf(n));
        }
        if ((n = this.getStartBytecode()) >= 0) {
            attributeList.addAttribute("startBytecode", String.valueOf(n));
        }
        if ((n = this.getEndBytecode()) >= 0) {
            attributeList.addAttribute("endBytecode", String.valueOf(n));
        }
        if (this.isSourceFileKnown()) {
            attributeList.addAttribute("sourcefile", this.sourceFile);
            attributeList.addAttribute("sourcepath", packageName.replace('.', '/') + this.sourceFile);
        }
        if (!(role = this.getDescription()).equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", this.getDescription());
        }
        if (this.synthetic) {
            attributeList.addAttribute("synthetic", "true");
        }
        if (addMessages) {
            xmlOutput.openTag(ELEMENT_NAME, attributeList);
            xmlOutput.openTag("Message");
            xmlOutput.writeText(this.toString());
            xmlOutput.closeTag("Message");
            xmlOutput.closeTag(ELEMENT_NAME);
        } else {
            xmlOutput.openCloseTag(ELEMENT_NAME, attributeList);
        }
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isSignificant() {
        return false;
    }

    static SourceLineAnnotation getSourceAnnotationForMethod(String className, String methodName, String methodSig) {
        JavaClassAndMethod targetMethod = null;
        Code code = null;
        try {
            Method method;
            JavaClass targetClass = AnalysisContext.currentAnalysisContext().lookupClass(className);
            targetMethod = Hierarchy.findMethod(targetClass, methodName, methodSig);
            if (targetMethod != null && (method = targetMethod.getMethod()) != null) {
                code = method.getCode();
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        SourceInfoMap sourceInfoMap = AnalysisContext.currentAnalysisContext().getSourceInfoMap();
        SourceInfoMap.SourceLineRange range = sourceInfoMap.getMethodLine(className, methodName, methodSig);
        if (range != null) {
            return new SourceLineAnnotation(className, AnalysisContext.currentAnalysisContext().lookupSourceFile(className), range.getStart(), range.getEnd(), 0, code == null ? -1 : code.getLength());
        }
        if (sourceInfoMap.fallBackToClassfile() && targetMethod != null) {
            return SourceLineAnnotation.forEntireMethod(targetMethod.getJavaClass(), targetMethod.getMethod());
        }
        return SourceLineAnnotation.createUnknown(className);
    }

    static SourceLineAnnotation getSourceAnnotationForClass(String className, String sourceFileName) {
        int lastLine = -1;
        int firstLine = Integer.MAX_VALUE;
        try {
            JavaClass targetClass = AnalysisContext.currentAnalysisContext().lookupClass(className);
            for (Method m : targetClass.getMethods()) {
                LineNumberTable table;
                Code c = m.getCode();
                if (c == null || (table = c.getLineNumberTable()) == null) continue;
                for (LineNumber line : table.getLineNumberTable()) {
                    lastLine = Math.max(lastLine, line.getLineNumber());
                    firstLine = Math.min(firstLine, line.getLineNumber());
                }
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        if (firstLine < Integer.MAX_VALUE) {
            return new SourceLineAnnotation(className, sourceFileName, firstLine, lastLine, -1, -1);
        }
        return SourceLineAnnotation.createUnknown(className, sourceFileName);
    }
}

