/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Footprint;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectStats
implements XMLWriteable,
Cloneable {
    private static final String TIMESTAMP_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";
    private SortedMap<String, PackageStats> packageStatsMap;
    private int[] totalErrors = new int[]{0, 0, 0, 0, 0};
    private int totalClasses = 0;
    private int totalSize;
    private Date timestamp;
    private Footprint baseFootprint;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.totalClasses).append(" classes: ");
        for (PackageStats pStats : this.getPackageStats()) {
            for (PackageStats.ClassStats cStats : pStats.getClassStats()) {
                buf.append(cStats.getName()).append(" ");
            }
        }
        return buf.toString();
    }

    public ProjectStats() {
        this.packageStatsMap = new TreeMap<String, PackageStats>();
        this.timestamp = new Date();
        this.baseFootprint = new Footprint();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getCodeSize() {
        return this.totalSize;
    }

    public int getTotalBugs() {
        return this.totalErrors[0];
    }

    public int getBugsOfPriority(int priority) {
        return this.totalErrors[priority];
    }

    public void setTimestamp(String timestamp) throws ParseException {
        this.timestamp = new SimpleDateFormat(TIMESTAMP_FORMAT, Locale.ENGLISH).parse(timestamp);
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = new Date(timestamp);
    }

    public int getNumClasses() {
        return this.totalClasses;
    }

    public void addClass(String className, boolean isInterface, int size) {
        this.addClass(className, null, isInterface, size);
    }

    public void addClass(String className, @CheckForNull String sourceFile, boolean isInterface, int size) {
        int lastDot = className.lastIndexOf(46);
        String packageName = lastDot < 0 ? "" : className.substring(0, lastDot);
        PackageStats stat = this.getPackageStats(packageName);
        stat.addClass(className, sourceFile, isInterface, size);
        ++this.totalClasses;
        this.totalSize += size;
    }

    public PackageStats.ClassStats getClassStats(String className) {
        int lastDot = className.lastIndexOf(46);
        String packageName = lastDot < 0 ? "" : className.substring(0, lastDot);
        PackageStats stat = this.getPackageStats(packageName);
        return stat.getClassStatsOrNull(className);
    }

    public void addBug(BugInstance bug) {
        PackageStats stat = this.getPackageStats(bug.getPrimaryClass().getPackageName());
        stat.addError(bug);
        this.totalErrors[0] = this.totalErrors[0] + 1;
        int priority = bug.getPriority();
        if (priority >= 1) {
            int n = Math.min(priority, this.totalErrors.length - 1);
            this.totalErrors[n] = this.totalErrors[n] + 1;
        }
    }

    public void clearBugCounts() {
        for (int i = 0; i < this.totalErrors.length; ++i) {
            this.totalErrors[i] = 0;
        }
        for (PackageStats stats : this.packageStatsMap.values()) {
            stats.clearBugCounts();
        }
    }

    public void recomputeFromClassStats() {
        for (int i = 0; i < this.totalErrors.length; ++i) {
            this.totalErrors[i] = 0;
        }
        this.totalSize = 0;
        for (PackageStats stats : this.packageStatsMap.values()) {
            stats.recomputeFromClassStats();
            this.totalSize += stats.size();
            for (int i = 0; i < this.totalErrors.length; ++i) {
                int n = i;
                this.totalErrors[n] = this.totalErrors[n] + stats.getBugsAtPriority(i);
            }
        }
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        long peakMemory;
        long clockTime;
        xmlOutput.startTag("FindBugsSummary");
        xmlOutput.addAttribute("timestamp", new SimpleDateFormat(TIMESTAMP_FORMAT, Locale.ENGLISH).format(this.timestamp));
        xmlOutput.addAttribute("total_classes", String.valueOf(this.totalClasses));
        xmlOutput.addAttribute("total_bugs", String.valueOf(this.totalErrors[0]));
        xmlOutput.addAttribute("total_size", String.valueOf(this.totalSize));
        xmlOutput.addAttribute("num_packages", String.valueOf(this.packageStatsMap.size()));
        Footprint delta = new Footprint(this.baseFootprint);
        NumberFormat twoPlaces = NumberFormat.getInstance(Locale.ENGLISH);
        twoPlaces.setMinimumFractionDigits(2);
        twoPlaces.setMaximumFractionDigits(2);
        twoPlaces.setGroupingUsed(false);
        long cpuTime = delta.getCpuTime();
        if (cpuTime >= 0L) {
            xmlOutput.addAttribute("cpu_seconds", twoPlaces.format((double)cpuTime / 1.0E9));
        }
        if ((clockTime = delta.getClockTime()) >= 0L) {
            xmlOutput.addAttribute("clock_seconds", twoPlaces.format((double)clockTime / 1000.0));
        }
        if ((peakMemory = delta.getPeakMemory()) >= 0L) {
            xmlOutput.addAttribute("peak_mbytes", twoPlaces.format((double)peakMemory / 1048576.0));
        }
        xmlOutput.addAttribute("alloc_mbytes", twoPlaces.format((double)Runtime.getRuntime().maxMemory() / 1048576.0));
        long gcTime = delta.getCollectionTime();
        if (gcTime >= 0L) {
            xmlOutput.addAttribute("gc_seconds", twoPlaces.format((double)gcTime / 1000.0));
        }
        PackageStats.writeBugPriorities(xmlOutput, this.totalErrors);
        xmlOutput.stopTag(false);
        for (PackageStats stats : this.packageStatsMap.values()) {
            stats.writeXML(xmlOutput);
        }
        xmlOutput.closeTag("FindBugsSummary");
    }

    public void reportSummary(OutputStream out) throws IOException {
        OutputStreamXMLOutput xmlOutput = new OutputStreamXMLOutput(out);
        this.writeXML(xmlOutput);
        xmlOutput.finish();
    }

    public void transformSummaryToHTML(Writer htmlWriter) throws IOException, TransformerException {
        ByteArrayOutputStream summaryOut = new ByteArrayOutputStream(8096);
        this.reportSummary(summaryOut);
        StreamSource in = new StreamSource(new ByteArrayInputStream(summaryOut.toByteArray()));
        StreamResult out = new StreamResult(htmlWriter);
        InputStream xslInputStream = this.getClass().getClassLoader().getResourceAsStream("summary.xsl");
        if (xslInputStream == null) {
            throw new IOException("Could not load summary stylesheet");
        }
        StreamSource xsl = new StreamSource(xslInputStream);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer(xsl);
        transformer.transform(in, out);
        Reader rdr = in.getReader();
        if (rdr != null) {
            rdr.close();
        }
        htmlWriter.close();
        InputStream is = xsl.getInputStream();
        if (is != null) {
            is.close();
        }
    }

    public Collection<PackageStats> getPackageStats() {
        return this.packageStatsMap.values();
    }

    private PackageStats getPackageStats(String packageName) {
        PackageStats stat = (PackageStats)this.packageStatsMap.get(packageName);
        if (stat == null) {
            stat = new PackageStats(packageName);
            this.packageStatsMap.put(packageName, stat);
        }
        return stat;
    }

    public void addStats(ProjectStats stats2) {
        this.totalSize += stats2.totalSize;
        this.totalClasses += stats2.totalClasses;
        for (int i = 0; i < this.totalErrors.length; ++i) {
            int n = i;
            this.totalErrors[n] = this.totalErrors[n] + stats2.totalErrors[i];
        }
        for (Map.Entry<String, PackageStats> entry : stats2.packageStatsMap.entrySet()) {
            String key = entry.getKey();
            PackageStats pkgStats2 = entry.getValue();
            if (this.packageStatsMap.containsKey(key)) {
                PackageStats pkgStats = (PackageStats)this.packageStatsMap.get(key);
                for (PackageStats.ClassStats classStats : pkgStats2.getClassStats()) {
                    pkgStats.addClass(classStats);
                }
                continue;
            }
            this.packageStatsMap.put(key, pkgStats2);
        }
    }
}

