/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public abstract class FindBugsCommandLine
extends CommandLine {
    protected AnalysisFeatureSetting[] settingList = FindBugs.DEFAULT_EFFORT;
    protected Project project = new Project();

    public FindBugsCommandLine() {
        this.addOption("-project", "project", "analyze given project");
        this.addOption("-home", "home directory", "specify FindBugs home directory");
        this.addOption("-pluginList", "jar1[" + File.pathSeparator + "jar2...]", "specify list of plugin Jar files to load");
        this.addSwitchWithOptionalExtraPart("-effort", "min|default|max", "set analysis effort level");
        this.addSwitch("-adjustExperimental", "lower priority of experimental Bug Patterns");
        this.addSwitch("-workHard", "ensure analysis effort is at least 'default'");
        this.addSwitch("-conserveSpace", "same as -effort:min (for backward compatibility)");
    }

    public AnalysisFeatureSetting[] getSettingList() {
        return this.settingList;
    }

    public Project getProject() {
        return this.project;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOption(String option, String optionExtraPart) {
        if (option.equals("-effort")) {
            if (optionExtraPart.equals("min")) {
                this.settingList = FindBugs.MIN_EFFORT;
                return;
            } else if (optionExtraPart.equals("less")) {
                this.settingList = FindBugs.LESS_EFFORT;
                return;
            } else if (optionExtraPart.equals("default")) {
                this.settingList = FindBugs.DEFAULT_EFFORT;
                return;
            } else if (optionExtraPart.equals("more")) {
                this.settingList = FindBugs.MORE_EFFORT;
                return;
            } else {
                if (!optionExtraPart.equals("max")) throw new IllegalArgumentException("-effort:<value> must be one of min,default,more,max");
                this.settingList = FindBugs.MAX_EFFORT;
            }
            return;
        } else if (option.equals("-workHard")) {
            if (this.settingList == FindBugs.MAX_EFFORT) return;
            this.settingList = FindBugs.MORE_EFFORT;
            return;
        } else if (option.equals("-conserveSpace")) {
            this.settingList = FindBugs.MIN_EFFORT;
            return;
        } else {
            if (!option.equals("-adjustExperimental")) throw new IllegalStateException();
            BugInstance.setAdjustExperimental(true);
        }
    }

    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        if (option.equals("-home")) {
            FindBugs.setHome(argument);
        } else if (option.equals("-pluginList")) {
            String pluginListStr = argument;
            ArrayList<URL> pluginList = new ArrayList<URL>();
            StringTokenizer tok = new StringTokenizer(pluginListStr, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                pluginList.add(new File(tok.nextToken()).toURL());
            }
            DetectorFactoryCollection.rawInstance().setPluginList(pluginList.toArray(new URL[pluginList.size()]));
        } else if (option.equals("-project")) {
            this.project = this.readProject(argument);
        } else {
            throw new IllegalStateException();
        }
    }

    private Project readProject(String argument) throws IOException {
        String projectFileName = argument;
        File projectFile = new File(projectFileName);
        if (projectFile.isDirectory()) {
            String name = projectFile.getAbsolutePath() + File.separator + projectFile.getName() + ".xml";
            File f = new File(name);
            SortedBugCollection bugCollection = new SortedBugCollection();
            try {
                Project project = new Project();
                bugCollection.readXML(f.getPath(), project);
                return project;
            }
            catch (DocumentException e) {
                IOException ioe = new IOException("Couldn't read saved XML in project directory");
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (projectFileName.endsWith(".xml") || projectFileName.endsWith(".fbp")) {
            try {
                this.project = Project.readXML(projectFile);
                return this.project;
            }
            catch (DocumentException e) {
                IOException ioe = new IOException("Couldn't read saved FindBugs project");
                ioe.initCause(e);
                throw ioe;
            }
            catch (SAXException e) {
                IOException ioe = new IOException("Couldn't read saved FindBugs project");
                ioe.initCause(e);
                throw ioe;
            }
        }
        projectFileName = new File(projectFileName).getAbsolutePath();
        try {
            Project project = new Project();
            project.read(projectFileName);
            return project;
        }
        catch (IOException e) {
            System.err.println("Error opening " + projectFileName);
            e.printStackTrace(System.err);
            throw e;
        }
    }
}

